/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.StringReader;
import java.net.URI;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.SourceLocationImpl;
import org.apache.ode.bpel.compiler.WsdlFinderXMLEntityResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.XMLSchemaType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.ode.utils.xsd.SchemaModelImpl;
import org.apache.ode.utils.xsd.XSUtils;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSDLRegistry {
    private static final Log __log = LogFactory.getLog(WSDLRegistry.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private final HashMap<String, ArrayList<Definition4BPEL>> _definitions = new HashMap();
    private final Map<URI, byte[]> _schemas = new HashMap<URI, byte[]>();
    private final Map<URI, String> _internalSchemas = new HashMap<URI, String>();
    private SchemaModel _model;
    private CompilerContext _ctx;

    WSDLRegistry(CompilerContext compilerContext) {
        this._schemas.put(URI.create("http://fivesight.com/bogus/namespace"), "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://fivesight.com/bogus/namespace\"><xsd:simpleType name=\"__bogusType__\"><xsd:restriction base=\"xsd:normalizedString\"/></xsd:simpleType></xsd:schema>".getBytes());
        this._ctx = compilerContext;
    }

    public Definition4BPEL[] getDefinitions() {
        ArrayList<Definition4BPEL> arrayList = new ArrayList<Definition4BPEL>();
        for (ArrayList<Definition4BPEL> arrayList2 : this._definitions.values()) {
            for (Definition4BPEL definition4BPEL : arrayList2) {
                arrayList.add(definition4BPEL);
            }
        }
        return arrayList.toArray(new Definition4BPEL[arrayList.size()]);
    }

    public SchemaModel getSchemaModel() {
        if (this._model == null) {
            this._model = SchemaModelImpl.newModel(this._schemas);
        }
        assert (this._model != null);
        return this._model;
    }

    public void addDefinition(Definition4BPEL definition4BPEL, ResourceFinder resourceFinder, URI uRI) throws CompilationException {
        if (definition4BPEL == null) {
            throw new NullPointerException("def=null");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addDefinition(" + definition4BPEL.getTargetNamespace() + " from " + definition4BPEL.getDocumentBaseURI() + ")"));
        }
        if (this._definitions.containsKey(definition4BPEL.getTargetNamespace()) && __log.isInfoEnabled()) {
            __log.info((Object)("WSDL at " + uRI + " is a duplicate import, your documents " + "should all be in different namespaces (its's not nice but will still work)."));
        }
        ArrayList<Definition4BPEL> arrayList = null;
        arrayList = this._definitions.get(definition4BPEL.getTargetNamespace()) == null ? new ArrayList<Definition4BPEL>() : this._definitions.get(definition4BPEL.getTargetNamespace());
        arrayList.add(definition4BPEL);
        this._definitions.put(definition4BPEL.getTargetNamespace(), arrayList);
        this.captureSchemas(definition4BPEL, resourceFinder, uRI);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Processing <imports> in " + definition4BPEL.getDocumentBaseURI()));
        }
        for (List list : definition4BPEL.getImports().values()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Import import_ : list) {
                Definition4BPEL definition4BPEL2;
                if (hashSet.contains(import_.getNamespaceURI()) && __log.isInfoEnabled()) {
                    __log.info((Object)("WSDL at " + import_.getLocationURI() + " imports several documents in the same " + "namespace (" + import_.getNamespaceURI() + "), your documents should all be in different " + "namespaces (its's not nice but will still work)."));
                }
                if ((definition4BPEL2 = (Definition4BPEL)import_.getDefinition()) == null) {
                    CompilationException compilationException = new CompilationException(__cmsgs.errWsdlImportNotFound(import_.getNamespaceURI(), import_.getLocationURI()).setSource(new SourceLocationImpl(uRI)));
                    if (this._ctx == null) {
                        throw compilationException;
                    }
                    this._ctx.recoveredFromError(new SourceLocationImpl(uRI), compilationException);
                    continue;
                }
                hashSet.add(import_.getNamespaceURI());
                this.addDefinition((Definition4BPEL)import_.getDefinition(), resourceFinder, uRI.resolve(import_.getLocationURI()));
            }
        }
    }

    public void addSchemas(Map<URI, byte[]> map) {
        this._schemas.putAll(map);
    }

    private void captureSchemas(Definition definition, ResourceFinder resourceFinder, URI uRI) throws CompilationException {
        Types types;
        assert (definition != null);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Processing XSD schemas in " + definition.getDocumentBaseURI()));
        }
        if ((types = definition.getTypes()) != null) {
            for (ExtensibilityElement extensibilityElement : definition.getTypes().getExtensibilityElements()) {
                Object object;
                Object object2;
                Object object3;
                if (!(extensibilityElement instanceof XMLSchemaType)) continue;
                String string = ((XMLSchemaType)extensibilityElement).getXMLSchema();
                WsdlFinderXMLEntityResolver wsdlFinderXMLEntityResolver = new WsdlFinderXMLEntityResolver(resourceFinder, uRI, this._internalSchemas, false);
                try {
                    object3 = XSUtils.captureSchema((URI)uRI, (String)string, (XMLEntityResolver)wsdlFinderXMLEntityResolver);
                    this._schemas.putAll((Map<URI, byte[]>)object3);
                    try {
                        object2 = DOMUtils.parse((InputSource)new InputSource(new StringReader(string)));
                        object = object2.getDocumentElement().getAttribute("targetNamespace");
                        if (object != null && ((String)object).length() > 0) {
                            this._internalSchemas.put(new URI((String)object), string);
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Couldn't parse schema in " + definition.getTargetNamespace(), exception);
                    }
                }
                catch (XsdException xsdException) {
                    __log.debug((Object)("captureSchemas: capture failed for " + uRI), (Throwable)xsdException);
                    object2 = new LinkedList();
                    while (object3 != null) {
                        ((LinkedList)object2).addFirst(object3);
                        object3 = object3.getPrevious();
                    }
                    object = ((AbstractSequentialList)object2).iterator();
                    while (object.hasNext()) {
                        XsdException xsdException2 = (XsdException)((Object)object.next());
                        CompilationException compilationException = new CompilationException(__cmsgs.errSchemaError(xsdException2.getDetailMessage()).setSource(new SourceLocationImpl(uRI)));
                        if (this._ctx != null) {
                            this._ctx.recoveredFromError(new SourceLocationImpl(uRI), compilationException);
                            continue;
                        }
                        throw compilationException;
                    }
                }
                this._model = null;
            }
        }
    }

    public Property getProperty(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getProperty(qName) == null) continue;
            return definition4BPEL.getProperty(qName);
        }
        return null;
    }

    public PropertyAlias getPropertyAlias(QName qName, QName qName2) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPropertyAlias(qName, qName2) == null) continue;
            return definition4BPEL.getPropertyAlias(qName, qName2);
        }
        return null;
    }

    public PartnerLinkType getPartnerLinkType(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPartnerLinkType(qName) == null) continue;
            return definition4BPEL.getPartnerLinkType(qName);
        }
        return null;
    }

    public PortType getPortType(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getPortType(qName) == null) continue;
            return definition4BPEL.getPortType(qName);
        }
        return null;
    }

    public Message getMessage(QName qName) {
        ArrayList<Definition4BPEL> arrayList = this._definitions.get(qName.getNamespaceURI());
        if (arrayList == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : arrayList) {
            if (definition4BPEL == null || definition4BPEL.getMessage(qName) == null) continue;
            return definition4BPEL.getMessage(qName);
        }
        return null;
    }
}

