/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlFinderXMLEntityResolver
implements XMLEntityResolver {
    private static final Log __log = LogFactory.getLog(WsdlFinderXMLEntityResolver.class);
    private boolean _failIfNotFound = true;
    private ResourceFinder _wsdlFinder;
    private Map<URI, String> _internalSchemas = new HashMap<URI, String>();
    private URI _baseURI;

    public WsdlFinderXMLEntityResolver(ResourceFinder resourceFinder, URI uRI, Map<URI, String> map, boolean bl) {
        this._wsdlFinder = resourceFinder;
        this._baseURI = uRI;
        this._internalSchemas = map;
        this._failIfNotFound = bl;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEntity(" + xMLResourceIdentifier + ")"));
        }
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        if (xMLResourceIdentifier.getLiteralSystemId() == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("resolveEntity: no schema location for " + xMLResourceIdentifier.getNamespace()));
            }
            return null;
        }
        URI uRI = xMLResourceIdentifier.getExpandedSystemId() != null ? this._baseURI.resolve(xMLResourceIdentifier.getExpandedSystemId()) : this._baseURI.resolve(xMLResourceIdentifier.getLiteralSystemId());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEntity: Expecting to find " + xMLResourceIdentifier.getNamespace() + " at " + uRI));
        }
        if (this._internalSchemas.get(uRI) != null) {
            xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(this._internalSchemas.get(uRI).getBytes()));
            return xMLInputSource;
        }
        try {
            InputStream inputStream = this._wsdlFinder.openResource(uRI);
            if (inputStream == null) {
                __log.debug((Object)("resolveEntity: resource not found: " + uRI));
                throw new IOException("Resource not found: " + uRI);
            }
            xMLInputSource.setByteStream(inputStream);
        }
        catch (IOException iOException) {
            __log.debug((Object)("resolveEntity: IOException opening " + uRI), (Throwable)iOException);
            if (this._failIfNotFound) {
                __log.debug((Object)"resolveEntity: failIfNotFound is true, rethrowing...");
                throw iOException;
            }
            __log.debug((Object)"resolveEntity: failIfNotFound is false, returning null");
            return null;
        }
        catch (Exception exception) {
            __log.debug((Object)("resolveEntity: unexpected error: " + uRI));
            throw new IOException("Unexpected error loading resource: " + uRI);
        }
        return xMLInputSource;
    }
}

