/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath10.compiler;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.CompilationExceptionWrapper;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompileUriResolver;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;

class JaxenBpelHandler
extends JaxenHandler {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _out;
    private NSContext _nsContext;
    private String _bpelNsUril;

    JaxenBpelHandler(String string, OXPath10Expression oXPath10Expression, NSContext nSContext, CompilerContext compilerContext) {
        this._bpelNsUril = string;
        this._cctx = compilerContext;
        this._nsContext = nSContext;
        this._out = oXPath10Expression;
        assert (nSContext != null);
        assert (compilerContext != null);
        assert (oXPath10Expression != null);
    }

    public void variableReference(String string, String string2) throws JaxenException {
        super.variableReference(string, string2);
        if ("ode".equals(string) && "pid".equals(string2)) {
            return;
        }
        if (this._out instanceof OXPath10ExpressionBPEL20) {
            OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20 = (OXPath10ExpressionBPEL20)this._out;
            try {
                if (oXPath10ExpressionBPEL20.isJoinExpression) {
                    OLink oLink = this._cctx.resolveLink(string2);
                    this._out.links.put(string2, oLink);
                } else {
                    int n = string2.indexOf(46);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    OScope.Variable variable = this._cctx.resolveVariable(string2);
                    this._out.vars.put(string2, variable);
                }
            }
            catch (CompilationException compilationException) {
                throw new CompilationExceptionWrapper(compilationException);
            }
        }
    }

    public void endXPath() throws JaxenException {
        super.endXPath();
    }

    public void endFunction() throws JaxenException {
        block9: {
            super.endFunction();
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.peekFrame().getLast();
            String string = functionCallExpr.getPrefix();
            if (string == null || "".equals(string)) {
                return;
            }
            String string2 = this._nsContext.getNamespaceURI(string);
            if (string2 == null) {
                throw new CompilationException(__msgs.errUndeclaredFunctionPrefix(string, functionCallExpr.getFunctionName()));
            }
            if (this.isBpelNamespace(string2)) {
                try {
                    if ("getVariableData".equals(functionCallExpr.getFunctionName())) {
                        this.compileGetVariableData(functionCallExpr);
                        break block9;
                    }
                    if ("getVariableProperty".equals(functionCallExpr.getFunctionName())) {
                        this.compileGetVariableProperty(functionCallExpr);
                        break block9;
                    }
                    if ("getLinkStatus".equals(functionCallExpr.getFunctionName())) {
                        this.compileGetLinkStatus(functionCallExpr);
                        break block9;
                    }
                    if ("doXslTransform".equals(functionCallExpr.getFunctionName())) {
                        this.compileDoXslTransform(functionCallExpr);
                        break block9;
                    }
                    throw new CompilationException(__msgs.errUnknownBpelFunction(functionCallExpr.getFunctionName()));
                }
                catch (CompilationException compilationException) {
                    throw new CompilationExceptionWrapper(compilationException);
                }
            }
        }
    }

    private boolean isBpelNamespace(String string) {
        return string.equals(this._bpelNsUril);
    }

    private void compileGetLinkStatus(FunctionCallExpr functionCallExpr) throws CompilationException {
        List list = functionCallExpr.getParameters();
        if (list.size() != 1) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(functionCallExpr.getFunctionName()));
        }
        String string = this.getLiteralFromExpression((Expr)list.get(0));
        OLink oLink = this._cctx.resolveLink(string);
        this._out.links.put(string, oLink);
    }

    private void compileGetVariableData(FunctionCallExpr functionCallExpr) throws CompilationException {
        List list = functionCallExpr.getParameters();
        if (list.size() < 1 || list.size() > 3) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(functionCallExpr.getFunctionName()));
        }
        String string = this.getLiteralFromExpression((Expr)list.get(0));
        String string2 = list.size() > 1 ? this.getLiteralFromExpression((Expr)list.get(1)) : null;
        String string3 = list.size() > 2 ? this.getLiteralFromExpression((Expr)list.get(2)) : null;
        OScope.Variable variable = this._cctx.resolveVariable(string);
        OMessageVarType.Part part = string2 != null ? this._cctx.resolvePart(variable, string2) : null;
        OExpression oExpression = null;
        if (string3 != null) {
            oExpression = this._cctx.compileExpr(string3, this._nsContext);
        }
        this._out.addGetVariableDataSig(string, string2, string3, new OXPath10Expression.OSigGetVariableData(this._cctx.getOProcess(), variable, part, oExpression));
    }

    private void compileGetVariableProperty(FunctionCallExpr functionCallExpr) throws CompilationException {
        List list = functionCallExpr.getParameters();
        if (list.size() != 2) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
        }
        String string = this.getLiteralFromExpression((Expr)list.get(0));
        OScope.Variable variable = this._cctx.resolveVariable(string);
        this._out.vars.put(string, variable);
        String string2 = this.getLiteralFromExpression((Expr)list.get(1));
        QName qName = this._nsContext.derefQName(string2);
        if (qName == null) {
            throw new CompilationException(__msgs.errInvalidQName(string2));
        }
        OProcess.OProperty oProperty = this._cctx.resolveProperty(qName);
        this._cctx.resolvePropertyAlias(variable, qName);
        this._out.properties.put(string2, oProperty);
        this._out.vars.put(string, variable);
    }

    private void compileDoXslTransform(FunctionCallExpr functionCallExpr) throws CompilationException {
        List list = functionCallExpr.getParameters();
        if (list.size() < 2 || list.size() % 2 != 0) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
        }
        String string = this.getLiteralFromExpression((Expr)list.get(0));
        OXslSheet oXslSheet = this._cctx.compileXslt(string);
        try {
            XslTransformHandler.getInstance().parseXSLSheet(oXslSheet.uri, oXslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(this._cctx, this._out));
        }
        catch (Exception exception) {
            throw new CompilationException(__msgs.errInvalidNumberOfArguments(string));
        }
        this._out.xslSheets.put(oXslSheet.uri, oXslSheet);
    }

    private String getLiteralFromExpression(Expr expr) throws CompilationException {
        if ((expr = expr.simplify()) instanceof LiteralExpr) {
            return ((LiteralExpr)expr).getLiteral();
        }
        throw new CompilationException(__msgs.errLiteralExpected(expr.getText()));
    }
}

