/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompilationErrorListener;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.SaxonContext;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.compiler.XPath20ExpressionCompilerBPEL20;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath20ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XPath20ExpressionCompilerBPEL20.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XPath20ExpressionCompilerImpl(String string) {
        this._bpelNS = string;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.elang.xpath20.runtime.XPath20ExpressionRuntime");
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xslCompilationErrorListener = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener((ErrorListener)xslCompilationErrorListener);
    }

    @Override
    public OExpression compileJoinCondition(Object object) throws CompilationException {
        return this._compile((Expression)object, true);
    }

    @Override
    public OExpression compile(Object object) throws CompilationException {
        return this._compile((Expression)object, false);
    }

    @Override
    public OLValueExpression compileLValue(Object object) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)object, false);
    }

    private OExpression _compile(Expression expression, boolean bl) throws CompilationException {
        OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20 = new OXPath20ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, bl);
        oXPath20ExpressionBPEL20.namespaceCtx = expression.getNamespaceContext();
        this.doJaxpCompile(oXPath20ExpressionBPEL20, expression);
        return oXPath20ExpressionBPEL20;
    }

    private void doJaxpCompile(OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new IllegalStateException("XPath string and xpath node are both null");
        }
        if (node.getNodeType() != 3) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString((Node)node)));
        }
        String string = node.getNodeValue();
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString((Node)node), "empty string"));
        }
        oXPath20ExpressionBPEL20.xpath = string;
        try {
            __log.debug((Object)("Compiling expression " + string));
            XPathFactoryImpl xPathFactoryImpl = new XPathFactoryImpl();
            JaxpFunctionResolver jaxpFunctionResolver = new JaxpFunctionResolver(this._compilerContext, oXPath20ExpressionBPEL20, expression.getNamespaceContext(), this._bpelNS);
            xPathFactoryImpl.setXPathFunctionResolver((XPathFunctionResolver)jaxpFunctionResolver);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(this._compilerContext, (OXPath10ExpressionBPEL20)oXPath20ExpressionBPEL20);
            xPathFactoryImpl.setXPathVariableResolver((XPathVariableResolver)jaxpVariableResolver);
            XPathEvaluator xPathEvaluator = (XPathEvaluator)xPathFactoryImpl.newXPath();
            xPathEvaluator.setStaticContext((StandaloneContext)new SaxonContext(xPathFactoryImpl.getConfiguration(), jaxpVariableResolver, jaxpFunctionResolver));
            xPathEvaluator.setXPathFunctionResolver((XPathFunctionResolver)jaxpFunctionResolver);
            xPathEvaluator.setNamespaceContext((NamespaceContext)expression.getNamespaceContext());
            xPathEvaluator.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            __log.debug((Object)xPathExpressionException);
            __log.info((Object)("Couldn't validate properly expression " + string));
        }
        catch (WrappedResolverException wrappedResolverException) {
            if (wrappedResolverException._compilationMsg != null) {
                throw new CompilationException(wrappedResolverException._compilationMsg, (Throwable)wrappedResolverException);
            }
            if (wrappedResolverException.getCause() instanceof CompilationException) {
                throw (CompilationException)wrappedResolverException.getCause();
            }
            throw wrappedResolverException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }
}

