/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.BpelCompiler11;
import org.apache.ode.bpel.compiler.BpelCompiler20;
import org.apache.ode.bpel.compiler.BpelCompiler20Draft;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.SourceLocationImpl;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelC {
    private static final Log __log = LogFactory.getLog(BpelC.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    public static final String PROCESS_CUSTOM_PROPERTIES = "customProps";
    private CompileListener _compileListener;
    public OutputStream _outputStream = null;
    private File _bpelFile;
    private File _suDir;
    private ResourceFinder _wsdlFinder;
    private URI _bpel11wsdl;
    private Map<String, Object> _compileProperties;
    private boolean _dryRun = false;

    public static BpelC newBpelCompiler() {
        return new BpelC();
    }

    private BpelC() {
    }

    protected void finalize() throws Throwable {
        this.invalidate();
        super.finalize();
    }

    private void invalidate() {
        this.setResourceFinder(null);
        this.setCompileListener(null);
        this.setOutputStream(null);
    }

    public void setCompileListener(CompileListener compileListener) {
        this._compileListener = compileListener;
    }

    public void setDryRun(boolean bl) {
        this._dryRun = bl;
    }

    public void setResourceFinder(ResourceFinder resourceFinder) {
        this._wsdlFinder = resourceFinder;
    }

    public void setProcessWSDL(URI uRI) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding WSDL import: \"" + uRI.toASCIIString() + "\"."));
        }
        this._bpel11wsdl = uRI;
    }

    public void setCompileProperties(Map<String, Object> map) {
        this._compileProperties = map;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._outputStream = outputStream;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Sett output to stream " + outputStream));
        }
    }

    public void setBaseDirectory(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'baseDir' is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory " + file + " does not exist");
        }
        this._suDir = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(final Process process, String string) throws CompilationException, IOException {
        CompilationMessage compilationMessage;
        BpelCompiler bpelCompiler;
        Object object;
        ResourceFinder resourceFinder;
        if (process == null) {
            throw new NullPointerException("Attempt to compile NULL process.");
        }
        this.logCompilationMessage(__cmsgs.infCompilingProcess());
        if (this._wsdlFinder != null) {
            resourceFinder = this._wsdlFinder;
        } else {
            object = this._suDir != null ? this._suDir : this._bpelFile.getParentFile();
            resourceFinder = new DefaultResourceFinder(this._bpelFile.getAbsoluteFile().getParentFile(), ((File)object).getAbsoluteFile());
        }
        object = new CompileListener(){

            public void onCompilationMessage(CompilationMessage compilationMessage) {
                SourceLocation sourceLocation = compilationMessage.source;
                if (sourceLocation == null) {
                    compilationMessage.source = process;
                }
                BpelC.this.logCompilationMessage(compilationMessage);
            }
        };
        try {
            switch (process.getBpelVersion()) {
                case BPEL20: {
                    bpelCompiler = new BpelCompiler20();
                    bpelCompiler.setResourceFinder(resourceFinder);
                    if (this._bpel11wsdl == null) break;
                    compilationMessage = __cmsgs.warnWsdlUriIgnoredFor20Process();
                    this.logCompilationMessage(compilationMessage);
                    break;
                }
                case BPEL20_DRAFT: {
                    bpelCompiler = new BpelCompiler20Draft();
                    bpelCompiler.setResourceFinder(resourceFinder);
                    if (this._bpel11wsdl == null) break;
                    compilationMessage = __cmsgs.warnWsdlUriIgnoredFor20Process();
                    this.logCompilationMessage(compilationMessage);
                    break;
                }
                case BPEL11: {
                    bpelCompiler = new BpelCompiler11();
                    bpelCompiler.setResourceFinder(resourceFinder);
                    if (this._bpel11wsdl != null) {
                        bpelCompiler.addWsdlImport(new URI(this._bpelFile.getName()), this._bpel11wsdl, null);
                        break;
                    }
                    CompilationMessage compilationMessage2 = __cmsgs.errBpel11RequiresWsdl();
                    this.logCompilationMessage(compilationMessage2);
                    this.invalidate();
                    throw new CompilationException(compilationMessage2);
                }
                default: {
                    CompilationMessage compilationMessage3 = __cmsgs.errUnrecognizedBpelVersion();
                    this.logCompilationMessage(compilationMessage3);
                    this.invalidate();
                    throw new CompilationException(compilationMessage3);
                }
            }
            bpelCompiler.setCompileListener((CompileListener)object);
            if (this._compileProperties != null && this._compileProperties.get(PROCESS_CUSTOM_PROPERTIES) != null) {
                bpelCompiler.setCustomProperties((Map)this._compileProperties.get(PROCESS_CUSTOM_PROPERTIES));
            }
        }
        catch (CompilationException compilationException) {
            this.invalidate();
            throw compilationException;
        }
        catch (Exception exception) {
            CompilationMessage compilationMessage4 = __cmsgs.errBpelParseErr();
            this.logCompilationMessage(compilationMessage4);
            this.invalidate();
            throw new CompilationException(compilationMessage4, (Throwable)exception);
        }
        try {
            compilationMessage = bpelCompiler.compile(process, resourceFinder);
        }
        catch (CompilationException compilationException) {
            this.invalidate();
            throw compilationException;
        }
        if (!this._dryRun) {
            if (string != null) {
                this.setOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Writing compilation results to " + string));
                }
            } else if (this._outputStream != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Writing compilation results to " + this._outputStream.getClass().getName()));
                }
            } else {
                throw new IllegalStateException("must setOutputStream() or setOutputDirectory()!");
            }
            try {
                Serializer serializer = new Serializer(System.currentTimeMillis());
                serializer.writeOProcess((OProcess)compilationMessage, this._outputStream);
            }
            finally {
                this.invalidate();
            }
        }
    }

    public void compile(File file) throws CompilationException, IOException {
        Process process;
        Object object;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"compile(URL)");
        }
        if (file == null) {
            this.invalidate();
            throw new IllegalArgumentException("Null bpelFile");
        }
        this._bpelFile = file;
        try {
            object = new InputSource(new ByteArrayInputStream(StreamUtils.read((URL)file.toURL())));
            ((InputSource)object).setSystemId(file.getAbsolutePath());
            process = BpelObjectFactory.getInstance().parse((InputSource)object, this._bpelFile.toURI());
        }
        catch (Exception exception) {
            CompilationMessage compilationMessage = __cmsgs.errBpelParseErr().setSource(new SourceLocationImpl(file.toURI()));
            this.invalidate();
            throw new CompilationException(compilationMessage, (Throwable)exception);
        }
        assert (process != null);
        object = file.getAbsolutePath();
        String string = ((String)object).substring(0, ((String)object).lastIndexOf(".")) + ".cbp";
        this.compile(process, string);
        this.invalidate();
    }

    private void logCompilationMessage(CompilationMessage compilationMessage) {
        if (this._compileListener != null) {
            this._compileListener.onCompilationMessage(compilationMessage);
        } else {
            switch (compilationMessage.severity) {
                case 2: {
                    if (!__log.isErrorEnabled()) break;
                    __log.error((Object)compilationMessage.toErrorString());
                    break;
                }
                case 0: {
                    if (!__log.isInfoEnabled()) break;
                    __log.info((Object)compilationMessage.toErrorString());
                    break;
                }
                case 1: {
                    if (!__log.isWarnEnabled()) break;
                    __log.warn((Object)compilationMessage.toErrorString());
                }
            }
        }
    }
}

