/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.api;

import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.utils.msg.CommonMessages;
import org.apache.ode.utils.msg.MessageBundle;

public class CompilationMessage {
    public static final short INFO = 0;
    public static final short WARN = 1;
    public static final short ERROR = 2;
    public short phase;
    public short severity;
    public String code;
    public String messageText;
    public SourceLocation source;
    private static final CommonMessages __commonMsgs = (CommonMessages)MessageBundle.getMessages(CommonMessages.class);
    private static final String[] SEVERITY_LEVELS = new String[]{__commonMsgs.strInfo().toLowerCase() + ": ", __commonMsgs.strWarning().toLowerCase() + ": ", __commonMsgs.strError().toLowerCase() + ": "};

    public CompilationMessage setSource(SourceLocation sourceLocation) {
        this.source = sourceLocation;
        return this;
    }

    public String toErrorString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.source != null) {
            stringBuffer.append(this.source.getURI());
            stringBuffer.append(':');
            stringBuffer.append(this.source.getLineNo());
            stringBuffer.append(": ");
        }
        stringBuffer.append(SEVERITY_LEVELS[this.severity]);
        stringBuffer.append('[');
        stringBuffer.append(this.code);
        stringBuffer.append("] ");
        stringBuffer.append(this.messageText);
        return stringBuffer.toString();
    }

    public String toString() {
        return "CompilationMessage: " + this.toErrorString();
    }
}

