/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompileUriResolver;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10Expression;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath20ExpressionBPEL20 _out;
    private NSContext _nsContext;
    private String _bpelNS;

    public JaxpFunctionResolver(CompilerContext compilerContext, OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20, NSContext nSContext, String string) {
        this._cctx = compilerContext;
        this._bpelNS = string;
        this._nsContext = nSContext;
        this._bpelNS = string;
        this._out = oXPath20ExpressionBPEL20;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        String string;
        if (qName.getNamespaceURI() == null) {
            throw new WrappedResolverException("Undeclared namespace for " + qName);
        }
        if (qName.getNamespaceURI().equals(this._bpelNS)) {
            String string2 = qName.getLocalPart();
            if ("getVariableProperty".equals(string2)) {
                return new GetVariableProperty();
            }
            if ("doXslTransform".equals(string2)) {
                return new DoXslTransform();
            }
            throw new WrappedResolverException(__msgs.errUnknownBpelFunction(string2));
        }
        if (qName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension") && "splitToElements".equals(string = qName.getLocalPart())) {
            return new SplitToElements();
        }
        return null;
    }

    public class SplitToElements
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() < 3 || list.size() > 4) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("splitToElements"));
            }
            return "";
        }
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() < 2 || list.size() % 2 != 0) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
            }
            String string = (String)list.get(0);
            OXslSheet oXslSheet = JaxpFunctionResolver.this._cctx.compileXslt(string);
            try {
                XslTransformHandler.getInstance().parseXSLSheet(oXslSheet.uri, oXslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(JaxpFunctionResolver.this._cctx, (OXPath10Expression)JaxpFunctionResolver.this._out));
            }
            catch (Exception exception) {
                throw new CompilationException(__msgs.errXslCompilation(string, exception.toString()));
            }
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.xslSheets.put(oXslSheet.uri, oXslSheet);
            return "";
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List list) throws XPathFunctionException {
            if (list.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
            }
            String string = (String)list.get(0);
            OScope.Variable variable = JaxpFunctionResolver.this._cctx.resolveVariable(string);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(string, variable);
            String string2 = (String)list.get(1);
            QName qName = JaxpFunctionResolver.this._nsContext.derefQName(string2);
            if (qName == null) {
                throw new CompilationException(__msgs.errInvalidQName(string2));
            }
            OProcess.OProperty oProperty = JaxpFunctionResolver.this._cctx.resolveProperty(qName);
            JaxpFunctionResolver.this._cctx.resolvePropertyAlias(variable, qName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.properties.put(string2, oProperty);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(string, variable);
            return "";
        }
    }
}

