{
 this file is part of Ares
 Aresgalaxy ( http://aresgalaxy.sourceforge.net )

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 }
             

{
Description:
init application, get commandline params(any magnet URI?), look for concurrent instances
}

program Ares;

uses
  FastMM4 in 'FastMM4.pas',
  tntforms,
  Forms,
  windows,
  sysutils,
  helper_unicode in 'helper_unicode.pas',
  helper_params in 'helper_params.pas',
  ufrmmain in 'ufrmmain.pas' {ares_frmmain},
  ufrmpvt in 'ufrmpvt.pas' {frmpvt},
  ufrmemoticon in 'ufrmemoticon.pas' {frmemoticon},
  ufrmhint in 'ufrmhint.pas' {frmhint},
  uctrvol in 'uctrvol.pas' {frmctrlvol},
  ufrmpreview in 'ufrmpreview.pas' {frmpreview},
  const_win_messages in 'const_win_messages.pas',
  const_ares in 'const_ares.pas',
  msnNowPlaying in 'msnNowPlaying.pas',
  ufrmChatTab in 'ufrmChatTab.pas' {frmChatTab},
  uplaylistfrm in 'uplaylistfrm.pas' {PlaylistForm},
  ufrm_settings in 'ufrm_settings.pas' {frm_settings};

{$R *.res}
//{$E .exe}
//{$R ares.RES}

const
 ARES_FRM_CLASS='Tares_frmmain.UnicodeClass';
 STR_ARES_GLBMTX='AresGlbMtx_';
 STR_ARES_CAPTION=' Ares ';

var
 mainfrm:HWnd;
 data:string;
 nfnd,WPrm,LPrm:integer;
 WM_COPYDATA:longint=$004a;
 COPYDATA: TCopyDataStruct;
 hGlobalMutex:hwnd;
 ARES_GLOBAL_MUTEX_NAME:string;
 STR_ARES_TITLE:string=' Ares ';


Function GetUsrName: string;
Var
   UserName : string;
   UserNameLen : Dword;
Begin
   UserNameLen := 255;
   SetLength(userName, UserNameLen) ;
   If GetUserName(PChar(UserName), UserNameLen) Then Result := Copy(UserName,1,UserNameLen - 1)
    else Result := STR_UNKNOWNS;
End;

procedure DoneApplication;
begin
  with Application do
  begin
    if Handle <> 0 then ShowOwnedPopups(Handle, False);
    ShowHint := False;
    Destroying;
    DestroyComponents;
  end;
end;

function LookAtAllWindows(Handle: HWND; Temp: LongInt): BOOL; stdcall;
var
  WndName : Array[0..255] of Char;
  ClsName  : Array[0..255] of Char;

begin
result:=true;

  // Go get the windows class name
  if GetClassName(Handle,ClsName,SizeOf(ClsName))< 26 then exit;

   if StrComp(ClsName,ARES_FRM_CLASS)=0 then begin

       if GetWindowText(Handle,WndName,SizeOf(WndName)) < 6 then exit;

        if comparemem(@WndName,@STR_ARES_CAPTION[1],6) then begin
         mainfrm:=handle;
         inc(nFnd);
        end;
   end;
end;




begin
IsMultiThread:=True;

 ARES_GLOBAL_MUTEX_NAME:=STR_ARES_GLBMTX+GetUsrName;
hGlobalMutex:=OpenMutex(SYNCHRONIZE,FALSE,pchar(ARES_GLOBAL_MUTEX_NAME));

if (hGlobalMutex <> 0)  then begin

  CloseHandle(hGlobalMutex);
  sleep(500); // enough time to create form?
  NFnd:=0;
  mainfrm:=0;

  EnumWindows(@LookAtAllWindows,0);

  if NFnd > 0 then begin

     if IsWindow(mainfrm) then begin

        copydata.dwData:=2;
        copydata.cbData:=0;
        if WideParamCount=1 then begin
         data:=widestrtoutf8str(Wideparamstr(1));
          with COPYDATA do begin
            lpData:=PChar(data);
            cbData:=Length(data);
            dwData:=0;
           end;

        end else
        if WideParamCount=2 then begin
          data:=widestrtoutf8str(Wideparamstr(2));
          with COPYDATA do begin
            lpData:=PChar(data);
            cbData:=Length(data);
            dwData:=1;
           end;
        end;

          WPrm:=Application.Handle;
          LPrm:=Integer(@CopyData);
           SendMessage(mainfrm, // Who are we sending to?
                       WM_COPYDATA,  // This message enables it all
                       WPrm,       // Handle of the sender
                       LPrm // Address of the filled COPYDATASTRUCT
                       );
           ARES_GLOBAL_MUTEX_NAME:='';
           exit;
      end;

  end;

  end else begin

    hGlobalMutex:=CreateMutex(nil,TRUE,pchar(ARES_GLOBAL_MUTEX_NAME));

    try

    application.Initialize;
    application.Title:=' Ares ';
    application.ShowMainForm:=false;
    Application.CreateForm(Tares_frmmain, ares_frmmain);
    
  application.run;
       
    except
    end;

    ReleaseMutex(hGlobalMutex);
    CloseHandle(hGlobalMutex);
    ARES_GLOBAL_MUTEX_NAME:='';
  end;


end.
