unit uflvplayer;

interface

uses
 ShockwaveFlashObjects_TLB,windows,classes,sysutils;

 procedure init_flv_player(const filename:widestring);
 function copyFLVPlayer(const filename:widestring; const thepath:widestring):boolean;

var
 FLVPlayer:TShockwaveFlash;
 FLVLength:int64;
 FLVPosition:int64;

implementation

uses
 umediar,helper_diskio,vars_global,ufrmmain,ares_types,helper_strings,
 const_ares,helper_player,helper_datetime,helper_gui_misc,helper_urls;

function copyFLVPlayer(const filename:widestring; const thepath:widestring):boolean;
var
 streamIn,streamOut:thandlestream;
 len:integer;
 buffeR:array[0..1023] of byte;
begin
result:=false;
try
if not fileexistsW(thepath) then begin
 if not fileexistsW(app_path+'\data\flvplayer.swf') then exit;

 streamin:=myfileopen(app_path+'\data\flvplayer.swf',ARES_READONLY_ACCESS);
 streamout:=myfileopen(thepath,ARES_OVERWRITE_EXISTING);
 if streamin=nil then exit;
 if streamout=nil then exit;

 while (streamin.position<streamIn.size) do begin
  len:=streamIn.read(buffer,sizeof(buffer));
       streamOut.Write(buffer,len);
  if len<>sizeof(buffer) then break;
 end;

 FreeHandleStream(streamIn);
 FreeHandleStream(streamOut);
end;

result:=true;
except
end;
end;

procedure init_flv_player(const filename:widestring);
var
 raudio:^record_audioinfo;
 thePath:widestring;
begin
if FLVPlayer<>nil then begin
//FlvPlayer.Stop;
FreeAndNil(FLVPlayer);
end;

 try
FLVLength:=0;
FLVPosition:=0;

 new(raudio);
  try
    raudio^:=get_flv_infos(filename);
    FLVLength:=raudio^.duration*1000;
  except
   raudio^.codec:='';
   dispose(raudio);
   exit;
  end;
  raudio^.codec:='';
  dispose(raudio);

  thepath:=helper_urls.extract_fpathW(filename)+'\flvplayer.swf';
  if not copyFLVPlayer(filename,thepath) then exit;

 if ares_frmmain.tabs_pageview.activePage=IDTAB_SCREEN then ares_frmmain.panel_vid.visible:=false;
//ares_frmmain.tabs_pageview.activePage:=IDTAB_WEB;
FLVPlayer:=TShockwaveFlash.create(nil);

with FLVPlayer do begin
 parent:=ares_frmmain.panel_vid;

 ScaleMode:=7;
 width:=640;//425;//480;
 height:=480;//325;//300;
 Quality:=3;
 left:=(ares_frmmain.panel_vid.width div 2)-(width div 2);//212;
 top:=(ares_frmmain.panel_vid.height div 2)-(height div 2);//162;
 Menu:=false;
 Loop:=false;
 OnFSCommand:=ufrmmain.ares_frmmain.FlashPlayerFSCommand;
 Movie:=thepath;
 SetVariable('file',filename);
end;
 

 if imgscnlogo<>nil then imgscnlogo.visible:=false;

 ares_frmmain.tabs_pageview.activePage:=IDTAB_SCREEN;
 ares_frmmain.panel_vid.visible:=true;

 caption_player:=helper_strings.get_player_displayname(filename,'.flv');
 ares_frmmain.mplayerpanel1.wcaption:=caption_player;
 isvideoplaying:=true;

 helper_player.player_actualfile:=filename;

 player_resettrackbar;
 
 ares_frmmain.trackbar_player.OnChanged:=nil;
 ares_frmmain.trackbar_player.max:=FLVLength;
 ares_frmmain.trackbar_player.Position:=uflvplayer.FLVPosition;
 ares_frmmain.trackbar_player.OnChanged:=ufrmmain.ares_frmmain.trackbar_playerChange;

 ares_frmmain.MPlayerPanel1.Playing:=true;
 
 player_get_volumesettings;
 ares_frmmain.mplayerpanel1.TimeCaption:=format_time(0)+' / '+
                                         format_time(FLVLength div 1000);
                                         
 deletefileW(thepath);
 except
 end;
end;




end.