(function() {
  var CompositeDisposable;

  module.exports = CompositeDisposable = (function() {
    CompositeDisposable.prototype.disposed = false;


    /*
    Section: Construction and Destruction
     */

    function CompositeDisposable() {
      var disposable, _i, _len;
      this.disposables = [];
      for (_i = 0, _len = arguments.length; _i < _len; _i++) {
        disposable = arguments[_i];
        this.add(disposable);
      }
    }

    CompositeDisposable.prototype.dispose = function() {
      var disposable;
      if (!this.disposed) {
        this.disposed = true;
        while (disposable = this.disposables.shift()) {
          disposable.dispose();
        }
      }
    };


    /*
    Section: Managing Disposables
     */

    CompositeDisposable.prototype.add = function(disposable) {
      if (!this.disposed) {
        this.disposables.push(disposable);
      }
    };

    CompositeDisposable.prototype.remove = function(disposable) {
      var index;
      index = this.disposables.indexOf(disposable);
      if (index !== -1) {
        this.disposables.splice(index, 1);
      }
    };

    CompositeDisposable.prototype.clear = function() {
      this.disposables.length = 0;
    };

    return CompositeDisposable;

  })();

}).call(this);
