;
;	@(#) $Id: Product.nsh 1414 2008-04-24 12:57:15Z svante $

; ******************************************
; ***** Setup Configuration Parameters *****
; ******************************************
  ; For debugging - standalone compile
  !ifndef REL
  !define REL 0.0.0.0
  !endif

  ; The Company is used for folder and registry names. It must match the info in the resources.
  ; The Program name must be the root-name of the program, i.e. NiceCrypt (.exe) etc,
  ; this will also be used for the registry and folder names etc.
  !define COMPANY "Axon Data"
  !define PROGRAM "AxCrypt"

  ; This can be any folder in the start menu
  !define STARTMENU "${COMPANY}\${PROGRAM}"

  ; This must be a program-unique folder that can be deleted on un-install
  !define STD_INSTALL_DIR "$PROGRAMFILES\${COMPANY}\${PROGRAM}"

  ; Define to non-empty to show it as the Activation menu in the Start Menu
;  !define ACTIVATION "$(AX_TEXT_ACTIVATION)"
  !define ACTIVATION ""
  
  ; Define an alias for the Version-specific home directory relative to the
  ; common/generic 'Misc' directory
  !define VERSION_PATH "."
  !define COMMON_PATH "."

  !define EXTLC .axx
  !define EXTUC .AXX
  !define BUG_REPORT_URL "http://sourceforge.net/tracker/?group_id=40359&atid=427798"
  !define SUPPLIER_URL "http://www.axantum.com"
  !define NOTIFY_URL "http://notify.axondata.se/index.html"
  !define EMAIL "axcrypt@axondata.se"
  !define MANUAL_URL "$INSTDIR\AxCrypt-Manual.pdf"
  !define README_URL "$INSTDIR\ReadMe.html"

  !define LICENSE_PATH "${COMMON_PATH}"
  !define LICENSE_NAME "GNU General Public License.txt"
;  !define CUSTOM_MENU_TEXT ""
;  !define CUSTOM_MENU_URL "http://"
  
  ; *** All _PATH are relative to the Misc directory ***
  
  ; Generally the originals will be in ${PACKAGE_PATH}, where they are
  ; put after customization and possibly renaming.
  !ifdef Debug
  !define PACKAGE_PATH "..\Package\Debug"
  !endif
  !ifdef Release
  !define PACKAGE_PATH "..\Package\Release"
  !endif
  
  ; These are the OutFile locations used by the NSIS compiler to place the result
  !define OUT_NOTIFY_PATH "${PACKAGE_PATH}"
  !define OUT_NOTIFY_NAME "Notify.exe"
  !define OUT_SETUP_PATH "${PACKAGE_PATH}"
  !define OUT_SETUP_NAME "AxCrypt-GPL-Setup.exe"
  
  !define SIGSXML_PATH "${PACKAGE_PATH}"
  !define SIGSXML_NAME "Sigs.xml"
  !define CONFIGXML_PATH "${PACKAGE_PATH}"
  !define CONFIGXML_NAME "GplConfig.xml"

  ; The Readme is assumed to be a HTML-document, and to refer to a style sheet
  !define README_PATH "${VERSION_PATH}"
  !define README_NAME "ReadMe.html"
  !define CSS_NAME "AxCrypt.css"

;  !define MANUAL_PATH "..\Doc"
;  !define MANUAL_NAME "AxCrypt-Manual.pdf"
  
  !define ETC_PATH "${COMMON_PATH}\Etc"
;  !define DOC_PATH "${COMMON_PATH}\..\Doc"

  ; All of these must be installed together in $INSTDIR
  ; All are assumed to be in ${PACKAGE_PATH}
  !define NOTIFY_NAME "Notify.exe"
  !define PROGRAM_NAME "AxCrypt.exe"
  !define SELFDEC_NAME "AxDecrypt.exe"
  !define MESSAGES_NAME "Messages.dll"
  !define SHELLEXT_NAME "ShellExt.dll"
  !define AXCRYPT2GO_NAME "AxCrypt2Go.exe"
  
  ; This should be moved into the package, along with the bitmap and all else.
  !define ICON_PATH "${VERSION_PATH}"
  !define ICON_NAME "AxCrypt.ico"
  
  ; Will normally not exist. Only created for custom password recovery attempts.
  !define BRUTEFORCE_NAME "axBrute.dll"
  
  !define TEXTS_PATH_NAME ".\Texts.nsh"
  !define PSAPI_PATH "..\Contrib\Redistrib"
