/*
    @(#) $Id: CVersion.cpp 1393 2008-04-10 19:04:50Z svante $

	AxCrypt - Compressing and Encrypting Wrapper and Application Launcher for Secure Local,
	Server or Web Storage of Document Files.

	Copyright (C) 2001 Svante Seleborg/Axon Data, All rights reserved.

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 2 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this program;
	if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
	Boston, MA 02111-1307 USA

	The author may be reached at mailto:axcrypt@axondata.se and http://axcrypt.sourceforge.net
----
	CVersion.cpp					Get and present version information

	E-mail							YYYY-MM-DD				Reason
	axcrypt@axondata.se 			2001-12-06				Initial
*/
#include	"StdAfx.h"
#include	"stdio.h"
#include	"CVersion.h"
#include    "CRegistry.h"
#include    "CFileName.h"

#include    "../Contrib/AxWinLib/AxAssert.h"
#define     AXLIB_ASSERT_FILE "CVersion.cpp"

HINSTANCE CVersion::m_hInstance;

void CVersion::Init(HINSTANCE hInstance) {
    m_hInstance = hInstance;
}

CVersion::CVersion(HINSTANCE hInstance) {
    _TCHAR szFileName[_MAX_PATH];
    CAssert(GetModuleFileName(hInstance == NULL ? m_hInstance : hInstance, szFileName, sizeof szFileName)).Sys().Throw();
    Init(szFileName);
}

CVersion::CVersion(const _TCHAR *szFileName) {
    Init(szFileName);
}

CVersion::~CVersion() {
	if (m_pFileVersionInfo != NULL) delete m_pFileVersionInfo;
}

void CVersion::Init(const _TCHAR *szFileName) {
    m_szExtProductName = NULL;
    m_szCompanyName = NULL;
    m_szLegalCopyright = NULL;
    m_szFileDescription = NULL;

	// This will be a memory leak unless we note this here.
	HEAP_CHECK_BEGIN(_T("CVersion::CVersion()"), TRUE)

	DWORD dwDummy, dwLen = GetFileVersionInfoSize(szFileName, &dwDummy);
	CAssert(dwLen != 0).Sys().Throw();

	m_pFileVersionInfo = new BYTE[dwLen];
    ASSPTR(m_pFileVersionInfo);

    CAssert(GetFileVersionInfo(szFileName, dwDummy, dwLen, m_pFileVersionInfo));
	HEAP_CHECK_END
	UINT uLen = 0;
	CAssert(VerQueryValue(m_pFileVersionInfo, _T("\\"), (void **)&m_pFixedFileInfo, &uLen)).Sys().Throw();
}

BYTE
CVersion::FileMajor() {
	return oFileMajor;
}

BYTE
CVersion::FileMinor() {
	return oFileMinor;
}

BYTE
CVersion::Major() {
	return (BYTE)(m_pFixedFileInfo->dwProductVersionMS>>16);
}

BYTE
CVersion::Minor() {
	return (BYTE)(m_pFixedFileInfo->dwProductVersionMS);
}

BYTE
CVersion::Minuscle() {
	return (BYTE)(m_pFixedFileInfo->dwProductVersionLS>>16);
}

BYTE
CVersion::Patch() {
	return (BYTE)(m_pFixedFileInfo->dwProductVersionLS);
}

BYTE
CVersion::MajorFileVersion() {
	return (BYTE)(m_pFixedFileInfo->dwFileVersionMS>>16);
}

BYTE
CVersion::MinorFileVersion() {
	return (BYTE)(m_pFixedFileInfo->dwFileVersionMS);
}

BYTE
CVersion::MinuscleFileVersion() {
	return (BYTE)(m_pFixedFileInfo->dwFileVersionLS>>16);
}

BYTE
CVersion::PatchFileVersion() {
	return (BYTE)(m_pFixedFileInfo->dwFileVersionLS);
}
//
//
//
LPCTSTR
CVersion::ExtProductName() {
    if (m_szExtProductName == NULL) {
	    UINT uLen = 0;

	    LPTSTR szProductName = NULL;
	    CAssert(VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\ProductName"), (void **)&szProductName, &uLen)).App(ERR_VERSION_RESOURCE).Throw();
    
        m_szExtProductName = CRegistry(HKEY_LOCAL_MACHINE, gszAxCryptRegKey, szRegValProductName).GetSz(szProductName);
    }
	return m_szExtProductName;
}
//
//  _tcslwr the result...
//
LPCTSTR
CVersion::IntProductName() {
    if (m_szIntProductName == NULL) {
        m_szIntProductName = CopySz(CFileName().SetPath2ExeName(ghInstance).GetName());
    }
    return m_szIntProductName;
}
//
// Company name, from resource.
//
LPCTSTR CVersion::CompanyName() {
    if (m_szCompanyName == NULL) {
	    UINT uLen = 0;

	    CAssert(VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\CompanyName"), (void **)&m_szCompanyName, &uLen)).App(ERR_VERSION_RESOURCE).Throw();
    }
	return m_szCompanyName;
}
//
// Copyright string, from resource.
//
LPCTSTR CVersion::LegalCopyright() {
    if (m_szLegalCopyright == NULL) {
	    UINT uLen = 0;

	    CAssert(VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\LegalCopyright"), (void **)&m_szLegalCopyright, &uLen)).App(ERR_VERSION_RESOURCE).Throw();
    }
	return m_szLegalCopyright;
}

//
// FileDescription string, from resource.
//
LPCTSTR CVersion::FileDescription() {
    if (m_szFileDescription == NULL) {
	    UINT uLen = 0;

	    CAssert(VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\FileDescription"), (void **)&m_szFileDescription, &uLen)).App(ERR_VERSION_RESOURCE).Throw();
    }
	return m_szFileDescription;
}

/// \brief Get a formatted version string for the file version from resources
/// \return An allocated string. Do delete afterwards.
const _TCHAR *
CVersion::FileVersionString() {
    _TCHAR *sz = new _TCHAR[1024];          // wsprintf guarantees <= 1024
	UINT uLen = 0;

	LPCTSTR szSpecialBuild = _T("");        // It's not necessarily an error with no SpecialBuild resource
	VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\SpecialBuild"), (void **)&szSpecialBuild, &uLen);
	
	if (szSpecialBuild && uLen) {
        wsprintf(sz, PatchFileVersion() ? _T("%d.%d %s %d.%d") : _T("%d.%d %s %d"), MajorFileVersion(), MinorFileVersion(), szSpecialBuild, MinuscleFileVersion(), PatchFileVersion());
	} else {
        wsprintf(sz, PatchFileVersion() ? _T("%d.%d.%d.%d") : _T("%d.%d.%d"), MajorFileVersion(), MinorFileVersion(), MinuscleFileVersion(), PatchFileVersion());
	}
	return sz;
}

LPCTSTR
CVersion::String(bool fShowNoVersion) {
    // If we're not showing version info...
    if (fShowNoVersion) {
        m_szString.Fmt(_T("%1"), gszAxCryptExternalName);
    } else {
        UINT uLen = 0;

	    LPCTSTR szSpecialBuild = _T("");        // It's not necessarily an error with no SpecialBuild
	    VerQueryValue(m_pFileVersionInfo, _T("\\StringFileInfo\\000004b0\\SpecialBuild"), (void **)&szSpecialBuild, &uLen);
    	
	    if (szSpecialBuild && uLen) {
            m_szString.Fmt(Patch() ? _T("%1 %2!d!.%3!d! %4 %5!d!.%6!d!") : _T("%1 %2!d!.%3!d! %4 %5!d!"), gszAxCryptExternalName, Major(), Minor(), szSpecialBuild, Minuscle(), Patch());
	    } else {
            m_szString.Fmt(Patch() ? _T("%1 %2!d!.%3!d!.%4!d!.%5!d!") : _T("%1 %2!d!.%3!d!.%4!d!"), gszAxCryptExternalName, Major(), Minor(), Minuscle(), Patch());
	    }
    }
	return m_szString.Get();
}

COsVersion::COsVersion() {
	m_stOsVersion.dwOSVersionInfoSize = sizeof m_stOsVersion;
	// check if we are running Windows NT < 5. The call will probably fail (i can't test this)
	// on NT 3.1.
	CAssert(GetVersionEx(&m_stOsVersion)).Sys().Throw();
}

BOOL
COsVersion::IsWin95() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) &&
		   (m_stOsVersion.dwMajorVersion == 4) &&
		   (m_stOsVersion.dwMinorVersion == 0);
}

BOOL
COsVersion::IsWin98() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) &&
		   (m_stOsVersion.dwMajorVersion == 4) &&
		   (m_stOsVersion.dwMinorVersion == 10);
}

BOOL
COsVersion::IsWinME() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) &&
		   (m_stOsVersion.dwMajorVersion == 4) &&
		   (m_stOsVersion.dwMinorVersion == 90);
}

BOOL
COsVersion::IsWin2000() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_NT) &&
		   (m_stOsVersion.dwMajorVersion == 5) &&
		   (m_stOsVersion.dwMinorVersion == 0);
}

BOOL
COsVersion::IsWinNT() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) && (
			   (
		           (m_stOsVersion.dwMajorVersion == 3) &&
			       (m_stOsVersion.dwMinorVersion == 51)
			   ) || (
		           (m_stOsVersion.dwMajorVersion == 4) &&
			       (m_stOsVersion.dwMinorVersion == 0)
			   )
		   );
}

BOOL
COsVersion::IsWinXP() {
	return (m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_NT) &&
		   (m_stOsVersion.dwMajorVersion == 5) &&
		   (m_stOsVersion.dwMinorVersion == 1);
}

// Is Windows 95/98/ME ?
BOOL
COsVersion::IsWin9x() {
	return m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS;
}

// Is Windows NT/2K/XP/NET ?
BOOL
COsVersion::IsWinNx() {
	return m_stOsVersion.dwPlatformId == VER_PLATFORM_WIN32_NT;
}
