#ifndef	_CENTROPY
#define	_CENTROPY
/*
    @(#) $Id: CEntropy.h 1228 2008-01-14 21:30:37Z svante $

	AxCrypt - Compressing and Encrypting Wrapper and Application Launcher for Secure Local,
	Server or Web Storage of Document Files.

	Copyright (C) 2001 Svante Seleborg/Axon Data, All rights reserved.

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 2 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this program;
	if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
	Boston, MA 02111-1307 USA

	The author may be reached at mailto:axcrypt@axondata.se and http://axcrypt.sourceforge.net
----
	CEntropy.h						Entropy-pool

	E-mail							YYYY-MM-DD				Reason
	axcrypt@axondata.se 			2002					Initial

*/
/*
	CEntropy - Generate as good entropy as we can using different techniques.

	Currently entropy is generated by periodic polling of mouse and window states,
	hashing those if changed, and adding that a byte at a time.

	The entropy pool is 256 bytes large, half of which is saved persistently in the
	registry. Once again the design goal is not to secure the local system - thus we
	have no fear that half of the 'old' entropy is exposed to a potential local attacker,
	if she's that far into the system, it's much easier to simple get the files and
	install a keyboard sniffer...
*/
#include <wincrypt.h>
#include	"../Shared/Utility.h"
//
#define	ENTROPY_POOL_SIZE	256				// +1 must be prime
//
class CEntropy {
    CHKey m_hRegKey, m_hRegSubKey;			// HKEYs to the registry. Auto-closing.
    CPtrTo<BYTE> m_pEntropyPool;			// Auto-deleting.
	CPtrTo<TCHAR> m_szRegSubKey;			// Auto-deleting
	int m_iReadIndex, m_iWriteIndex;
	
	// Three threads and corresponding event objects
	HANDLE m_hGatherThread, m_hGatherEvent;
    HANDLE m_hFlipperThread, m_hFlipperEvent;
    HANDLE m_hUserEntropyThread, m_hUserEntropyEvent;

	// These are used between threads - thus need volatile
	volatile unsigned int m_uiBit;		// Use native int for speed
	volatile long m_lWantedBits;		// Start gathering the number of requested bits.
	volatile BOOL m_fStopFlip;			// Done gathering - goto sleep.
	volatile long m_lStopAll;			// Stop all entropy gathering

    bool m_bUseEntropyPool;                 ///< Set to true if we're using the old style
    HCRYPTPROV m_hCryptProv;                ///< The random number generator context
public:
	CEntropy(HKEY hKey, LPCTSTR szRegSubKey);
	~CEntropy();
	CEntropy& Start();					// Start the entropy threads
	CEntropy& Stop();					// Stop the entropy threads
	CEntropy& Load();					// Load saved entropy from registry
	CEntropy& Save();					// Save some entropy to the registry
	
	BYTE *Read(BYTE *aoDst, size_t stLen);
	void Add(BYTE *aoSrc, size_t stLen);
private:
    bool UseEntropyPool();                  ///< false if we are to use the CryptoAPI instead.
	void GatherBits(long lBits);		// Get as many as these bits into the pool
//
	static DWORD WINAPI StaticFlipperThread(LPVOID lpParameter);
	void FlipperThread();				// A thread that just increments a counter, frequently...
//
	static DWORD WINAPI StaticGatherThread(LPVOID lpParameter);
	void GatherThread();				// A thread that gathers requested bits into the pool
//
    static DWORD WINAPI StaticUserEntropyThread(LPVOID lpParameter);
    void UserEntropyThread();			// A thread that collects some user entropy
//
    static BOOL CALLBACK WindowsStateHashEnumProc(HWND hwnd, LPARAM lParam);
    BYTE WindowsStateHash();
//
    static BYTE ByteSumHash(void *pvBuf, int iSiz);
	int IncPoolIndex(int *pIndex);
	BOOL OpenRegSubKey();
	BYTE GetTimeStampBit();
	BYTE GetTimeStampByte();
};
#endif	_CENTROPY
