#ifndef CTRIALMGR_H
#define CTRIALMGR_H
/*
    @(#) $Id: CTrialMgr.h 1196 2008-01-14 21:09:00Z svante $

    AxCrypt - Compressing and Encrypting Wrapper and Application Launcher for Secure Local,
    Server or Web Storage of Document Files.

    Copyright (C) 2004 Svante Seleborg/Axantum Software AB, All rights reserved.

    This program is free software; you can redistribute it and/or modify it under the terms
    of the GNU General Public License as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program;
    if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
    Boston, MA 02111-1307 USA

    The author may be reached at mailto:axcrypt@axondata.se and http://axcrypt.sourceforge.net
----
    CTrialMgr.h                    Manage trial use counters etc.
*/
#include "AxSigLib.h"
#include <wincrypt.h>

#include <string>

using namespace std;

/// \brief Handle use counts etc.
/// A handler of small counts in a somewhat obscure manner. The idea is that for trial software
/// you need to keep track of a few counters, with small values - typically the number of uses
/// or the number of days since installation, or the number of days used etc. This class implements
/// this in a way that at least to my knowledge there are no readily avaialable easy to use tools
/// to delete the counters. They are located in the file system or the registry, but presumably
/// it requires a bit of skill to find them. Regular file or registry entries are a little too
/// easy for snoops to find. Then again - the worst that happens is that the snoop who sees this
/// and figures it out will get a nag screen all the time, and not pay, but this is only software...
class CTrialMgr {
    ttstring m_sProgram;                      ///< The program that we're counting for.
    ttstringintmap m_simTypeCtr;              ///< The current valid indexes for respective counter
    bool m_fTryCryptSilentFirst;            ///< Try CRYPT_SILENT until it fails at least once.
//  CRITICAL_SECTION m_CritObj;             ///< The actual critical section object to use.
//  auto_ptr<CCriticalSection> m_pCritSect; ///< Some of these operations are not thread safe

    /// \brief Convert an integer to a string
    ttstring IntStr(const int i);
    /// \brief Get the current value of this counter type, if any.
    int GetCounterRep(const ttstring &sType, const int iMax = -1);
    /// \brief Add a new counter representation
    void AddCounterRep(const ttstring &sType, const int iCtr);
    /// \brief Delete an existing counter representation
    void DeleteCounterRep(const ttstring &sType, const int iCtr);
    /// \brief Acquire context with Windows 98 compatibility
    bool AcquireContext(HCRYPTPROV *hProv, const ttstring &sContainer, unsigned long ulFlags = 0);
public:
    /// \brief Make an interface object to the trial counters
    CTrialMgr(const ttstring &sProgram);
    /// \brief Clean up and release handle to provider if any
    ~CTrialMgr();
    /// \brief Get the trial counter as it is now
    int Get(const ttstring &sCounterName = _TT("A"), int iMax = 100);
    /// \brief Increment the trial counter and return the new one, maximized by iMax+1
    int Increment(int iMax = -1, const ttstring &sCounterName = _TT("A"));
    /// \brief Clear this trial counter, when we have got a license for example.
    void Clear(const int iCount, const ttstring &sCounterName = _TT("A"));
};
#endif