@echo off
rem @(#) $Id: GenSigs.bat 1282 2008-01-17 18:52:08Z svante $

rem *** This must not be run from an elevated instance of Visual Studio on Vista, to access the signing key.

rem Parameter %1 is assumed to be 'Debug' or 'Release', according to build mode
rem Current directory is assumed to be at Common\Misc

rem Location of helper programs and files:

set beta=
set AxKeyCodeSig="V:\Security\AxantumCodeSigningKey.xml"
set axsiglic="V:\UsrBin\AxSigXml.exe"
set AxKeyLicVer="Private\%program%%beta%LicenseVerifier.xml"

if exist %AxKeyCodeSig% goto GotKey

echo You do not have access to the Axantum private key for signing.
echo.
echo Sign the Sigs.XML for GPL version-recompile. This is only used by Axantum,
echo as it requires the Axantum private key. There is normally no need to run
echo this script. Contact Axantum Software AB at axcrypt@axantum.com if you
echo need more information about what this does.
echo No signatures generated, using templates.

goto CopyRedist

:GotKey

if not exist %1 mkdir %1

rem *** Generate GPL signatures for this release (just sign the config, do not refer to any other)
echo Generate GPL Configuration signatures for this release...
%AxSigLic% -r %AxKeyCodeSig% GplConfig.xml Config\GplConfig.redist.xml
if not "%errorlevel%" == "0" goto Error
copy Config\GplConfig.redist.xml Config\GplConfig.xml

echo Generate GPL Signature signatures for this release...
rem Important that we really sign the output of the previous operation...
cd Config
%AxSigLic% -r %AxKeyCodeSig% ..\Sigs.xml Sigs.redist.xml
if not "%errorlevel%" == "0" goto Error
cd ..

:CopyRedist
rem *** Use type to ensure that the time-stamps are updated so we don't need to do this any more
type Config\GplConfig.redist.xml >Config\GplConfig.xml
type Config\Sigs.redist.xml >Config\Sigs.xml

exit /b
:Error
echo.
echo Build failed! Type any char to continue.
pause >nul 2>nul
exit /b %errorlevel%