;
;	@(#) $Id: Notify.nsh 1176 2008-01-08 08:19:26Z svante $
;
;	Notify.nsh
;
;       Based on: NSIS Modern User Interface version 1.68
;                 Multilingual Example Script
;                 Written by Joost Verburg
;

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;Configuration
  Var NotifyURL
  Var AX_HWND
  Var AX_HWNDITEM
  Var NotifyEmail                           ; Keep track of e-mail
  Var NotifyPrevious                        ; Previous version, if known or Yes if unknown
  Var NotifyPreference                      ; 'Update', 'Critical' or 'Decline'

  ; We want Vista manifest stating admin
  RequestExecutionLevel admin
  CRCCheck on
  SetDateSave on
  SetDatablockOptimize on
  SilentInstall normal
  ;BGGradient 000000 008000 FFFFFF
  ;InstallColors 000000 FFFFFF
  ShowInstDetails NeverShow
  XPStyle on

  ;General
  Name $(AX_TEXT_SM_NOTIFYME)
  Caption "${PROGRAM} - Encrypt/Compress/Edit"
  BrandingText "${PROGRAM} ${REL}"
  OutFile "${OUT_NOTIFY_PATH}\${OUT_NOTIFY_NAME}"

  !define MUI_ICON ${ICON_PATH}\${ICON_NAME}
  !define MUI_UNICON ${ICON_PATH}\${ICON_NAME}

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Language Selection Dialog Settings

  ;Remember the installer language
  !define MUI_LANGDLL_REGISTRY_ROOT "HKLM" 
  !define MUI_LANGDLL_REGISTRY_KEY "Software\${COMPANY}\${PROGRAM}" 
  !define MUI_LANGDLL_REGISTRY_VALUENAME "InstallerLanguage"

;--------------------------------
;Pages

  Page custom AskForNotifyEmail ExitNotifyEmail
  !insertmacro MUI_PAGE_INSTFILES

  ;!define MUI_FINISHPAGE_NOAUTOCLOSE
  !insertmacro MUI_PAGE_FINISH

;--------------------------------
;Languages

  !include ${TEXTS_PATH_NAME}

;--------------------------------
;Reserve Files
  
  ;These files should be inserted before other files in the data block
  ;Keep these lines before any File command
  ;Only for BZIP2 (solid) compression
  !insertmacro MUI_RESERVEFILE_LANGDLL

;--------------------------------
;Installer Sections

Section Notify Notify
  StrCmp $NotifyURL "" +2
  StrCpy $NotifyURL "$NotifyURL&"
  StrCpy $NotifyURL "$NotifyURLAfter=1"

  ; Get the current install dir - if we fail, just use the temp directory
  StrCpy $1 $TEMP
  ReadRegStr $1 HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Install_Dir"

  NSISdl::download_quiet /TIMEOUT=10000 "${NOTIFY_URL}?$NotifyURL"  "$TEMP\NotifyMe.htm"

  ; write notification information
  WriteRegStr HKCU "Software\${COMPANY}\${PROGRAM}" NotifyEmail $NotifyEmail
  WriteRegStr HKCU "Software\${COMPANY}\${PROGRAM}" NotifyPreference $NotifyPreference

  pop $0
  StrCmp $0 "success" RegOk
  ; We have a problem with proxies sometimes not returning the actual content, but
  ; if we get this message - our server has gotten the request anyway
  StrCmp $0 "Server did not specify content length." RegOk

  ; We also seem to have a problem with some users attempting multiple registrations
  ; in sequence - presumably because they got an error reported. As a debug feature, we'll
  ; now check if it's the most common 'real' problem with a missing connection. If it's
  ; not, we'll try to report it back to the notification site, so we see what kind of
  ; errors the user encounter.
  StrCmp $0 "resolving hostname" +2
  NSISdl::download_quiet /TIMEOUT=2000 "${NOTIFY_URL}?$NotifyURL&Error=$0" "NUL:"

  MessageBox MB_OK '$(AX_TEXT_NOTIFYFAILED) [$0]'
  Abort
RegOk:
SectionEnd
;
; Ask for e-mail for update notifications
;
Function AskForNotifyEmail
  !insertmacro MUI_HEADER_TEXT "$(TEXT_IO_NOTIFYTITLE)" "$(TEXT_IO_NOTIFYSUBTITLE)"

  StrCmp $NotifyPrevious "" 0 GotPrevious

  ReadINIStr $NotifyPrevious "$TEMP\${PROGRAM}.ini" "Previous" "Version"
  StrCmp $NotifyPrevious "" 0 GotPrevious

GotPrevious:

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\${COMPANY}\${PROGRAM}" NotifyEmail

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadINIStr $NotifyEmail "$TEMP\${PROGRAM}.ini" "Previous" "Email"

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\Microsoft\Office\Outlook\OMI Account Manager\Accounts\00000001" "SMTP Email Address"

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\Microsoft\MessengerService\ListCache\.NET Messenger Service" "IdentityName"

GotEmail:

  StrCmp $NotifyPreference "" 0 GotPreference
  ReadRegStr $NotifyPreference HKCU "Software\${COMPANY}\${PROGRAM}" NotifyPreference

  StrCmp $NotifyPreference "" 0 GotPreference
  ReadINIStr $NotifyPreference "$TEMP\${PROGRAM}.ini" "Previous" "Preference"

GotPreference:

  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 4" "State" 0 ; Update
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 5" "State" 0 ; Critical
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 6" "State" 0 ; Decline

  StrCmp $NotifyPreference "Critical" 0 NotCritical
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 5" "State" 1
  GoTo GotPrePreference

NotCritical:
  StrCmp $NotifyPreference "Decline" 0 NotDecline
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 6" "State" 1
  Goto GotPrePreference

NotDecline:
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 4" "State" 1

GotPrePreference:
  WriteINIStr $NotifyEmail "$PLUGINSDIR\ionotify.ini" "Field 2" "State"

  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "ionotify.ini"
  Pop $AX_HWND

  GetDlgItem $AX_HWNDITEM $AX_HWND 1200
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYPROMPT)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1201
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$NotifyEmail

  GetDlgItem $AX_HWNDITEM $AX_HWND 1203
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIOYES)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1204
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIOCRIT)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1205
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIONO)

  !insertmacro MUI_INSTALLOPTIONS_SHOW
FunctionEnd

Function ExitNotifyEmail
  StrCpy $NotifyURL ""
  StrCpy $R0 ""

  ReadINIStr $NotifyEmail "$PLUGINSDIR\ionotify.ini" "Field 2" "State"
  StrCmp $NotifyEmail "" NoEmail
  
  ; Check for reasonably valid Email, and stay here otherwise.
  push $NotifyEmail
  Call ValidateEmail
  Pop $R2
  StrCmp $R2 "" OkEmail
  StrCpy $NotifyEmail ""
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 2" "State" $NotifyEmail
  GetDlgItem $AX_HWNDITEM $AX_HWND 1201
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$NotifyEmail
  Abort

OkEmail:

  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "email=$NotifyEmail"

  ; Check if 'Yes'
  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 4" "State"
  StrCpy $NotifyPreference "Update"
  StrCmp $R1 0 0 GotNewPreference

  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 5" "State"
  StrCpy $NotifyPreference "Critical"
  StrCmp $R1 0 0 GotNewPreference

  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 6" "State"
  StrCpy $NotifyPreference "Decline"
  StrCmp $R1 0 0 GotNewPreference

GotNewPreference:
  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "$R0$NotifyPreference=1"

NoEmail:
  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "$R0Program=${PROGRAM}"

  StrCmp $NotifyPrevious "" +2
  StrCpy $R0 "$R0&Previous=$NotifyPrevious"

  StrCpy $R0 "$R0&Version=${REL}"

  Call GetWindowsVersion
  Pop $R1
  StrCpy $R0 "$R0&Windows=$R1"

  StrCpy $R0 "$R0&Language=$LANGUAGE"
  
  StrCpy $NotifyURL $R0
FunctionEnd

;--------------------------------
;Installer Functions

Function .onInit

  !insertmacro MUI_LANGDLL_DISPLAY

  ;Extract InstallOptions INI files
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "ionotify.ini"

FunctionEnd

;--------------------------------
;Descriptions

  ;USE A LANGSTRING IF YOU WANT A DESCRIPTION TO BE LANGUAGE SPECIFIC

;  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
;    !insertmacro MUI_DESCRIPTION_TEXT ${PROGRAM} $(AX_TEXT_SETUPALL)
;  !insertmacro MUI_FUNCTION_DESCRIPTION_END
 

; GetWindowsVersion
;
; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
; Updated by Joost Verburg
; Modified for this usage by Svante Seleborg
;
; Returns on top of stack
;
; Windows Version: Win95, Win98, WinME, NTx.x, Win2K, WinXP, W2003
; or
; 'WinXX' (Unknown Windows Version)
;
; Usage:
;   Call GetWindowsVersion
;   Pop $R0
;   ; at this point $R0 is "NT4.0" or whatnot
 
Function GetWindowsVersion
 
   Push $R0
   Push $R1
 
   ClearErrors
   ReadRegStr $R0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
   IfErrors 0 lbl_winnt
   
   ; we are not NT
   ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows\CurrentVersion" VersionNumber
 
   StrCpy $R1 $R0 1
   StrCmp $R1 '4' 0 lbl_error
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '4.0' lbl_win32_95
   StrCmp $R1 '4.9' lbl_win32_ME lbl_win32_98
 
   lbl_win32_95:
     StrCpy $R0 'Win95'
   Goto lbl_done
 
   lbl_win32_98:
     StrCpy $R0 'Win98'
   Goto lbl_done
 
   lbl_win32_ME:
     StrCpy $R0 'WinME'
   Goto lbl_done
 
   lbl_winnt:
 
   StrCpy $R1 $R0 1
 
   StrCmp $R1 '3' lbl_winnt_x
   StrCmp $R1 '4' lbl_winnt_x
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '5.0' lbl_winnt_2000
   StrCmp $R1 '5.1' lbl_winnt_XP
   StrCmp $R1 '5.2' lbl_winnt_2003 lbl_error
 
   lbl_winnt_x:
     StrCpy $R0 "NT$R0" 5
   Goto lbl_done
 
   lbl_winnt_2000:
     Strcpy $R0 'Win2K'
   Goto lbl_done
 
   lbl_winnt_XP:
     Strcpy $R0 'WinXP'
   Goto lbl_done
 
   lbl_winnt_2003:
     Strcpy $R0 'W2003'
   Goto lbl_done
 
   lbl_error:
     Strcpy $R0 'WinXX'
   lbl_done:
 
   Pop $R1
   Exch $R0
 
FunctionEnd

; Check basic format of email. Address to check on top of stack.
; Return "" on ok, "something" if error
Function ValidateEmail
    Exch $0
    Push $1

    Push $0
    Push "@"
    Call StrStr
    Pop $0
    StrCmp $0 "" NotOk

    Push $0
    Push "."
    Call StrStr
    Pop $0
    StrCmp $0 "" NotOk

    Goto Ok
NotOk:
    StrCpy $0 "Invalid"
    Goto Done

Ok:
    StrCpy $0 ""
    
Done:
    Pop $1
    Exch $0
FunctionEnd

 ; StrStr
 ; input, top of stack = string to search for
 ;        top of stack-1 = string to search in
 ; output, top of stack (replaces with the portion of the string remaining)
 ; modifies no other variables.
 ;
 ; Usage:
 ;   Push "this is a long ass string"
 ;   Push "ass"
 ;   Call StrStr
 ;   Pop $R0
 ;  ($R0 at this point is "ass string")

 Function StrStr
 Exch $R1 ; st=haystack,old$R1, $R1=needle
   Exch    ; st=old$R1,haystack
   Exch $R2 ; st=old$R1,old$R2, $R2=haystack
   Push $R3
   Push $R4
   Push $R5
   StrLen $R3 $R1
   StrCpy $R4 0
   ; $R1=needle
   ; $R2=haystack
   ; $R3=len(needle)
   ; $R4=cnt
   ; $R5=tmp
   loop:
     StrCpy $R5 $R2 $R3 $R4
     StrCmp $R5 $R1 done
     StrCmp $R5 "" done
     IntOp $R4 $R4 + 1
     Goto loop
 done:
   StrCpy $R1 $R2 "" $R4
   Pop $R5
   Pop $R4
   Pop $R3
   Pop $R2
   Exch $R1
 FunctionEnd
 