;
;	@(#) $Id: Setup.nsh 1414 2008-04-24 12:57:15Z svante $
;
;	Setup.nsh
;
;       Based on: NSIS Modern User Interface version 1.68
;                 Multilingual Example Script
;                 Written by Joost Verburg
;

;--------------------------------
; Include Modern UI

  !include "MUI.nsh"
  !include "UAC.nsh" ;<<< New headerfile that does everything for you ;)

;--------------------------------
; Utility defines

  !define SHCNE_ASSOCCHANGED               0x8000000
  !define SHCNF_IDLIST                     0
  !define GENERIC_READ                     0x80000000
  !define GENERIC_WRITE                    0x40000000
  !define GENERIC_rw                       0xC0000000
  !define GENERIC_EXECUTE                  0x20000000
  !define GENERIC_ALL                      0x10000000
  !define FILE_SHARE_READ                  0x00000001  
  !define FILE_SHARE_WRITE                 0x00000002  
  !define FILE_SHARE_DELETE                0x00000004
  !define FILE_SHARE_rw                    0x00000003
  !define FILE_SHARE_all                   0x00000007  
  !define CREATE_ALWAYS                    2
  !define OPEN_EXISTING                    3
  !define FILE_ATTRIBUTE_NORMAL            0x00000080  
  !define FILE_FLAG_DELETE_ON_CLOSE        0x04000000
    
;--------------------------------
; Configuration
  ; We want Vista manifest stating user because of UAC plug-in requirement
  RequestExecutionLevel user
  CRCCheck on
  SetDateSave on
  SetDatablockOptimize on
  SilentInstall normal
  ShowInstDetails Hide
  XPStyle on

  Name "${PROGRAM}" 

  Caption "${PROGRAM} - Encrypt/Compress/Edit"
  BrandingText "${PROGRAM} ${REL}"
  OutFile "${OUT_SETUP_PATH}\${OUT_SETUP_NAME}"

  !define MUI_ICON ${ICON_PATH}\${ICON_NAME}
  !define MUI_UNICON ${ICON_PATH}\${ICON_NAME}
  
  !define UNINST_FILES_STARTMENU FilesSM.txt
  !define UNINST_FILES_NONEXE FilesNE.txt
  !define UNINST_FILES_EXE FilesEX.txt

  ;Default installation directory
  InstallDir "${STD_INSTALL_DIR}"
  
  ;Get install folder from registry if available instead
  InstallDirRegKey HKLM "Software\${COMPANY}\${PROGRAM}" ""

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Language Selection Dialog Settings

  ;Remember the installer language
  !define MUI_LANGDLL_REGISTRY_ROOT "HKLM" 
  !define MUI_LANGDLL_REGISTRY_KEY "Software\${COMPANY}\${PROGRAM}" 
  !define MUI_LANGDLL_REGISTRY_VALUENAME "InstallerLanguage"

;--------------------------------
;Pages
  Var AbortHeaderSubText
  Var STARTMENU_FOLDER
  Var AX_TMP
  Var EXE_FOLDER
  Var InstallStarted
  Var OldInstallDir
  Var OldExeFolder

  Var NotifyURL
  Var AX_HWND
  Var AX_HWNDITEM
  Var NotifyEmail                           ; Keep track of e-mail
  Var NotifyPrevious                        ; Previous version, if known or Yes if unknown
  Var NotifyPreference                      ; 'Update', 'Critical' or 'Decline'
  
;  Var FlagFileHandle                        ; The handle to the installer flag-file to signal 'done'

  !define MUI_INSTFILESPAGE_ABORTHEADER_SUBTEXT $AbortHeaderSubText

  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" 
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\${COMPANY}\${PROGRAM}" 
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
  !define MUI_STARTMENUPAGE_DEFAULTFOLDER "${STARTMENU}"

  Page custom CheckBetaWarn

  !insertmacro MUI_PAGE_LICENSE "${LICENSE_PATH}\${LICENSE_NAME}"

  ; Page custom [creator_function] [leave_function] [caption]
  ; We stay in the page if the leave_function calls 'Abort'.
  ; We only present a page if the create_function actually shows a page.

  Page custom CheckForPreviousVersion UninstallPrevious

  Page custom AskForNotifyEmail ExitNotifyEmail

  ; !insertmacro MUI_PAGE_COMPONENTS

  !define MUI_PAGE_CUSTOMFUNCTION_PRE CheckIfUpgrade
  !insertmacro MUI_PAGE_DIRECTORY

  ; Start Menu Folder Page Configuration
  !define MUI_PAGE_CUSTOMFUNCTION_PRE CheckIfUpgrade
  !insertmacro MUI_PAGE_STARTMENU ProgramStartMenu $STARTMENU_FOLDER

  !insertmacro MUI_PAGE_INSTFILES
  
  !define MUI_FINISHPAGE_TEXT $(AX_TEXT_FINISH)
  !define MUI_FINISHPAGE_SHOWREADME ${README_URL}
  !define MUI_FINISHPAGE_NOAUTOCLOSE
  !define MUI_PAGE_CUSTOMFUNCTION_LEAVE SpecialMsgCheck
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !define MUI_UNFINISHPAGE_NOAUTOCLOSE
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages

  !include ${TEXTS_PATH_NAME}

;--------------------------------
;Reserve Files
  
  ;These files should be inserted before other files in the data block
  ;Keep these lines before any File command
  ;Only for BZIP2 (solid) compression
  !insertmacro MUI_RESERVEFILE_LANGDLL

; String on top of stack
; Macro so it can be used in both Install and Uninstall
!macro StrTrimNewLines UN
Function ${UN}StrTrimNewLines
      ;Get input from user
      Exch $R0
      Push $R1
      Push $R2
      
      ;Initialize trim counter
      StrCpy $R1 0

TrimLoop:
      IntOp $R1 $R1 - 1
      StrCpy $R2 $R0 1 $R1
      StrCmp $R2 $\r TrimLoop
      StrCmp $R2 $\n TrimLoop

      ; Trim characters (if needed)
      IntOp $R1 $R1 + 1
      IntCmp $R1 0 NoTrim 0 NoTrim
      StrCpy $R0 $R0 $R1
NoTrim:      

      ;Return output to user
      Pop $R2
      Pop $R1
      Exch $R0
FunctionEnd
!macroend
!insertmacro StrTrimNewLines ""
!insertmacro StrTrimNewLines "un."

!macro DeleteFilesByList UN
Function ${UN}DeleteFilesByList
  exch $1 ; Get the list file
  push $9
  push $0
  DetailPrint "Deleting files by list..."
  ClearErrors
  FileOpen $9 "$1" r
  IfErrors DeleteByListDone

DeleteByListLoop:
  ClearErrors
  FileRead $9 $0
  IfErrors DeleteByListDone
  push $0
  Call ${UN}StrTrimNewLines
  pop $0

  ClearErrors
  Delete "$0"
  IfErrors 0 +2
  Delete /rebootok "$0"
  goto DeleteByListLoop

DeleteByListDone:
  FileClose $9
  Delete "$1"
  pop $0
  pop $9
  pop $1
FunctionEnd
!macroend
!insertmacro DeleteFilesByList ""
!insertmacro DeleteFilesByList "un."

!macro DeleteNonExeFiles UN
Function ${UN}DeleteNonExeFiles
  IfFileExists "$INSTDIR" 0 DoneDelete
  IfFileExists "$INSTDIR\${UNINST_FILES_NONEXE}" DeleteByList
  
  ; Legacy clean-up - earlier versions did not use a list of installed files.
  Delete "$INSTDIR\*.css"
  Delete "$INSTDIR\*.htm"
  Delete "$INSTDIR\*.html"
  Delete "$INSTDIR\*.gif"
  Delete "$INSTDIR\*.jpg"
  Delete "$INSTDIR\*.pdf"
  Delete "$INSTDIR\*.ico"
  Delete "$INSTDIR\*.reg"
  Delete "$INSTDIR\ChangeLog.txt"
  Delete "$INSTDIR\RelNotes.txt"
  Delete "$INSTDIR\Passwords.txt"
  Delete "$INSTDIR\Passwords.xls" 
  Delete "$INSTDIR\images\*.*"
  Delete "$INSTDIR\etc\*.*"
  Delete "$INSTDIR\${LICENSE_NAME}"
  Delete "$INSTDIR\*Config.xml"
  Delete "$INSTDIR\Sigs.xml"

  goto DoneDelete

DeleteByList:
  DetailPrint "Deleting non-exe by list..."
  push "$INSTDIR\${UNINST_FILES_NONEXE}"
  Call ${UN}DeleteFilesByList
DoneDelete:
  ; Clean up folders
  
  ; Images should now be empty, if not - we don't care.
  IfFileExists "$INSTDIR\Images" 0 +2
  RMDir "$INSTDIR\images"

  ; Etc should be now empty, if not - we don't care.
  IfFileExists "$INSTDIR\Etc" 0 +2
  RMDir "$INSTDIR\etc"
  
  ; Temp should not even be here - if it is it really should be empty.
  IfFileExists "$INSTDIR\Temp" 0 +2
  RMDir "$INSTDIR\Temp"
FunctionEnd
!macroend
!insertmacro DeleteNonExeFiles ""
!insertmacro DeleteNonExeFiles "un."

!macro DeleteOneExeFile FilePath
  ClearErrors
  Delete "${FilePath}"
  IfErrors 0 +2
  Delete /rebootok "${FilePath}"
!macroend

!macro DeleteExeFiles UN
Function ${UN}DeleteExeFiles
  IfFileExists "$INSTDIR" 0 DoneDelete
  IfFileExists "$INSTDIR\${UNINST_FILES_EXE}" DeleteByList
  
  ; Legacy clean-up - earlier versions did not use a list of installed files.
  !insertmacro DeleteOneExeFile "$INSTDIR\${PROGRAM_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\${SELFDEC_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\${SHELLEXT_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\${MESSAGES_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\${BRUTEFORCE_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\*.ico"
  !insertmacro DeleteOneExeFile "$INSTDIR\${NOTIFY_NAME}"
  !insertmacro DeleteOneExeFile "$INSTDIR\${PROGRAM}U.exe"

  goto DoneDelete

DeleteByList:
  DetailPrint "Deleting exe by list..."
  push "$INSTDIR\${UNINST_FILES_EXE}"
  Call ${UN}DeleteFilesByList
DoneDelete:
FunctionEnd
!macroend
!insertmacro DeleteExeFiles ""
!insertmacro DeleteExeFiles "un."

!macro ClearEmptyFolders UN
; TOS(0) = Full path to start working upwards from.
; TOS(1) = Full path to stop at
; TOS(2) = Non-empty to indicate /rebootok for RMDir op
Function ${UN}ClearEmptyFolders
  exch $0 ; Full path to start working from
  exch 1
  exch $1 ; Full path to stop at
  exch 2
  exch $3 ; Parameter to delete
  push $2 ; Use as temp to see if we reached absolute top

  ; Ensure the name is normalized and valid
  ClearErrors
  GetFullPathName $0 $0
  IfErrors Done
Loop:
  StrCpy $2 $0

  ; Do different RMDir depending on value of $3 (TOS(2))
  StrCmp "$3" "" 0 +3
  RMDir $0
  goto +2
  RMDir /rebootok $0
  IfErrors Done

  GetFullPathName $0 "$0\.."
  IfErrors Done
  StrCmp $0 $2 Done
  StrCmp $0 $1 Done Loop
Done:
  pop $2
  pop $3
  pop $0
  pop $1
FunctionEnd
!macroend
!insertmacro ClearEmptyFolders ""
!insertmacro ClearEmptyFolders "un."

!macro DeleteEverything UN
Function ${UN}DeleteEverything
  ; Just delete everything - it should take care of known behavior of
  ; previous versions as well, that's why there's some overkill here
  ;
  ; No recursive deletes though - the potential harm is much worse
  ; than the risk of a few left over files.
  ;

  Call ${UN}DeleteExeFiles
  Call ${UN}DeleteNonExeFiles

  ; Executables dir should be empty, if not - not much we can do about it.
  StrCmp "$OldExeFolder" "." +3
  IfFileExists "$INSTDIR\$OldExeFolder" 0 +2
  RMDir /rebootok "$INSTDIR\$OldExeFolder"

  ; We now kill the entire product directory - there is a case where someone may
  ; have placed files in this directory. RMDir is tricky because it is stateless.
  ; There are two reasons why there may be files left and RMDir fails at first:
  ; There are stray files, or there are locked executable files that will be removed
  ; on reboot. We cannot differentiate. I see no reasonable way to fix this with the current
  ; NSIS functionality.
  ; But if this is the case, we'll just have to live with a directory that is not deleted.

  ; This won't delete the directory if it's non-empty, so it's fairly ok to try.
  ; The idea with /rebootok is to get it deleted if there's an exe-file that's locked - then this
  ; will delete the folder at the next reboot after that file is deleted. Doesn't work an all OS's.
  ; We only do this when installed to the standard location, to avoid unnecessary reboot in the other case.
  StrCmp "$INSTDIR" "${STD_INSTALL_DIR}" 0 +3
  push /rebootok
  goto +2
  push ""
  
  push "$PROGRAMFILES"
  push "$INSTDIR"
  Call ${UN}ClearEmptyFolders

  ; Delete various traces in the registry
  DeleteRegKey HKCR "Applications\${PROGRAM_NAME}"
  
  ; Extended test for empty when deleting these (/ifempty only checks for sub-keys - not values)
  Push "SOFTWARE\${COMPANY}\${PROGRAM}"
  Call ${UN}RegDelEmptyKeyHKCU
  Push "SOFTWARE\${COMPANY}"
  Call ${UN}RegDelEmptyKeyHKCU
  
  DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu2\Programs\${STARTMENU}"
  DeleteRegKey /ifempty HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu2\Programs\${COMPANY}"
  DeleteRegKey HKLM "SOFTWARE\Classes\Applications\${PROGRAM_NAME}"
  DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\${EXTLC}"

  ; Must be after call to uninstallation!
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}"
  
  ; Extended test for empty when deleting these (/ifempty only checks for sub-keys - not values)
  Push "SOFTWARE\${COMPANY}\${PROGRAM}"
  Call ${UN}RegDelEmptyKeyHKLM
  Push "SOFTWARE\${COMPANY}"
  Call ${UN}RegDelEmptyKeyHKLM

  ClearErrors
FunctionEnd
!macroend
!insertmacro DeleteEverything ""
!insertmacro DeleteEverything "un."

!macro CreateOneShortCut FileNo Link Target Params
  ClearErrors
  CreateShortCut "${Link}" "${Target}" "${Params}" 
  IfErrors +2
  FileWrite ${FileNo} "${Link}$\r$\n"
!macroend

; Attempt installation in one given context, named on the stack.
; Set the error flag if an error occurrs, and return. You have to
; specify exactly 'all' or 'current'.
Function OneStartMenuContext
  pop $0
  ClearErrors

  strcmp $0 "all" 0 +2
  SetShellVarContext all
  strcmp $0 "current" 0 +2
  SetShellVarContext current

  IfErrors +2
  CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
  IfErrors +2
  strcmp "${ACTIVATION}" "" ActivationLinkDone

  ClearErrors
  
  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\${ACTIVATION}.lnk" "$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" -l
  IfErrors MenuError
  
ActivationLinkDone:
  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_UNLOAD).lnk" "$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" -x 
  IfErrors MenuError

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_AXDECRYPT).lnk" "$INSTDIR\$EXE_FOLDER\${SELFDEC_NAME}" ""
  IfErrors MenuError

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_README).lnk" "${README_URL}" ""
  IfErrors MenuError

  !ifdef MANUAL_URL
  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_MANUAL).lnk" "${MANUAL_URL}" ""
  IfErrors MenuError
  !endif

  !ifdef MANUAL_PDF_URL
  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_MANUAL_PDF).lnk" "${MANUAL_PDF_URL}" ""
  IfErrors MenuError
  !endif

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_LICENSE).lnk" "$INSTDIR\${LICENSE_NAME}" ""
  IfErrors MenuError

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_UNINSTALL).lnk" "$INSTDIR\${PROGRAM}U.exe" ""
  IfErrors MenuError

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_NOTIFYME).lnk" "$INSTDIR\$EXE_FOLDER\${NOTIFY_NAME}" ""
  IfErrors MenuError

  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\$(AX_TEXT_SM_BUGREPORT).lnk" "${BUG_REPORT_URL}" ""
  IfErrors MenuError

  !ifdef CUSTOM_MENU_URL
  !insertmacro CreateOneShortCut $9 "$SMPROGRAMS\$STARTMENU_FOLDER\${CUSTOM_MENU_TEXT}.lnk" "${CUSTOM_MENU_URL}" ""
  IfErrors MenuError
  !endif

 MenuError:
  ; Now errorflag is set if there's a problem.
FunctionEnd

Function ProgramStartMenuInst
  !insertmacro MUI_STARTMENU_WRITE_BEGIN ProgramStartMenu

  FileOpen $9 $INSTDIR\${UNINST_FILES_STARTMENU} a
  FileSeek $9 0 END
   
  ; We first try to set in 'all' contexts...
  push "all"
  call OneStartMenuContext

  ; ...if that fails, we just set it in current instead.
  iferrors 0 +3
  push "current"
  call OneStartMenuContext

  ClearErrors
  
  FileClose $9

  !insertmacro MUI_STARTMENU_WRITE_END
FunctionEnd

;
; Legacy delete of likely known links in the start menu, including known behavior of previous
; versions.
;
!macro ManualLinkDelete ShellContext Folder
  SetShellVarContext ${ShellContext}
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_UNLOAD).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_AXDECRYPT).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_README).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_MANUAL).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_LICENSE).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_UNINSTALL).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_NOTIFYME).lnk"
  Delete "$SMPROGRAMS\${Folder}\$(AX_TEXT_SM_BUGREPORT).lnk"
!macroend

; A macro so that it can be called from install as well as uninstall
!macro ProgramStartMenuUnInst UN
Function ${UN}ProgramStartMenuUnInst
  push $0
  push $AX_TMP
  ; Start by getting the program start menu name. We can't use $0 etc here, that's why AX_TMP
  !insertmacro MUI_STARTMENU_GETFOLDER ProgramStartMenu $AX_TMP

  IfFileExists "$INSTDIR\${UNINST_FILES_STARTMENU}" DoDeleteByList
  
  ; Legacy clean-up - earlier versions did not use a list of installed short cuts
  ; This is far from perfect. We use two different strategies. If the start menu
  ; items are in a folder where the last part matches our program name as in the
  ; default, we dare a recursive delete of start-menu items.
  ; If they have been placed elsewhere, we try to remove the known links, including
  ; known legacy links - the problem being that they are version and language dependent
  ; so there's a fair risk of leaving something behind.

  StrCmp "$AX_TMP" "${STARTMENU}" +2 TryManualLinkDelete
  StrCmp "$AX_TMP" "${PROGRAM}" 0 TryManualLinkDelete
  
  SetShellVarContext all
  Delete "$SMPROGRAMS\$AX_TMP\*.*"  
  
  SetShellVarContext current
  Delete "$SMPROGRAMS\$AX_TMP\*.*"  
  goto DoneDelete
  
TryManualLinkDelete:
  !insertmacro ManualLinkDelete all "$AX_TMP"
  !insertmacro ManualLinkDelete current "$AX_TMP"
  goto DoneDelete

DoDeleteByList:
  DetailPrint "Deleting start menu by list..."
  push "$INSTDIR\${UNINST_FILES_STARTMENU}"
  Call ${UN}DeleteFilesByList
DoneDelete:
  
  ; Delete Empty start menu folders for 'all'
  SetShellVarContext all
  GetFullPathName $0 "$SMPROGRAMS\$AX_TMP"
  DetailPrint "Axcrypt is at $AX_TMP, Menu is at $0, Top is $SMPROGRAMS"
  push ""
  push "$SMPROGRAMS"
  push $0
  Call ${UN}ClearEmptyFolders

  ; Delete Empty start menu folders for 'current'
  SetShellVarContext current
  GetFullPathName $0 "$SMPROGRAMS\$AX_TMP"
  DetailPrint "Axcrypt is at $AX_TMP, Menu is at $0, Top is $SMPROGRAMS"
  push ""
  push "$SMPROGRAMS"
  push $0
  Call ${UN}ClearEmptyFolders

  ClearErrors
  pop $AX_TMP
  pop $0
FunctionEnd
!macroend
!insertmacro ProgramStartMenuUnInst ""
!insertmacro ProgramStartMenuUnInst "un."

; Check basic format of email. Address to check on top of stack.
; Return "" on ok, "something" if error
Function ValidateEmail
    Exch $0
    Push $1

    Push $0
    Push "@"
    Call StrStr
    Pop $0
    StrCmp $0 "" NotOk

    Push $0
    Push "."
    Call StrStr
    Pop $0
    StrCmp $0 "" NotOk

    Goto Ok
NotOk:
    StrCpy $0 "Invalid"
    Goto Done

Ok:
    StrCpy $0 ""
    
Done:
    Pop $1
    Exch $0
FunctionEnd

 ; StrStr
 ; input, top of stack = string to search for
 ;        top of stack-1 = string to search in
 ; output, top of stack (replaces with the portion of the string remaining)
 ; modifies no other variables.
 ;
 ; Usage:
 ;   Push "this is a long ass string"
 ;   Push "ass"
 ;   Call StrStr
 ;   Pop $R0
 ;  ($R0 at this point is "ass string")
!macro StrStr UN
 Function ${UN}StrStr
 Exch $R1 ; st=haystack,old$R1, $R1=needle
   Exch    ; st=old$R1,haystack
   Exch $R2 ; st=old$R1,old$R2, $R2=haystack
   Push $R3
   Push $R4
   Push $R5
   StrLen $R3 $R1
   StrCpy $R4 0
   ; $R1=needle
   ; $R2=haystack
   ; $R3=len(needle)
   ; $R4=cnt
   ; $R5=tmp
   loop:
     StrCpy $R5 $R2 $R3 $R4
     StrCmp $R5 $R1 done
     StrCmp $R5 "" done
     IntOp $R4 $R4 + 1
     Goto loop
 done:
   StrCpy $R1 $R2 "" $R4
   Pop $R5
   Pop $R4
   Pop $R3
   Pop $R2
   Exch $R1
 FunctionEnd
!macroend
!insertmacro StrStr ""
;!insertmacro StrStr "un."

Function CheckIfUpgrade
  StrCmp "$OldInstallDir" "" +2
  Abort ; If we have an OldInstallDir, let's not show this page
FunctionEnd

;
; Install a file, with no handling of the case should it be locked.
;
!macro InstallOneFile FileNo FolderPath FileName FileCmdParam
  ClearErrors
  File ${FileCmdParam} "${FolderPath}\${FileName}"
  IfErrors +2
  FileWrite ${FileNo} "$OUTDIR\${FileName}$\r$\n"
!macroend

;
; Set EXE_FOLDER to a subdirectory based on REL in INSTDIR that does
; not exist at this time. The idea is to always install in a new
; unique location
;
Function SetExeFolder
  StrCpy $EXE_FOLDER ${REL}
  IfFileExists "$INSTDIR\$EXE_FOLDER" 0 Done
  push $0
  StrCpy $0 0

TryAgain:
  StrCpy $EXE_FOLDER "${REL}-$0"
  IntOp $0 $0 + 1
  IfFileExists "$INSTDIR\$EXE_FOLDER" TryAgain
  IfFileExists "$INSTDIR\$EXE_FOLDER\*.*" TryAgain

  pop $0
Done:
FunctionEnd

;  Do the actual installation, handling upgrades if it's the same major version. This
;  is checked in the CheckForPreviousVersion macro.
;
Section $(AX_TEXT_SETUPALL_SHORT) ${PROGRAM}
  ; Set the install type to the one and only we support: 'Full'
  SectionIn 1 RO

  ; Check if we have an old installation dir - that means we're in upgrade mode.
  StrCmp "$OldInstallDir" "" NewInstall
  StrCpy $INSTDIR $OldInstallDir

  ; Check if we have the function server and the message dll there still...
  IfFileExists "$OldInstallDir" 0 ProgramStopped
  IfFileExists "$OldInstallDir\$OldExeFolder" 0 ProgramStopped
  IfFileExists $OldInstallDir\$OldExeFolder\${PROGRAM_NAME} 0 ProgramStopped
  IfFileExists $OldInstallDir\$OldExeFolder\${MESSAGES_NAME} 0 ProgramStopped

  ; Stop the existing function server (if it is running)
  ClearErrors
  ; $0 windows error code, 0 on success
  push $1 ; $1 exitcode of new process 
  UAC::ExecWait "" "$OldInstallDir\$OldExeFolder\${PROGRAM_NAME}" "-x" ""
  exch $1
  pop $0
  IfErrors AbortInstall
  StrCmp $0 0 "" AbortInstall

;  ClearErrors
;  ExecWait '"$OldInstallDir\$OldExeFolder\${PROGRAM_NAME}" -x' $0
;  IfErrors AbortInstall
;  StrCmp $0 0 "" AbortInstall

  Sleep 1000

ProgramStopped:

  ; Remove all the start menu stuff if we're upgrading
  Call ProgramStartMenuUnInst

  GoTo DoInstall

NewInstall:
DoInstall:
  StrCpy $InstallStarted Yes

  ; Also clean up previous versions exe-files
  Call DeleteExeFiles
  ; Executables dir should be empty, if not - not much we can do about it.
  StrCmp "$OldExeFolder" "." +3
  IfFileExists "$INSTDIR\$OldExeFolder" 0 +2
  RMDir /rebootok "$INSTDIR\$OldExeFolder"

  Call SetExeFolder

  ;Store install folder
  WriteRegStr HKLM "Software\${COMPANY}\${PROGRAM}" "" $INSTDIR
  WriteRegStr HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Install_Dir" "$INSTDIR"
  WriteRegStr HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "ExeFolder" "$EXE_FOLDER"
  
  ; write uninstall strings
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "DisplayName" $(AX_TEXT_DN_UNINSTALL)
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "UninstallString" '"$INSTDIR\${PROGRAM}U.exe"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "DisplayIcon" '"$INSTDIR\${ICON_NAME},0"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "Publisher" "${COMPANY}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "URLInfoAbout" "${SUPPLIER_URL}"
  WriteRegDword HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "NoModify" 1
  WriteRegDword HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "NoRepair" 1

  ; write some basic installer stuff
  WriteRegStr HKLM "Software\${COMPANY}\${PROGRAM}" "AfterNotifyName" "${NOTIFY_NAME}"
  WriteRegStr HKLM "Software\${COMPANY}\${PROGRAM}" "BugReport" "${BUG_REPORT_URL}"
  WriteRegStr HKLM "Software\${COMPANY}\${PROGRAM}" "DocumentationName" "${README_URL}"
  WriteRegStr HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" Version "${REL}"
  WriteRegDword HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "DefaultLanguageId" $LANGUAGE

  ; Ensure that we do not show up on the frequently used list
  WriteRegStr HKCR "Applications\${PROGRAM_NAME}" NoStartPage  ""
  WriteRegStr HKCR "Applications\${NOTIFY_NAME}" NoStartPage  ""

  ; Default value for activation menu depends on if there's a START-menu item.
  strcmp "${ACTIVATION}" "" +2
  WriteRegDword HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "ShowActivationMenu" 1

  ; write user-specific information
  WriteRegDword HKCU "SOFTWARE\${COMPANY}\${PROGRAM}" "DefaultLanguageId" $LANGUAGE
  ; write notification informatoin
  WriteRegStr HKCU "Software\${COMPANY}\${PROGRAM}" NotifyEmail $NotifyEmail
  WriteRegStr HKCU "Software\${COMPANY}\${PROGRAM}" NotifyPreference $NotifyPreference

  ; Even if we're upgrading, we don't care about old stuff, we just leave it laying
  ; around in that case. Can't really see how we can do it any other reasonable way.
  ; But we do a half-hearted attempt anyway... Also, we need to do this first, to avoid
  ; deleting newly installed files installed later.
  Call DeleteNonExeFiles

  ;Create uninstaller
  SetOutPath $INSTDIR

  ; Store the list of EXE-files installed
  FileOpen $9 "$INSTDIR\${UNINST_FILES_EXE}" a
  FileSeek $9 0 END
  WriteUninstaller "$INSTDIR\${PROGRAM}U.exe"
  FileWrite $9 "$INSTDIR\${PROGRAM}U.exe$\r$\n"

  ; The program files and dll's may be locked, so we always install those files to
  ; a new directory, $EXE_FOLDER
  CreateDirectory $INSTDIR\$EXE_FOLDER

  ; We really need the full program installation, and there should be no collissions
  AllowSkipFiles off
  SetOverwrite off
  
  SetOutPath $INSTDIR\$EXE_FOLDER

  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${PROGRAM_NAME}" ""
  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${MESSAGES_NAME}" ""
  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${SHELLEXT_NAME}" ""

  ; These should really not be locked, but... 
  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${SELFDEC_NAME}" ""
  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${AXCRYPT2GO_NAME}" ""
  !insertmacro InstallOneFile $9 "${PACKAGE_PATH}" "${NOTIFY_NAME}" ""
  ; Move this to non-exe, check why it is here to begin with...
  !insertmacro InstallOneFile $9 "${ICON_PATH}" "${ICON_NAME}" ""
  !insertmacro InstallOneFile $9 "${CONFIGXML_PATH}" "${CONFIGXML_NAME}" ""
  !insertmacro InstallOneFile $9 "${SIGSXML_PATH}" "${SIGSXML_NAME}" ""
  
  FileClose $9
  
  ; The following files should ***really*** not be locked...
  AllowSkipFiles on
  SetOverwrite on
  SetOutPath $INSTDIR
  
  ; Store the list of non-EXE-files installed
  FileOpen $9 $INSTDIR\${UNINST_FILES_NONEXE} a
  FileSeek $9 0 END

  ; Include CSS, ReadMe and the User Manual
  !ifdef README_PATH
  !ifdef CSS_NAME
  !insertmacro InstallOneFile $9 "${README_PATH}" "${CSS_NAME}" ""
  !endif
  !ifdef README_NAME
  !insertmacro InstallOneFile $9 "${README_PATH}" "${README_NAME}" ""
  !endif
  !endif
  !ifdef MANUAL_NAME
  !ifdef MANUAL_PATH
  !insertmacro InstallOneFile $9 "${MANUAL_PATH}" "${MANUAL_NAME}" ""
  !endif
  !endif

  !insertmacro InstallOneFile $9 "." "ChangeLog.txt" "/nonfatal"
  !insertmacro InstallOneFile $9 "." "RelNotes.txt" "/nonfatal"
  !insertmacro InstallOneFile $9 "${LICENSE_PATH}" "${LICENSE_NAME}" ""

  !ifdef ETC_PATH
  SetOutPath "$INSTDIR\etc"
  !insertmacro InstallOneFile $9 "${ETC_PATH}" "*.*" "/nonfatal"
  SetOutPath "$INSTDIR"
  !endif

  ; Check for psapi.dll need, but not if we know we're in a modern OS
  
  Call GetWindowsVersion
  Pop $R1
  StrCmp $R1 'Win2K' NoNeedPsapi
  StrCmp $R1 'WinXP' NoNeedPsapi
  StrCmp $R1 'W2003' NoNeedPsapi
  StrCmp $R1 'WinVista' NoNeedPsapi

  ClearErrors
  ExecWait '"$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" -p' $R1
  DetailPrint "${PROGRAM} -p returns $R1"
  IntCmp $R1 0 NoNeedPsapi
  IntCmp $R1 1 0 AbortInstall AbortInstall
  DetailPrint "Checking if psapi.dll is already installed."
  ifFileExists "$SYSDIR\psapi.dll" NoNeedPsapi

  ; We will never uninstall psapi.dll, since there's no way for us to determine if anyone else
  ; is using it after we installed it.
  DetailPrint "Attempting to install psapi.dll"
  SetOutPath "$SYSDIR"
  ClearErrors
  File /oname=psapitmp.dll ${PSAPI_PATH}\psapi.dll
  IfErrors PsapiError
  rename /rebootok $SYSDIR\psapitmp.dll $SYSDIR\psapi.dll
  goto PsapiOk
  
PsapiError:
  StrCpy $AbortHeaderSubText $(AX_TEXT_PSAPIERR)
  Abort

NoNeedPsapi:
PsapiOk:

  ; Even if we're upgrading, we call to do a new registry install. This should do no harm,
  ; and may be necessary to keep all in sync since some things have changed in later versions.
  ; User-set values are retained by -i.
  StrCmp "$OldInstallDir" "" 0 0
  
  ClearErrors
  ExecWait '"$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" -i "${EXTLC}"' $R1
  IfErrors AbortInstall
  StrCpy $AbortHeaderSubText "${PROGRAM} Error Code is $R1"
  StrCmp $R1 0 "" AbortInstall

  call ProgramStartMenuInst
  goto Done

AbortInstall:
  Abort

Done:

  MessageBox MB_YESNO|MB_ICONQUESTION "$(AX_TEXT_OKTONOTIFY) $NotifyURL" /SD IDYES IDYES DoNotify
  MessageBox MB_YESNO|MB_ICONEXCLAMATION "$(AX_TEXT_PLSNOTIFY)" /SD IDNO IDYES RegOk
DoNotify:
  
  DetailPrint "Sending notfication preferences"
  NSISdl::download_quiet /TIMEOUT=10000 "${NOTIFY_URL}?$NotifyURL" "$TEMP\NotifyMe.htm"

  pop $0
  StrCmp $0 "success" RegOk
  ; We have a problem with proxies sometimes not returning the actual content, but
  ; if we get this message - our server has gotten the request anyway
  StrCmp $0 "Server did not specify content length." RegOk

  ; We also seem to have a problem with some users attempting multiple registrations
  ; in sequence - presumably because they got an error reported. As a debug feature, we'll
  ; now check if it's the most common 'real' problem with a missing connection. If it's
  ; not, we'll try to report it back to the notification site, so we see what kind of
  ; errors the user encounter.
  StrCmp $0 "resolving hostname" +3
  DetailPrint "Sending debug report of notification preference failure"
  NSISdl::download_quiet /TIMEOUT=2000 "${NOTIFY_URL}?$NotifyURL&Error=$0" "NUL:"

  MessageBox MB_OK '$(AX_TEXT_NOTIFYFAILED) [$0]' /SD IDOK
RegOk:
SectionEnd

Function .onInstFailed
  ${UAC.Unload} ;Must call unload!

  ; Check if we got to the install section - only then do we need to clean up.
  StrCmp $InstallStarted "Yes" "" AbortInstall3

  ; Try to run -u if we have the necessary programs.
  IfFileExists "$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" 0 AbortInstall2
  IfFileExists "$INSTDIR\$EXE_FOLDER\${MESSAGES_NAME}" 0 AbortInstall2

  ExecWait '"$INSTDIR\$EXE_FOLDER\${PROGRAM_NAME}" -u'
  ; Here we do nothing, even on error - it's a best effort thing

AbortInstall2:
  ; Just move current directory away so we can delete the install folder if necessary
  SetOutPath $TEMP
  Call DeleteEverything

AbortInstall3:

FunctionEnd

;
; Check if there is a previous version. If it's a different major version, we require
; an uninstall. In the future, a new major version could well handle an upgrade from
; a lower major version, but currently we cannot support a downgrade from an unknown
; future major version difference, so we stop that here. If we're upgrading, we'll
; later skip the location page later, as we're upgrading the existing in-place.
;
; This is used as a creator_function for a Page custom instruction. If it does not
; init and show the dialog, nothing happens (visibly). If it is shown, a leave_funcion,
; in this case UninstallPrevious, can keep us there by calling 'abort'. That way we
; can assert that the user really did complete the uninstall, if that was required.
;
Function CheckForPreviousVersion
  push $R1
  push $R2
  
  !insertmacro MUI_HEADER_TEXT "$(TEXT_IO_TITLE)" "$(TEXT_IO_SUBTITLE)"

  ; Get and save various user parameters
  call GetUserParams

  ; Check if we already read it previously (the user may go back and forth)
  ClearErrors
  StrCmp $OldInstallDir "" 0 +3
  ReadRegStr $OldInstallDir HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Install_Dir"
  IfErrors NewOrUpgrade
  
  ReadRegStr $OldExeFolder HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "ExeFolder"
  IfErrors 0 +2
  StrCpy $OldExeFolder "."
  
  ; Now we know we have a current installation directory, let's check the
  ; version number.
  ; If the major version is the same, or it's an early version 1,
  ; it's an upgrade/new install. Otherwise we require an uninstall.
  StrCmp "$NotifyPrevious" "" NewOrUpgrade
  StrCmp "$NotifyPrevious" "Yes" NewOrUpgrade ; Early version 1 - no known version info.
  StrCpy $R1 "$NotifyPrevious" 1
  StrCpy $R2 "${REL}" 1
  StrCmp $R1 $R2 NewOrUpgrade
  
  ; We had an old install with different major, let's ensure the user uninstalls first.
  ; In the context at the time of writing, a different major must mean that we're attempting
  ; a downgrade back to version 1.
  
  ; *** This code is only valid for a downgrade to version 1 - this code is written for
  ; *** version 1. Do not use this for version 2 handling of version 1 - That should also
  ; *** be an upgrade. Nota bene - Do *NOT* execute the 1.6 uninstaller if it was installed
  ; *** in a non-standard, non-unique directory - there's a RMDir /r lurking there.... :-(
  
  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "iopcheck.ini"
  Pop $AX_HWND

  GetDlgItem $AX_HWNDITEM $AX_HWND 1200
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_PREVFOUND)

  !insertmacro MUI_INSTALLOPTIONS_SHOW

NewOrUpgrade:
  pop $R2
  pop $R1
FunctionEnd

Function UninstallPrevious
  StrCmp $OldInstallDir "" NoUninstall

  ; Check for core files existance, otherwise we're in a partial state.
  IfFileExists "$OldInstallDir" 0 UnInstallOk
  IfFileExists "$OldInstallDir\$OldExeFolder" 0 UnInstallOk
  IfFileExists $OldInstallDir\$OldExeFolder\${PROGRAM_NAME} 0 FilesLeft
  IfFileExists $OldInstallDir\$OldExeFolder\${PROGRAM}U.exe 0 FilesLeft
  IfFileExists $OldInstallDir\$OldExeFolder\${SHELLEXT_NAME} 0 FilesLeft
  IfFileExists $OldInstallDir\$OldExeFolder\${MESSAGES_NAME} 0 FilesLeft

  ; $0 windows error code, 0 on success
  push $1 ; $1 exitcode of new process 
  MessageBox MB_OK 'Checkpoint!' /SD IDOK
  UAC::ExecWait "" "$OldInstallDir\$OldExeFolder\${PROGRAM_NAME}" "-x" ""
  exch $1
  pop $0 ; exitcode of new process
  IfErrors FilesLeft
  StrCmp $0 0 "" FilesLeft

;  ClearErrors
;  ExecWait '"$OldInstallDir\$OldExeFolder\${PROGRAM_NAME}" -x' $0
;  IfErrors FilesLeft
;  StrCmp $0 0 "" FilesLeft
;  
  Sleep 1000

  ExecWait '"$OldInstallDir\$OldExeFolder\${PROGRAM}U.exe"'
  ; The uninstall does not work to wait for, so we display a
  ; message 'click to continue', and check the status when it gets clicked.
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$_CLICK

  ; This way we stay in the dialog, with a new message. When the
  ; user clicks 'Next', we come back at the top, and we check again.
  ; If the user aborted the uninstall we just jump right back...
  Abort

FilesLeft:
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_FILESLEFT)
  
  ; Stay in dialog, this does not abort the entire install
  Abort

UnInstallOk:

NoUninstall:

FunctionEnd

;
; Do various check and see if any special messages etc should be displayed
;
Function SpecialMsgCheck
  ; In version 1.5.1 we do not have complete Spanish texts, let's alert the user
  ; and kindly ask for assistance
  ; IntCmp $LANGUAGE 1034 0 NotSpanish NotSpanish
  ; MessageBox MB_OK "The Spanish translation is incomplete. If you'd like to help, send a mail to ${EMAIL}. Thank You." /SD IDOK

;NotSpanish:
FunctionEnd

; GetWindowsVersion
;
; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
; Updated by Joost Verburg
; Modified for this usage by Svante Seleborg
;
; Returns on top of stack
;
; Windows Version: Win95, Win98, WinME, NTx.x, Win2K, WinXP, W2003
; or
; 'WinXX' (Unknown Windows Version)
;
; Usage:
;   Call GetWindowsVersion
;   Pop $R0
;   ; at this point $R0 is "NT4.0" or whatnot

!macro GetWindowsVersion UN
Function ${UN}GetWindowsVersion
 
   Push $R0
   Push $R1
 
   ClearErrors
   ReadRegStr $R0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
   IfErrors 0 lbl_winnt
   
   ; we are not NT
   ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows\CurrentVersion" VersionNumber
 
   StrCpy $R1 $R0 1
   StrCmp $R1 '4' 0 lbl_error
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '4.0' lbl_win32_95
   StrCmp $R1 '4.9' lbl_win32_ME lbl_win32_98
 
   lbl_win32_95:
     StrCpy $R0 'Win95'
   Goto lbl_done
 
   lbl_win32_98:
     StrCpy $R0 'Win98'
   Goto lbl_done
 
   lbl_win32_ME:
     StrCpy $R0 'WinME'
   Goto lbl_done
 
   lbl_winnt:
 
   StrCpy $R1 $R0 1
 
   StrCmp $R1 '3' lbl_winnt_x
   StrCmp $R1 '4' lbl_winnt_x
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '5.0' lbl_winnt_2000
   StrCmp $R1 '5.1' lbl_winnt_XP
   StrCmp $R1 '5.2' lbl_winnt_2003
   StrCmp $R1 '6.0' lbl_vista lbl_error
 
   lbl_winnt_x:
     StrCpy $R0 "NT$R0" 5
   Goto lbl_done
 
   lbl_winnt_2000:
     Strcpy $R0 'Win2K'
   Goto lbl_done
 
   lbl_winnt_XP:
     Strcpy $R0 'WinXP'
   Goto lbl_done
 
   lbl_winnt_2003:
     Strcpy $R0 'W2003'
   Goto lbl_done
 
   lbl_vista:
     Strcpy $R0 'WinVista'
   Goto lbl_done
 
   lbl_error:
     Strcpy $R0 'WinXX'
   lbl_done:
 
   Pop $R1
   Exch $R0
 
FunctionEnd
!macroend
!insertmacro GetWindowsVersion ""
;!insertmacro GetWindowsVersion "un."

;
; Get the most current information we have on version, e-mail and notification preference
; into $NotifyPrevious, $NotifyEmail and $NotifyPreference respectively - also
; write these values to $TEMP\${PROGRAM}.ini as a persistent store that will survive a
; regular uninstall.
;
; The preference order is:
;		$Variable
;		Registry
;		${PROGRAM}.ini
;
Function GetUserParams
  StrCmp $NotifyPrevious "" 0 GotPrevious

  ReadRegStr $NotifyPrevious HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Version"
  StrCmp $NotifyPrevious "" 0 GotPrevious

  ReadINIStr $NotifyPrevious "$TEMP\${PROGRAM}.ini" "Previous" "Version"
  StrCmp $NotifyPrevious "" 0 GotPrevious

  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Install_Dir"
  IfErrors GotPrevious
  StrCpy $NotifyPrevious "Yes"

GotPrevious:
  StrCmp $NotifyPrevious "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Version" $NotifyPrevious 

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\${COMPANY}\${PROGRAM}" NotifyEmail

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadINIStr $NotifyEmail "$TEMP\${PROGRAM}.ini" "Previous" "Email"

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\Microsoft\Office\Outlook\OMI Account Manager\Accounts\00000001" "SMTP Email Address"

  StrCmp $NotifyEmail "" 0 GotEmail
  ReadRegStr $NotifyEmail HKCU "Software\Microsoft\MessengerService\ListCache\.NET Messenger Service" "IdentityName"

GotEmail:
  StrCmp $NotifyEmail "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Email" $NotifyEmail 

  StrCmp $NotifyPreference "" 0 GotPreference
  ReadRegStr $NotifyPreference HKCU "Software\${COMPANY}\${PROGRAM}" NotifyPreference

  StrCmp $NotifyPreference "" 0 GotPreference
  ReadINIStr $NotifyPreference "$TEMP\${PROGRAM}.ini" "Previous" "Preference"

GotPreference:
  StrCmp $NotifyPreference "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Preference" $NotifyPreference 
FunctionEnd

;
; Ask for e-mail for update notifications
;
Function AskForNotifyEmail
  !insertmacro MUI_HEADER_TEXT "$(TEXT_IO_NOTIFYTITLE)" "$(TEXT_IO_NOTIFYSUBTITLE)"

  call GetUserParams

  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 4" "State" 0 ; Update
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 5" "State" 0 ; Critical
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 6" "State" 0 ; Decline

  StrCmp $NotifyPreference "Critical" 0 NotCritical
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 5" "State" 1
  GoTo GotPrePreference

NotCritical:
  StrCmp $NotifyPreference "Decline" 0 NotDecline
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 6" "State" 1
  Goto GotPrePreference

NotDecline:
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 4" "State" 1

GotPrePreference:
  WriteINIStr $NotifyEmail "$PLUGINSDIR\ionotify.ini" "Field 2" "State"

  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "ionotify.ini"
  Pop $AX_HWND

  GetDlgItem $AX_HWNDITEM $AX_HWND 1200
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYPROMPT)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1201
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$NotifyEmail

  GetDlgItem $AX_HWNDITEM $AX_HWND 1203
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIOYES)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1204
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIOCRIT)

  GetDlgItem $AX_HWNDITEM $AX_HWND 1205
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(TEXT_IO_NOTIFYRADIONO)

  !insertmacro MUI_INSTALLOPTIONS_SHOW
FunctionEnd

Function ExitNotifyEmail
  StrCpy $NotifyURL ""
  StrCpy $R0 ""

  ReadINIStr $NotifyEmail "$PLUGINSDIR\ionotify.ini" "Field 2" "State"
  StrCmp $NotifyEmail "" NoEmail

  ; Check for reasonably valid Email, and stay here otherwise.
  push $NotifyEmail
  Call ValidateEmail
  Pop $R2
  StrCmp $R2 "" OkEmail
  StrCpy $NotifyEmail ""
  WriteINIStr "$PLUGINSDIR\ionotify.ini" "Field 2" "State" $NotifyEmail
  GetDlgItem $AX_HWNDITEM $AX_HWND 1201
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$NotifyEmail
  Abort

OkEmail:
  
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Email" $NotifyEmail
  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "$R0email=$NotifyEmail"

  ; Check if 'Yes'
  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 4" "State"
  StrCpy $NotifyPreference "Update"
  StrCmp $R1 0 0 GotNewPreference

  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 5" "State"
  StrCpy $NotifyPreference "Critical"
  StrCmp $R1 0 0 GotNewPreference

  ReadINIStr $R1 "$PLUGINSDIR\ionotify.ini" "Field 6" "State"
  StrCpy $NotifyPreference "Decline"
  StrCmp $R1 0 0 GotNewPreference

GotNewPreference:
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Preference" $NotifyPreference
  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "$R0$NotifyPreference=1"

NoEmail:
  StrCmp $R0 "" +2
  StrCpy $R0 "$R0&"
  StrCpy $R0 "$R0Program=${PROGRAM}"

  StrCmp $NotifyPrevious "" +2
  StrCpy $R0 "$R0&Previous=$NotifyPrevious"

  StrCpy $R0 "$R0&Version=${REL}"

  Call GetWindowsVersion
  Pop $R1
  StrCpy $R0 "$R0&Windows=$R1"

  StrCpy $R0 "$R0&Language=$LANGUAGE"
  
  StrCpy $NotifyURL $R0
FunctionEnd

Function CheckBetaWarn
  DetailPrint "Running CheckBetaWarn"
  !insertmacro MUI_HEADER_TEXT "$(AX_TEXT_BETAHEADER)" ""

  ; Look for 'x', 'b', 'd' or 'rc' in the version string
  ; indicating that it's a beta release.
  push "${REL}"
  push "x"
  call StrStr
  pop $R0
  StrCmp $R0 "" 0 IsBeta

  push "${REL}"
  push "b"
  call StrStr
  pop $R0
  StrCmp $R0 "" 0 IsBeta

  push "${REL}"
  push "d"
  call StrStr
  pop $R0
  StrCmp $R0 "" 0 IsBeta

  push "${REL}"
  push "rc"
  call StrStr
  pop $R0
  StrCmp $R0 "" 0 IsBeta

  goto IsNotBeta
IsBeta:
  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "iopcheck.ini"

  Pop $AX_HWND

  GetDlgItem $AX_HWNDITEM $AX_HWND 1200
  SendMessage $AX_HWNDITEM ${WM_SETTEXT} 0 STR:$(AX_TEXT_BETAWARN)

  !insertmacro MUI_INSTALLOPTIONS_SHOW

IsNotBeta:
FunctionEnd

;--------------------------------
;Installer Functions

Function .onInit
  DetailPrint "Running .onInit"

  ; Ensure that we're admin. Relaunch with runas/UAC if necessary
  ${UAC.I.Elevate.AdminOnly}

  ;Push $CMDLINE
  ;Call EnsureIsAdmin

  ; Signal that we're starting our install, by creating a fully shareable file that we also
  ; set the FILE_FLAG_DELETE_ON_CLOSE flag on, thus ensuring that we signal completion regardless
  ; of how we exit.
  
  Push $0
  Push $1

  CreateDirectory $INSTDIR
;  System::Call 'kernel32::CreateFileA(t "$INSTDIR\AxCryptF.txt", i ${GENERIC_READ}, i ${FILE_SHARE_all}, i 0, i ${CREATE_ALWAYS}, i ${FILE_FLAG_DELETE_ON_CLOSE}, NULL) i .r1 ?e'
;  StrCpy $FlagFileHandle $1
;  Pop $0 ; Return from GetLastError()
;  DetailPrint "CreateFile(CREATE_ALWAYS) returns $FlagFileHandle and GetLastError() returns $0"

  Pop $1 ; restore
  Pop $0 ; restore

  ; Check if we have at least Internet Explorer version 4
  Call GetIEVersion
  Pop $1
  StrCmp $1 "" +2
  IntCmp $1 4 +3 0 +3
  MessageBox MB_ICONEXCLAMATION '$(AX_TEXT_MUSTIE4) [$1]'
  Quit

  !insertmacro MUI_LANGDLL_DISPLAY

  ;Extract InstallOptions INI files
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "iopcheck.ini"
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "ionotify.ini"

  DetailPrint "Done with .onInit"
FunctionEnd

Function .onInstSuccess
  ${UAC.Unload} ;Must call unload!

; If we installed successfully, record the state of interesting version and
; preference information to ease a subsequent upgrade if applicable. This also
; communicates known settings to a possible later separate notification request,
; via the separate notify script.

  StrCmp $NotifyPrevious "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Version" $NotifyPrevious 

  StrCmp $NotifyEmail "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Email" $NotifyEmail 

  StrCmp $NotifyPreference "" +2
  WriteINIStr "$TEMP\${PROGRAM}.ini" "Previous" "Preference" $NotifyPreference 

  ; Signal that we're done installing - disregard any error
  Push $0
  Push $1

;  System::Call 'kernel32::CloseHandle(i $FlagFileHandle) i .r1 ?e'
;  Pop $0
;  DetailPrint "CloseHandle() returns $1, GetLastError() returns $0"
  
  Pop $1
  Pop $0
  
  ; We want to call it to ensure it's referenced also, since otherwise it gets optimized away and we call it indirectly via UAC
  Call ShellNotifyChange  ; Notify the shell that we are associated with the axcrypt extension
FunctionEnd

;--------------------------------
;Descriptions

  ;USE A LANGSTRING IF YOU WANT A DESCRIPTION TO BE LANGUAGE SPECIFIC

  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    ; Not sure if this is a bug in NSIS MUI or not, the following line is needed to avoid an unnecessary
    ; warning about MUI_TEXT being unreferenced. It's really used for component page mouse over, but since
    ; we're not using that, we get a warning it appears. Anyway, it doesn't hurt and I don't want to have
    ; warnings in the normal case.
    StrCpy $MUI_TEXT ""
    
    !insertmacro MUI_DESCRIPTION_TEXT "${PROGRAM}" $(AX_TEXT_SETUPALL)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section
Section "Uninstall"
  
  ClearErrors
  ReadRegStr $OldExeFolder HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "ExeFolder"
  IfErrors 0 +2
  StrCpy $OldExeFolder "."

  IfFileExists "$INSTDIR\$OldExeFolder\${PROGRAM_NAME}" 0 NoProgram
  IfFileExists "$INSTDIR\$OldExeFolder\${MESSAGES_NAME}" 0 NoProgram

  ; $0 windows error code, 0 on success
  ; $1 exitcode of new process
  push $0
  push $1
  UAC::ExecWait "" "$INSTDIR\$OldExeFolder\${PROGRAM_NAME}" "-x" ""
  exch $1
  pop $R1
  pop $0
  IfErrors ExitFailed
  StrCmp $R1 0 "" ExitFailed

;  ClearErrors
;  ExecWait '"$INSTDIR\$OldExeFolder\${PROGRAM_NAME}" -x' $R1
;  IfErrors ExitFailed
;  StrCmp $R1 0 "" ExitFailed

  Sleep 1000 ;Ensure that all instances have time to exit.

  ; ProgramStartMenuUnInst must be first, since it depends on the registry
  Call Un.ProgramStartMenuUnInst

  ClearErrors
  ExecWait '"$INSTDIR\$OldExeFolder\${PROGRAM_NAME}" -u' $R1
  IfErrors NoUninstall
  StrCmp $R1 0 "" NoUninstall

  ; Signal that we're done unstalling - disregard any error
  Push $0
  Push $1

;  System::Call 'kernel32::CloseHandle(i $FlagFileHandle) i .r1 ?e'
;  Pop $0
;  DetailPrint "CloseHandle() returns $1, GetLastError() returns $0"
  
  Pop $1
  Pop $0

  ; Notify the shell that we are no longer associated with the axcrypt extension
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
  goto DeleteTheRest

NoProgram:
  ; Try deleting this anyway if we found no program
  Call Un.ProgramStartMenuUnInst

DeleteTheRest:
  Call Un.DeleteEverything
  goto NoErrorMsg

ExitFailed:
  StrCpy $AbortHeaderSubText $(AX_TEXT_NOTSTOP)
  abort

NoUninstall:
  StrCpy $AbortHeaderSubText $(AX_TEXT_NOREGREM)
  abort

NoErrorMsg:
SectionEnd

;--------------------------------
;Uninstaller Functions

Function un.onInit
  ${UAC.I.Elevate.AdminOnly}

  !insertmacro MUI_UNGETLANGUAGE

  ; Ensure that we're admin. Relaunch with runas if necessary
  push $0 ; save
  ReadRegStr $0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PROGRAM}" "UninstallString"

;  Push $0
;  Call un.EnsureIsAdmin

  ; Signal that we're starting our install, by creating a fully shareable file that we also
  ; set the FILE_FLAG_DELETE_ON_CLOSE flag on, thus ensuring that we signal completion regardless
  ; of how we exit.
  
  Push $0
  Push $1

;  System::Call 'kernel32::CreateFileA(t "$INSTDIR\AxCryptF.txt", i ${GENERIC_READ}, i ${FILE_SHARE_all}, i 0, i ${CREATE_ALWAYS}, i ${FILE_FLAG_DELETE_ON_CLOSE}, NULL) i .r1 ?e'
;  StrCpy $FlagFileHandle $1
;  Pop $0 ; Return from GetLastError()

  Pop $1 ; restore
  Pop $0 ; restore

  Pop $0
FunctionEnd

Function un.OnUnInstFailed 
  ${UAC.Unload} ;Must call unload!
FunctionEnd

Function un.OnUnInstSuccess 
  ${UAC.Unload} ;Must call unload!
FunctionEnd

Function ShellNotifyChange
  ; Notify the shell that we are associated with the axcrypt extension
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
FunctionEnd

; GetIEVersion
;
; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
; Returns on top of stack
; 1-6 (Installed IE Version)
; or
; '' (IE is not installed)
;
; Usage:
;   Call GetIEVersion
;   Pop $R0
;   ; at this point $R0 is "5" or whatnot

Function GetIEVersion
  Push $R0
  ClearErrors
  ReadRegStr $R0 HKLM "Software\Microsoft\Internet Explorer" "Version"
  IfErrors lbl_123 lbl_456

  lbl_456: ; ie 4+
    Strcpy $R0 $R0 1
  Goto lbl_done

  lbl_123: ; older ie version
    ClearErrors
    ReadRegStr $R0 HKLM "Software\Microsoft\Internet Explorer" "IVer"
    IfErrors lbl_error

      StrCpy $R0 $R0 3
        StrCmp $R0 '100' lbl_ie1
        StrCmp $R0 '101' lbl_ie2
        StrCmp $R0 '102' lbl_ie2
        StrCpy $R0 '3' ; default to ie3 if not 100, 101, or 102.
        Goto lbl_done
          lbl_ie1:
            StrCpy $R0 '1'
          Goto lbl_done
          lbl_ie2:
            StrCpy $R0 '2'
          Goto lbl_done
       lbl_error:
         StrCpy $R0 ''
   lbl_done:
   Exch $R0
FunctionEnd

!ifdef NOTYETIMPLEMENTED
;
; Truncate the string to just before the last back-slash.
;
; Usage:
;    Push "A registry key"
;    Call RegGetSuperKey
;    Pop the 'parent' key.
Function RegGetSuperKey
  Exch $0
  Push $1
  StrCmp $0 "" TruncDone
  StrCpy $1 $0 1 -1 ; Get the last char (if it's a backslash, we want to ignore this)
  StrCmp $1 "\" 0 +2
  StrCpy $0 $0 -1 ; Truncate the last char (the backslash)
TruncLoop:  
  StrCmp $0 "" TruncDone
  StrCpy $1 $0 1 -1 ; Get the last char
  StrCpy $0 $0 -1 ; Truncate the last char (regardless)
  StrCmp $1 "\" TruncLoop
TruncDone:
  Pop $1
  Exch $0
FunctionEnd
!endif

;
; Delete the given sub-key, if it has no keys and no data.
; Set the error flag if no deletion occurred but the key existed
; To to the NSIS feature-set we need to generate different version of
; this function for ever rootkey, and for install/uninstall.
;
; Usage:
;   Push "The sub key"
;   Call RegDelEmptyKey
;   IfErrors NothingDeleted
;
!macro RegDelEmptyKey UN ROOTKEY
Function ${UN}RegDelEmptyKey${ROOTKEY}
  Exch $0 ; Sub-key
  Push $2

  ; Now check if there are any values - including the default value
  ClearErrors
  EnumRegValue $2 ${ROOTKEY} $0 0
  IfErrors NothingToDelete ; If we can't enumerate, we assume this is because it's already gone.
  StrCmp $2 "" 0 NoDelete ; If we get a single name, it's not empty

  ReadRegStr $2 ${ROOTKEY} $0 ""
  StrCmp $2 "" 0 NoDelete ; If there's a default value, it's not empty
  
  ClearErrors
  DeleteRegKey /ifempty ${ROOTKEY} $0
  IfErrors Done

NothingToDelete:
  ClearErrors ; We're done - and did do a delete (or there was nothing to delete)!
  goto Done
NoDelete:
  SetErrors
Done:  
  Pop $2
  Pop $0
FunctionEnd
!macroend
!insertmacro RegDelEmptyKey "" HKLM
!insertmacro RegDelEmptyKey "un." HKLM
!insertmacro RegDelEmptyKey "" HKCU
!insertmacro RegDelEmptyKey "un." HKCU

!ifdef OLDENSUREISADMIN
; GetCommand
; input, TOS a commandline.
; output, Top of stack the unquoted command without parameters.
; modifies no other variables.
!macro GetUnquoteCmd UN
Function ${UN}GetUnquoteCmd
   Exch $R9
   Push $R0
   Push $R1
   Push $R2
   Push $R3
   Push $R4
   
   StrCpy $R2 1
   StrCpy $R4 0 ; Start offset of command
   StrLen $R3 $R9
   
   ; Check if first is quote
   StrCpy $R0 $R9 1 ; Get first char
   StrCmp $R0 '"' 0 blank ; Is it a quote?
     StrCpy $R1 '"' ; Yes, save that fact
     StrCpy $R4 1 ; And update startoffset
     Goto loop
blank:
   StrCpy $R1 " " ; No, save a blank
   
   ; Scan for quote/space or end of line
 loop:
   IntOp $R2 $R2 + 1
   StrCpy $R0 $R9 1 $R2
   StrCmp $R0 $R1 get ; Is it quote/space? yes -> get
   StrCmp $R2 $R3 get ; Is it end of line? yes -> get
   Goto loop
   
 get:
   ; At this point, $R2 is the offset just past what we want
   IntOp $R2 $R2 - $R4 ; Adjust if we offset past leading quote - one less to copy.
   StrCpy $R9 $R9 $R2 $R4

   Pop $R4   
   Pop $R3
   Pop $R2
   Pop $R1
   Pop $R0
   Exch $R9
FunctionEnd
!macroend
!insertmacro GetUnquoteCmd ""
!insertmacro GetUnquoteCmd "un."

; GetParameters
 ; input, TOS is commandline
 ; output, top of stack (replaces, with e.g. whatever)
 ; modifies no other variables.
 
!macro GetParameters UN
Function ${UN}GetParameters
   Exch $R9
   Push $R0
   Push $R1
   Push $R2
   Push $R3
   
   StrLen $R3 $R9
   StrCpy $R2 0

   ;Check for quote or space
   StrCpy $R0 $R9 1 ; Get first char
   StrCmp $R0 '"' 0 +3
     StrCpy $R1 '"'
     Goto loop
   StrCpy $R1 " "

 loop:
   IntOp $R2 $R2 + 1
   StrCpy $R0 $R9 1 $R2 ; R0 is the char at offset R2 (zero-based) of the command line
   StrCmp $R0 $R1 get ; Is it quote or space?
   StrCmp $R0 "" 0 loop ; Are there more chars?
   
 get:
   ; The last char was a quote or one of several space
   IntOp $R2 $R2 + 1
   StrCpy $R0 $R9 1 $R2
   StrCmp $R0 " " get
   StrCpy $R0 $R9 "" $R2 ; This will handle the case of no params as well

   StrCpy $R9 $R0
   Pop $R3
   Pop $R2
   Pop $R1
   Pop $R0
   Exch $R9
 FunctionEnd
!macroend
!insertmacro GetParameters "" 
!insertmacro GetParameters "un."

; Input: TOS is Command line to parse/use for recursive launch
;
; Check if the user is admin - if not, try relaunch with runas.
; If already tried relaunch - just quit. If already admin, return.
;
!macro EnsureIsAdmin UN
Function ${UN}EnsureIsAdmin
  Exch $R9  ; Get the command line to use/parse
  Push $2

  ; Check if we have Admin-rights
  UserInfo::GetAccountType
  Pop $2

  StrCpy $2 '[$2]' ; Just prepare for display formatting
  DetailPrint "User account is $2"

  StrCmp $2 "[Admin]" IsAdmin
  StrCmp $2 "[]" IsError
  
  Push $0  ; Save
  Push $1  ; Save

  ; NT may need admin rights, but does not support 'runas'
  Call ${UN}GetWindowsVersion
  Pop $0
  StrCpy $0 $0 2
  StrCmp $0 "NT" CantRunas
  
  Push $R9
  Call ${UN}GetUnquoteCmd
  Pop $0 ; Get the command to run

  Push $R9
  Call ${UN}GetParameters
  Pop $1 ; Get the parameters

  Push $1 ; Save the parameters

  Push $1
  Push "/runas"
  Call ${UN}StrStr ; Check if /runas is a parameter, if so we've already tried that!
  Pop $1 ; Get the search result

  StrCmp $1 "" 0 IsAlreadyRunas

  Pop $1 ; The original parameters
  
  ; Now try with runas
  StrCmp $1 "" +2
  StrCpy $1 "$1 "

  ; Check for core files existance, we need to try to exit before we go impersonating
  ; to be compatible with older versions which do not grant other users access to the
  ; mutex etc, so we try to kill any eventual existing process here instead.

  ClearErrors
  StrCmp $OldInstallDir "" 0 +3
  ReadRegStr $OldInstallDir HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "Install_Dir"
  IfErrors NoExit
  
  ReadRegStr $OldExeFolder HKLM "SOFTWARE\${COMPANY}\${PROGRAM}" "ExeFolder"
  IfErrors 0 +2
  StrCpy $OldExeFolder "."

  IfFileExists "$OldInstallDir" 0 NoExit
  IfFileExists "$OldInstallDir\$OldExeFolder" 0 NoExit
  IfFileExists $OldInstallDir\$OldExeFolder\${PROGRAM_NAME} 0 NoExit
  IfFileExists $OldInstallDir\$OldExeFolder\${MESSAGES_NAME} 0 NoExit

  ExecWait '"$OldInstallDir\$OldExeFolder\${PROGRAM_NAME}" -x'
  ; No error check - this is a best-effort
NoExit:

  DetailPrint 'Trying: ExecShell "runas" "$0" "$1/runas"'
  ClearErrors
  ExecShell "runas" "$0" "$1/runas"
  IfErrors RunAsError
  
  DetailPrint 'ExecShell Ok'

  ; We have a big trouble with synchronization issues between the impersonated administrator process
  ; and this process. It's just to complicated building DACL's etc in NSIS, so we settle for a flag-
  ; file. The idea is we let the new process have time to open the file for write - thus locking it.
  ; Then, once it gets unlocked - either by that process terminating or because it's closed orderly,
  ; we know that it's done - for good or bad. Then we continue here.
  
  Push $0
  Push $1

RunAsWait:
  Sleep 1000
  System::Call 'kernel32::CreateFileA(t "$INSTDIR\AxCryptF.txt", i ${GENERIC_READ}, i ${FILE_SHARE_all}, i 0, i ${OPEN_EXISTING}, i 0, NULL) i .r1 ?e'
  Pop $0 ; Return from GetLastError()
  DetailPrint "CreateFile(OPEN_EXISTING) returns $1 and GetLastError() returns $0"
  StrCmp $0 0 "" WaitFinished
  System::Call 'kernel32::CloseHandle(i $1)'
  GoTo RunAsWait
  
WaitFinished:
  Pop $1 ; restore
  Pop $0 ; restore

  IfErrors RunAsWait
  
  DetailPrint 'runas has completed'

  ; Now ensure that our completion flag-file is gone

  ; Notify the shell that we are associated with the axcrypt extension. This may not really have an effect,
  ; but it does not hurt at least. What we would like to do is to have us waiting for the runas, but that
  ; does not seem possible. The reason we can't do it in the runas-instance is because it's runnning as
  ; another user, but without a profile, and at least in Win2K the ChangeNotify done there does not affect
  ; the original users desktop. Perhaps we should do a FindWindow and then wait?
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
  GoTo PopQuit
RunAsError:
  DetailPrint 'ExecShell Not Ok'
  StrCpy $2 '$2 ExecShell failed - Possibly "runas" from network share, must be local or trusted for delegation'

  Push $1 ; Keep the stack-state the same for below
IsAlreadyRunas:
  Pop $1 ; Just pop off the original parameters
CantRunas:
  MessageBox MB_ICONEXCLAMATION '$(AX_TEXT_MUSTADMIN) $2'

PopQuit:  
  Pop $1
  Pop $0
  Pop $2
  Pop $R9
  Quit

IsError:
  ; If we can't determine the user (perhaps because we're run as runas from the network)
  ; we signal an error (in english unfortunately)
  MessageBox MB_ICONEXCLAMATION '$(AX_TEXT_MUSTADMIN) [(empty)] Security Context Error - Possibly "runas" from network share, must be local or trusted for delegation'
  Pop $2
  Pop $R9
  Quit
  
IsAdmin:
  DetailPrint "Is Administrator. ${UN}install proceeds."
  Pop $2
  Pop $R9
FunctionEnd
!macroend
!insertmacro EnsureIsAdmin ""
!insertmacro EnsureIsAdmin "un."
!endif
