rem @echo off
rem @(#) $Id: Depend.bat 1176 2008-01-08 08:19:26Z svante $
rem
rem Upate necessary dependencies, if they are available.
rem
rem The idea behind this is to ensure that all librarys and other
rem dependencies are included in the distribution to facilitate
rem rebuilding.
rem
rem This should only run, if the project is set-up properly,
rem when this file is newer than Depend.log. Thus, to force
rem an update of the external dependencies - save this file,
rem or delete Depend.log
rem
rem For this to work, setup a custom build rule for this file,
rem where it outputs "Depend.log", and the command is Depend.bat.
rem
rem Change the locations as necessary to fit your environment.
rem
rem This may be called in three modes, two of which result in
rem recursive calls to this same script.
rem
rem Depend:
rem     Depend Debug
rem     Depend Release
rem
rem Depend [Debug or Release]:
rem     Depend [Debug or Release] SourceDir DestDir File(s)
rem     ...
rem
rem  1 == [Debug or Release]
rem  2 == SourceDir
rem  3 == DestDir
rem  n == Dependency File
rem

if "%1" == "" goto DoAllModes
if not "%2" == "" goto DoFiles

rem
rem Change these locations to whatever is good for you
rem No harm occurs if you don't have the sources if you start with the full source-zip.
rem If you're starting with a CVS tar-ball or similar, you do need to find these sources.
rem
rem The assumed directory structure here is:
rem
rem Anyplace
rem     AxCrypt
rem             Common
rem                    AxCrypt
rem                    Contrib
rem                            AES
rem                            AxLib
rem                            AxPipe
rem                            AxSigLib
rem                            CryptoPP
rem                            Redistrib
rem                            Zlib
rem                            wtl
rem                    Misc
rem                         Depend.bat (this file)
rem     AxLib
rem     AxPipe
rem     AxSigLib
rem     Contrib
rem             cryptopp521
rem             rijndael-fst-3.0
rem             Zlib121
rem             wtl75

echo This is a log-file from Depend.bat... 1>Depend.log

if not exist ..\Contrib mkdir ..\Contrib

rem *** Get psapi.dll from Microsoft ***
if not exist ..\Contrib\Redistrib mkdir ..\Contrib\Redistrib
call %0 %1 ..\..\..\Contrib\psapi ..\Contrib\Redstrib psapi.dll

rem *** Get zlib from http://zlib.org ***
if not exist ..\Contrib\Zlib mkdir ..\Contrib\Zlib 
call %0 %1 ..\..\..\Contrib\Zlib121 ..\Contrib\Zlib *.c *.h README

rem *** Get wtl (Windows Template Library) from http://wtl.sourceforge.net
if not exist ..\Contrib\wtl mkdir ..\Contrib\wtl
call %0 %1 ..\..\..\Contrib\wtl75\include ..\Contrib\wtl *.h

rem *** Get AES from http://www.esat.kuleuven.ac.be/~rijmen/rijndael/ ***
if not exist ..\Contrib\AES mkdir ..\Contrib\AES
call %0 %1 ..\..\..\Contrib\rijndael-fst-3.0 ..\Contrib\AES rijndael-alg*.* README

rem *** Get AxPipe from http://axpipe.sourceforge.net ***
if not exist ..\Contrib\AxPipe mkdir ..\Contrib\AxPipe 
call %0 %1 ..\..\..\AxPipe ..\Contrib\AxPipe *.cpp *.h

rem *** Get AxLib by sending an e-mail to axcrypt@axantum.com, but there should be a working copy included
if not exist ..\Contrib\AxLib mkdir ..\Contrib\AxLib
set dirs=..\..\..\AxLib ..\Contrib\AxLib
call %0 %1 %dirs% AxMLite.cpp AxMLite.h GetModuleFilename.h GetModuleFilename.cpp
call %0 %1 %dirs% mygetopt.cpp mygetopt.h stdafx.h stdafx.cpp AxAssert.h AxAssert.cpp
call %0 %1 %dirs% DynLoadString.h DynLoadString.cpp CVersionWin.h CVersionWin.cpp

rem *** Get Crypto++ from....
if not exist ..\Contrib\CryptoPP mkdir ..\Contrib\CryptoPP
set dirs=..\..\..\Contrib\cryptopp521 ..\Contrib\CryptoPP
call %0 %1 %dirs% eccrypto.h eccrypto.cpp pubkey.h pubkey.cpp integer.h integer.cpp asn.h asn.cpp hmac.h hmac.cpp
call %0 %1 %dirs% sha.h sha.cpp gfpcrypt.h gfpcrypt.cpp dh.h dh.cpp mqv.h mqv.cpp ecp.h ecp.cpp ec2n.h ec2n.cpp
call %0 %1 %dirs% filters.h filters.cpp queue.h queue.cpp eprecomp.h eprecomp.cpp smartptr.h smartptr.cpp
call %0 %1 %dirs% modarith.h modarith.cpp seckey.h seckey.cpp secblock.h secblock.cpp cryptlib.h cryptlib.cpp
call %0 %1 %dirs% fips140.h fips140.cpp argnames.h argnames.cpp iterhash.h iterhash.cpp config.h stdcpp.h
call %0 %1 %dirs% misc.h misc.cpp algebra.h algebra.cpp simple.h simple.cpp algparam.h algparam.cpp
call %0 %1 %dirs% modexppc.h modexppc.cpp gf2n.h gf2n.cpp pch.h pch.cpp words.h words.cpp nbtheory.h nbtheory.cpp
call %0 %1 %dirs% oids.h trdlocal.h trdlocal.cpp mqueue.h mqueue.cpp fltrimpl.h randpool.h randpool.cpp 
call %0 %1 %dirs% hex.h hex.cpp mdc.h basecode.h basecode.cpp modes.h modes.cpp strciphr.h strciphr.cpp
call %0 %1 %dirs% dsa.h dsa.cpp nbtheory.h nbtheory.cpp files.h files.cpp

rem *** Get gettext from http://www.gnu.org/software/gettext/
if not exist ..\Contrib\intl mkdir ..\Contrib\intl
set dirs=..\..\..\Contrib\gettext-0.14.5\gettext-runtime ..\Contrib\intl
call %0 %1 %dirs% config.h.msvc
if exist ..\Contrib\intl\config.h attrib -r ..\Contrib\intl\config.h
if exist ..\Contrib\intl\config.h.msvc xcopy /d /i /y ..\Contrib\intl\config.h.msvc ..\Contrib\intl\config.h >nul
if exist ..\Contrib\intl\config.h attrib +r ..\Contrib\intl\config.h

set dirs=..\..\..\Contrib\gettext-0.14.5\gettext-runtime\intl ..\Contrib\intl
call %0 %1 %dirs% *.c *.h libgnuintl.h.msvc-static
if exist ..\Contrib\intl\libgnuintl.h attrib -r ..\Contrib\intl\libgnuintl.h
if exist ..\Contrib\intl\libgnuintl.h.msvc-static xcopy /d /i /y ..\Contrib\intl\libgnuintl.h.msvc-static ..\Contrib\intl\libgnuintl.h >nul
if exist ..\Contrib\intl\libgnuintl.h attrib +r ..\Contrib\intl\libgnuintl.h

rem *** Get AxSigLib by sending an e-mail to axcrypt@axantum.com, but there should be a working copy included
if not exist ..\Contrib\AxSigLib mkdir ..\Contrib\AxSigLib
set dirs=..\..\..\AxSigLib\AxSigLib ..\Contrib\AxSigLib
call %0 %1 %dirs% Base34.h Base34dec.h Base34dec.cpp BaseM.h BaseMDec.h BaseMDec.cpp SVerify.h secdsa.h
call %0 %1 %dirs% CLicMgr.h CLicMgr.cpp CRestrictMgr.h CRestrictMgr.cpp CTrialMgr.h CTrialMgr.cpp stdafx.h stdafx.cpp

rem
rem Clean-up unwanted file(s)
rem

rem if exist Inc\stdafx.h del Inc\stdafx.h
rem if exist Inc\resource.h del Inc\resource.h

goto Exit

:DoAllModes
if not exist Debug mkdir Debug
call %0 Debug
if not exist Release mkdir Release
call %0 Release
goto Exit

:DoFiles
set SrcDir=%2
set DstDir=%3
:NxtFile
if "%4" == "" goto Exit
if exist %DstDir%\%4 attrib -r %DstDir%\%4
if exist %SrcDir%\%4 xcopy /d /i /y %SrcDir%\%4 %DstDir% >nul
if exist %DstDir%\%4 attrib +r %DstDir%\%4
shift
goto NxtFile

:Exit
