/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common;

import com.datastax.devcenter.common.interfaces.DevCenterConstants;
import com.datastax.devcenter.common.jobs.DevCenterLoggingMutex;
import com.datastax.devcenter.common.jobs.LoggingJob;
import com.datastax.devcenter.common.logger.LoggingLevelEnum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;

public class DevCenterLogger {
    private static final String NO_METHOD_NAME = "no method name";
    private static final String NO_CLASS_NAME = "no class name";
    private static File loggingDirectory;
    private static File loggingFile;
    private static PrintWriter printWriter;
    private static String dateFormatString;
    private static boolean loggingFileInitializationFlag;
    private static LoggingLevelEnum loggingLevel;

    static {
        dateFormatString = "yyyy-MM-dd HH:mm:ss.SSSZ";
        loggingLevel = LoggingLevelEnum.INFO;
    }

    static void openLogFile() {
        try {
            String loggingFileName;
            loggingDirectory = new File(DevCenterConstants.LOGGING_DIRECTORY);
            boolean existsFlag = loggingDirectory.exists();
            if (!existsFlag) {
                FileUtils.forceMkdir((File)loggingDirectory);
            }
            if (!(loggingFile = new File(loggingFileName = String.valueOf(DevCenterConstants.LOGGING_DIRECTORY) + DevCenterConstants.FILE_SEPARATOR + "log.txt")).exists()) {
                FileUtils.touch((File)loggingFile);
                FileUtils.writeStringToFile((File)loggingFile, (String)"DevCenter Logger version 0.1.0\n\n\n");
            }
            boolean appendFlag = true;
            FileWriter fileWriter = new FileWriter(loggingFileName, appendFlag);
            printWriter = new PrintWriter(new BufferedWriter(fileWriter));
            loggingFileInitializationFlag = true;
        }
        catch (Exception exception) {
            loggingFileInitializationFlag = false;
        }
    }

    public static void error(String errorString) {
        try {
            DevCenterLogger.error(errorString, NO_CLASS_NAME, NO_METHOD_NAME);
        }
        catch (Exception exception) {}
    }

    public static void error(String message, String classID, String methodName) {
        DevCenterLogger.error(null, message, classID, methodName);
    }

    public static void error(Throwable e, String message, String classID, String methodName) {
        int levelComparator;
        if (!loggingFileInitializationFlag) {
            DevCenterLogger.openLogFile();
        }
        if ((levelComparator = loggingLevel.compareTo(LoggingLevelEnum.ERROR)) > 0) {
            return;
        }
        LoggingJob loggingJob = new LoggingJob(printWriter, e, message, classID, methodName, LoggingLevelEnum.ERROR, dateFormatString);
        loggingJob.setPriority(20);
        loggingJob.setRule(new DevCenterLoggingMutex());
        loggingJob.schedule();
    }

    public static LoggingLevelEnum getLoggingLevel() {
        return loggingLevel;
    }

    public static void setLoggingLevel(LoggingLevelEnum loggingLevel) {
        DevCenterLogger.loggingLevel = loggingLevel;
    }

    public static String getDateFormatString() {
        return dateFormatString;
    }

    public static void setDateFormatString(String dateFormatString) {
        DevCenterLogger.dateFormatString = dateFormatString;
    }
}

