/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.jobs;

import com.datastax.devcenter.common.CommonActivator;
import com.datastax.devcenter.common.logger.LoggingLevelEnum;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class LoggingJob
extends Job {
    private final PrintWriter printWriter;
    private final String message;
    private final String classID;
    private final String methodName;
    private final LoggingLevelEnum loggingLevelEnum;
    private final String dateFormatString;
    private final Throwable exception;

    public LoggingJob(PrintWriter printWriter, Throwable e, String message, String classID, String methodName, LoggingLevelEnum loggingLevelEnum, String dateFormatString) {
        super("Logging Job");
        this.printWriter = printWriter;
        this.exception = e;
        this.message = message;
        this.classID = classID;
        this.methodName = methodName;
        this.loggingLevelEnum = loggingLevelEnum;
        this.dateFormatString = dateFormatString;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.printWriter == null) {
            return null;
        }
        String loggingMessage = this.formatLoggingMessage();
        this.appendToLogFile(loggingMessage);
        this.appendToEclipseLog();
        Status iStatus = new Status(0, "Logging Job", 0, "successful", null);
        return iStatus;
    }

    private String formatLoggingMessage() {
        String FIELD_SEPARATOR = "\t";
        StringBuffer sb = new StringBuffer();
        sb.append((Object)this.loggingLevelEnum);
        sb.append(FIELD_SEPARATOR);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormatString);
        String dateString = simpleDateFormat.format(date);
        sb.append(dateString);
        sb.append(FIELD_SEPARATOR);
        sb.append(this.message);
        sb.append(FIELD_SEPARATOR);
        sb.append(this.classID);
        sb.append(FIELD_SEPARATOR);
        sb.append(this.methodName);
        String tempString = sb.toString();
        return tempString;
    }

    private void appendToLogFile(String loggingMessage) {
        try {
            this.printWriter.println(loggingMessage);
            if (this.exception != null) {
                this.exception.printStackTrace(this.printWriter);
            }
            this.printWriter.flush();
        }
        catch (Exception exception) {}
    }

    private void appendToEclipseLog() {
        try {
            int severityCode = 0;
            switch (this.loggingLevelEnum) {
                case ERROR: {
                    severityCode = 4;
                    break;
                }
                case INFO: {
                    severityCode = 1;
                    break;
                }
                case WARN: {
                    severityCode = 2;
                    break;
                }
                default: {
                    severityCode = 0;
                }
            }
            Status tempStatus = new Status(severityCode, String.valueOf(this.classID) + " # " + this.methodName, this.message);
            CommonActivator.log((IStatus)tempStatus);
        }
        catch (Exception exception) {}
    }
}

