/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.metrics;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class Metric {
    protected ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final String name;
    protected int value = 0;
    protected int lastReportedValue = 0;

    Metric(String name) {
        this.name = name;
    }

    protected abstract int determineNextValue(int var1);

    public int update(Integer with) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        boolean locked = false;
        try {
            lock.lock();
            locked = true;
            this.value = this.determineNextValue(with);
            int n = this.currentValue();
            return n;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public int currentValue() {
        return this.value;
    }

    public void reported(int reportedValue) {
        ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
        boolean locked = false;
        try {
            lock.lock();
            locked = true;
            this.lastReportedValue = reportedValue;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public boolean changedSinceLastReport() {
        ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
        boolean locked = false;
        try {
            lock.lock();
            locked = true;
            boolean bl = this.value - this.lastReportedValue != 0;
            return bl;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public Integer getLastReportedValue() {
        return this.lastReportedValue;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metric other = (Metric)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

