/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.metrics;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.interfaces.DevCenterConstants;
import com.datastax.devcenter.common.metrics.Counter;
import com.datastax.devcenter.common.metrics.Gauge;
import com.datastax.devcenter.common.metrics.MaxGauge;
import com.datastax.devcenter.common.metrics.Metric;
import com.datastax.devcenter.common.metrics.MetricsReporter;
import com.datastax.devcenter.common.utils.PreferencesUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.ResourcesPlugin;

public class Metrics {
    public static final String SECONDS_SINCE_START_METRIC_NAME = "seconds_since_start";
    private static final Timer timer = new Timer();
    private static final Long bootTime = System.currentTimeMillis();
    private static String clientID;
    private static MetricsReporter metricsReporter;
    private static final Map<String, Metric> metrics;

    static {
        metrics = new ConcurrentHashMap<String, Metric>();
    }

    public static void init(URL trustStoreURL) {
        metricsReporter = new MetricsReporter();
        Metrics.getMetricsReporter().setTrustStoreURL(trustStoreURL);
        String javaVersionMetricName = String.format("%s:%s", "java.version", System.getProperty("java.version")).toLowerCase().trim();
        Metrics.incrementCounter(javaVersionMetricName);
        String osVersionMetricName = String.format("%s:%s.%s", "os.version", System.getProperty("org.osgi.framework.os.name"), System.getProperty("os.version")).toLowerCase().trim();
        Metrics.incrementCounter(osVersionMetricName);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (Metrics.isUsageStatisticsReportingEnabled()) {
                        Metrics.report();
                    }
                }
                catch (Exception ex) {
                    try {
                        DevCenterLogger.error(ex.toString(), Metrics.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
                    }
                    catch (Exception exception) {}
                }
            }
        }, 900000L, 900000L);
    }

    public static void report() {
        boolean reportedSuccessfully;
        Metrics.setGaugeValue(SECONDS_SINCE_START_METRIC_NAME, Metrics.getSecondsSinceStart());
        Collection<Metric> changedMetrics = Metrics.filterOutUnchangedMetrics(metrics.values());
        HashMap<Metric, Integer> toReport = new HashMap<Metric, Integer>();
        for (Metric metric : changedMetrics) {
            toReport.put(metric, metric.currentValue());
        }
        if (toReport.size() > 0 && (reportedSuccessfully = Metrics.getMetricsReporter().report(Metrics.getClientID(), toReport))) {
            for (Metric metric : toReport.keySet()) {
                metric.reported((Integer)toReport.get(metric));
            }
        }
    }

    private static MetricsReporter getMetricsReporter() {
        return metricsReporter;
    }

    private static int getSecondsSinceStart() {
        return (int)((System.currentTimeMillis() - bootTime) / 1000L);
    }

    private static Collection<Metric> filterOutUnchangedMetrics(Collection<? extends Metric> collection) {
        HashSet<Metric> changed = new HashSet<Metric>();
        for (Metric metric : collection) {
            if (!metric.changedSinceLastReport()) continue;
            changed.add(metric);
        }
        if (changed.size() == 1 && ((Metric)changed.iterator().next()).getName().equals(SECONDS_SINCE_START_METRIC_NAME)) {
            changed.clear();
        }
        return changed;
    }

    private static boolean isUsageStatisticsReportingEnabled() {
        return PreferencesUtils.isUsageEnabled();
    }

    private static String getClientID() {
        if (clientID == null) {
            Metrics.loadClientIDFromDisk();
        }
        if (clientID == null) {
            clientID = "unknown-" + UUID.randomUUID().toString();
            Metrics.incrementCounter("usage_client_id_create_failure");
        }
        return clientID;
    }

    private static void loadClientIDFromDisk() {
        try {
            List lines;
            File clientIDFile;
            String rootLocationString = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            File settingsDirectory = new File(String.valueOf(rootLocationString) + DevCenterConstants.FILE_SEPARATOR + "settings");
            if (!settingsDirectory.exists()) {
                FileUtils.forceMkdir((File)settingsDirectory);
            }
            if (!(clientIDFile = new File(settingsDirectory + DevCenterConstants.FILE_SEPARATOR + "usageid")).exists()) {
                Metrics.createUsageIDFile(clientIDFile);
            }
            if ((lines = FileUtils.readLines((File)clientIDFile)).size() > 0) {
                clientID = ((String)lines.get(0)).trim();
            }
        }
        catch (Exception e) {
            DevCenterLogger.error(e.toString(), Metrics.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private static void createUsageIDFile(File clientIDFile) throws IOException {
        clientIDFile.createNewFile();
        FileUtils.writeStringToFile((File)clientIDFile, (String)UUID.randomUUID().toString());
        Metrics.incrementCounter("created_usage_id_file");
    }

    public static Integer incrementCounter(String counterName) {
        return Metrics.incrementCounter(counterName, 1);
    }

    public static Integer incrementCounter(String counterName, int incAmount) {
        Metric metric = metrics.get(counterName = counterName.toLowerCase().trim());
        if (metric == null) {
            metric = Metrics.createMetric(counterName, new Counter(counterName));
        }
        return metric.update(incAmount);
    }

    public static Integer setGaugeValue(String gaugeName, int newValue) {
        Metric metric = metrics.get(gaugeName);
        if (metric == null) {
            metric = Metrics.createMetric(gaugeName, new Gauge(gaugeName));
        }
        return metric.update(newValue);
    }

    public static Integer setMaxGaugeValue(String gaugeName, int newValue) {
        Metric metric = metrics.get(gaugeName);
        if (metric == null) {
            metric = Metrics.createMetric(gaugeName, new MaxGauge(gaugeName));
        }
        return metric.update(newValue);
    }

    private static synchronized Metric createMetric(String name, Metric newMetric) {
        Metric metric = metrics.get(name);
        if (metric == null) {
            metrics.put(name, newMetric);
        } else {
            Metrics.logAlreadyExistsError(name, metric);
        }
        return metric != null ? metric : newMetric;
    }

    private static void logAlreadyExistsError(String name, Metric metric) {
        DevCenterLogger.error(String.format("Cannot create metric with name: %s, as another metric with that name of type %s already exists", name, metric.getClass().getSimpleName()), Metrics.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
    }

    public static Metric getMetric(String metricName) {
        return metrics.get(metricName);
    }

    static void clear() {
        metrics.clear();
    }
}

