/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.metrics;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.metrics.Gauge;
import com.datastax.devcenter.common.metrics.MaxGauge;
import com.datastax.devcenter.common.metrics.Metric;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class MetricsReporter {
    private URL trustStoreURL;

    public boolean report(String usageClientID, Map<Metric, Integer> toReport) {
        boolean success = true;
        if (toReport != null && toReport.size() > 0) {
            String toPost = this.getUsageReportString(usageClientID, toReport);
            success = this.postUsageReport(toPost);
        }
        return success;
    }

    public Integer getSecondsSinceEpoch() {
        Long secondsSinceEpoch = System.currentTimeMillis() / 1000L;
        return secondsSinceEpoch.intValue();
    }

    private boolean postUsageReport(String toPost) {
        boolean success;
        block11: {
            success = false;
            CloseableHttpClient httpClient = null;
            try {
                try {
                    httpClient = HttpClientBuilder.create().setSslcontext(this.getSSLContext(this.trustStoreURL)).build();
                    URI uri = this.getStatisticsURI();
                    HttpPost post = new HttpPost(uri);
                    RequestConfig config = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
                    post.setConfig(config);
                    post.setEntity((HttpEntity)new StringEntity(toPost, ContentType.APPLICATION_JSON));
                    httpClient.execute((HttpUriRequest)post);
                    success = true;
                }
                catch (Exception ignore) {
                    DevCenterLogger.error(ignore.toString(), MetricsReporter.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
                    try {
                        httpClient.close();
                    }
                    catch (IOException e) {
                        DevCenterLogger.error(e.toString(), MetricsReporter.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    DevCenterLogger.error(e.toString(), MetricsReporter.class.getCanonicalName(), new /* invalid duplicate definition of identical inner class */.getClass().getEnclosingMethod().getName());
                }
                throw throwable;
            }
            try {
                httpClient.close();
            }
            catch (IOException e) {
                DevCenterLogger.error(e.toString(), MetricsReporter.class.getCanonicalName(), new /* invalid duplicate definition of identical inner class */.getClass().getEnclosingMethod().getName());
            }
        }
        return success;
    }

    private SSLContext getSSLContext(URL trustStoreURL) throws Exception {
        SSLContext ctx = SSLContext.getInstance("SSL");
        InputStream trustStoreIS = null;
        try {
            trustStoreIS = trustStoreURL.openStream();
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(trustStoreIS, "devcenter".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            ctx.init(null, tmf.getTrustManagers(), new SecureRandom());
        }
        finally {
            if (trustStoreIS != null) {
                trustStoreIS.close();
            }
        }
        return ctx;
    }

    private String getUsageReportString(String usageClientID, Map<Metric, Integer> toReport) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Metric> it = toReport.keySet().iterator();
        while (it.hasNext()) {
            Metric metric = it.next();
            Integer valueToReport = toReport.get(metric);
            if (metric.changedSinceLastReport()) {
                String metricReport = this.getReportForMetric(usageClientID, valueToReport, metric);
                builder.append(metricReport);
            }
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        String toPost = builder.toString();
        return toPost;
    }

    private String getReportForMetric(String usageClientID, Integer valueToReport, Metric metric) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"clientID\" : ");
        builder.append("\"");
        builder.append(usageClientID);
        builder.append("\"");
        builder.append(", \"name\" : ");
        builder.append("\"");
        builder.append(metric.getName());
        builder.append("\"");
        builder.append(", \"diffSinceLastReport\" : ");
        builder.append(valueToReport - metric.getLastReportedValue());
        if (metric instanceof Gauge) {
            builder.append(", \"max\" : ");
            builder.append(((Gauge)metric).maxValue());
            builder.append(", \"min\" : ");
            builder.append(((Gauge)metric).minValue());
        } else if (metric instanceof MaxGauge) {
            builder.append(", \"max\" : ");
            builder.append(valueToReport);
        }
        builder.append(", \"secondsSinceEpoch\" : ");
        builder.append(this.getSecondsSinceEpoch());
        builder.append("}");
        return builder.toString();
    }

    private URI getStatisticsURI() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("phonehome.datastax.com").setPort(9800).setPath("/usage/statistics").build();
    }

    public void setTrustStoreURL(URL trustStoreURL) {
        this.trustStoreURL = trustStoreURL;
    }
}

