/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.status;

import com.datastax.devcenter.common.DevCenterLogger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wb.swt.SWTResourceManager;

public class StatusCompositeProgressMonitor
extends Composite
implements IProgressMonitor {
    private final Text statusLineText;
    private final ProgressBar progressBar;
    private final Composite stackComposite;
    private final StackLayout stackLayout;
    private final Composite feedbackLink;

    public StatusCompositeProgressMonitor(Composite parentComposite, int style) {
        super(parentComposite, 1);
        this.setLayout((Layout)new FormLayout());
        this.statusLineText = new Text((Composite)this, 8);
        FormData statusLineTextFormData = new FormData();
        statusLineTextFormData.left = new FormAttachment(0, 0);
        this.statusLineText.setBackground(SWTResourceManager.getColor(25));
        this.statusLineText.setLayoutData((Object)statusLineTextFormData);
        this.stackComposite = new Composite((Composite)this, 0);
        FormData stackFormData = new FormData();
        stackFormData.left = new FormAttachment(100, -100);
        stackFormData.right = new FormAttachment(100);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayoutData((Object)stackFormData);
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.progressBar = this.createProgressBar(this.stackComposite);
        this.feedbackLink = this.createLink(this.stackComposite);
        this.stackLayout.topControl = this.feedbackLink;
        this.stackComposite.layout();
    }

    private ProgressBar createProgressBar(Composite parent) {
        return new ProgressBar(parent, 8388866);
    }

    private Composite createLink(Composite parent) {
        Composite alignComposite = new Composite(parent, 0);
        GridLayout alignLayout = new GridLayout();
        alignLayout.marginWidth = 0;
        alignLayout.marginHeight = 0;
        alignComposite.setLayout((Layout)alignLayout);
        GridData alignData = new GridData(131072, 4, true, true);
        Link link = new Link(alignComposite, 8);
        link.setText("<a href=\"feedback\">Feedback?</a>");
        link.setBackground(SWTResourceManager.getColor(25));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("feedback".equals(e.text)) {
                    String commandId = "com.datastax.devcenter.rcp.commands.SubmitFeedback";
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand(commandId, null);
                    }
                    catch (Exception ex) {
                        DevCenterLogger.error(ex, ex.toString(), "FeedbackDialog", new Object(){}.getClass().getEnclosingMethod().getName());
                    }
                }
            }
        });
        link.setLayoutData((Object)alignData);
        return alignComposite;
    }

    protected void checkSubclass() {
    }

    public void setMessage(final String message) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                StatusCompositeProgressMonitor.this.statusLineText.setText(message);
                StatusCompositeProgressMonitor.this.statusLineText.pack();
                StatusCompositeProgressMonitor.this.statusLineText.update();
                StatusCompositeProgressMonitor.this.update();
            }
        });
    }

    public void activateProgressBar() {
        this.stackLayout.topControl = this.progressBar;
        this.stackComposite.layout();
    }

    public void deActivateProgressBar() {
        this.stackLayout.topControl = this.feedbackLink;
        this.stackComposite.layout();
    }

    public void beginTask(String name, int totalWork) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                StatusCompositeProgressMonitor.this.activateProgressBar();
                StatusCompositeProgressMonitor.this.setMessage("working");
            }
        });
    }

    public void done() {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                StatusCompositeProgressMonitor.this.deActivateProgressBar();
                StatusCompositeProgressMonitor.this.setMessage("");
            }
        });
    }

    public void displayMessageInStatusLine(String message) {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
    }
}

