/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AsyncJobHelper {
    private final ExceptionTranslator[] translators;

    public AsyncJobHelper(ExceptionTranslator ... translators) {
        this.translators = translators;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runCancellable(Callable<Void> task, IProgressMonitor monitor) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        FutureTask<Void> future = new FutureTask<Void>(task);
        try {
            executor.execute(future);
            while (true) {
                if (future.isDone()) {
                    future.get();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                if (monitor.isCanceled()) {
                    future.cancel(true);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Thread.sleep(100L);
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IStatus iStatus = this.createErrorStatus(e);
            return iStatus;
        }
        catch (ExecutionException e) {
            IStatus iStatus = this.createErrorStatus(e.getCause());
            return iStatus;
        }
        catch (Exception e) {
            IStatus iStatus = this.createErrorStatus(e);
            return iStatus;
        }
        finally {
            executor.shutdownNow();
            monitor.done();
        }
    }

    public IStatus createErrorStatus(Throwable throwable) {
        if (throwable != null) {
            ExceptionTranslator[] exceptionTranslatorArray = this.translators;
            int n = this.translators.length;
            int n2 = 0;
            while (n2 < n) {
                ExceptionTranslator translator = exceptionTranslatorArray[n2];
                if (translator.canTranslate(throwable)) {
                    return translator.translate(throwable);
                }
                ++n2;
            }
        }
        String message = throwable == null ? "" : throwable.getLocalizedMessage();
        return new Status(4, "com.datastax.devcenter.common", message, throwable);
    }

    public static interface ExceptionTranslator {
        public boolean canTranslate(Throwable var1);

        public IStatus translate(Throwable var1);
    }

    public static class SimpleExceptionTranslator
    implements ExceptionTranslator {
        private final Class<? extends Throwable> throwableClass;
        private final String message;

        public SimpleExceptionTranslator(Class<? extends Throwable> throwableClass, String message) {
            this.throwableClass = throwableClass;
            this.message = message;
        }

        @Override
        public boolean canTranslate(Throwable throwable) {
            return this.throwableClass.isAssignableFrom(throwable.getClass());
        }

        @Override
        public IStatus translate(Throwable throwable) {
            return new Status(4, "com.datastax.devcenter.common", this.message, throwable);
        }
    }
}

