/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.expression.DefaultResolver;

public class BeanPropertyHelper {
    public static <T> T nullSafeGetProperty(Object bean, String property) {
        try {
            return (T)PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (NestedNullException nestedNullException) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void nullSafeSetProperty(Object bean, String property, Object value) {
        try {
            DefaultResolver resolver = new DefaultResolver();
            while (resolver.hasNested(property)) {
                String name = resolver.next(property);
                Object temp = PropertyUtils.getSimpleProperty((Object)bean, (String)name);
                if (temp == null) {
                    Class<?> clazz = PropertyUtils.getPropertyDescriptor((Object)bean, (String)name).getPropertyType();
                    temp = BeanPropertyHelper.newInstance(clazz);
                    PropertyUtils.setSimpleProperty((Object)bean, (String)name, (Object)temp);
                }
                bean = temp;
                property = resolver.remove(property);
            }
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s does not have a default no-arg constructor or constructor is not accessible", clazz), e);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        DefaultResolver resolver = new DefaultResolver();
        while (resolver.hasNested(property)) {
            String name = resolver.next(property);
            clazz = BeanPropertyHelper.getSimplePropertyDescriptor(clazz, name).getPropertyType();
            property = resolver.remove(property);
        }
        return BeanPropertyHelper.getSimplePropertyDescriptor(clazz, property);
    }

    public static Field getPropertyField(Class<?> clazz, String property) {
        DefaultResolver resolver = new DefaultResolver();
        while (resolver.hasNested(property)) {
            String name = resolver.next(property);
            clazz = BeanPropertyHelper.getSimplePropertyDescriptor(clazz, name).getPropertyType();
            property = resolver.remove(property);
        }
        try {
            return clazz.getDeclaredField(property);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist or is not accessible in %s", property, clazz), e);
        }
    }

    private static PropertyDescriptor getSimplePropertyDescriptor(Class<?> clazz, String name) {
        PropertyDescriptor[] pds;
        PropertyDescriptor[] propertyDescriptorArray = pds = PropertyUtils.getPropertyDescriptors(clazz);
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(name)) {
                return pd;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.format("Property '%s' does not exist in %s", name, clazz));
    }
}

