/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class ConversionHelper {
    static {
        ConvertUtils.register((Converter)new BooleanConverter(), Boolean.TYPE);
        ConvertUtils.register((Converter)new BooleanConverter(), Boolean.class);
        ConvertUtils.register((Converter)new ByteConverter(), Byte.TYPE);
        ConvertUtils.register((Converter)new ByteConverter(), Byte.class);
        ConvertUtils.register((Converter)new CharacterConverter(), Character.TYPE);
        ConvertUtils.register((Converter)new CharacterConverter(), Character.class);
        ConvertUtils.register((Converter)new ShortConverter(), Short.TYPE);
        ConvertUtils.register((Converter)new ShortConverter(), Short.class);
        ConvertUtils.register((Converter)new IntegerConverter(), Integer.TYPE);
        ConvertUtils.register((Converter)new IntegerConverter(), Integer.class);
        ConvertUtils.register((Converter)new LongConverter(), Long.TYPE);
        ConvertUtils.register((Converter)new LongConverter(), Long.class);
        ConvertUtils.register((Converter)new FloatConverter(), Float.TYPE);
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        ConvertUtils.register((Converter)new DoubleConverter(), Double.TYPE);
        ConvertUtils.register((Converter)new DoubleConverter(), Double.class);
    }

    public static <T> T convert(Object from, Class<T> to) throws ConversionException {
        if ((from == null || from.toString().isEmpty()) && !to.isPrimitive()) {
            return null;
        }
        if (Enum.class.isAssignableFrom(to) && ConvertUtils.lookup(to) == null) {
            ConvertUtils.register((Converter)new ToEnumConverter(), to);
        }
        return (T)ConvertUtils.convert((Object)from, to);
    }

    public static void register(Converter converter, Class<?> clazz) {
        ConvertUtils.register((Converter)converter, clazz);
    }

    public static final class ToEnumConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null || value.toString().isEmpty()) {
                return null;
            }
            Method lookup = null;
            try {
                lookup = type.getDeclaredMethod("lookup", String.class);
            }
            catch (Exception exception) {}
            if (lookup != null) {
                try {
                    return lookup.invoke(null, value.toString());
                }
                catch (Exception e) {
                    InvocationTargetException ite;
                    if (e instanceof InvocationTargetException && (ite = (InvocationTargetException)e).getTargetException() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)ite.getTargetException();
                    }
                    throw new IllegalStateException(e);
                }
            }
            return Enum.valueOf(type, value.toString());
        }
    }
}

