/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.interfaces.DevCenterConstants;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DevCenterVersionUtils {
    public static VersionNumber getRuntimeVersion() {
        IProduct product = Platform.getProduct();
        Bundle bundle = product.getDefiningBundle();
        Version v = bundle.getVersion();
        VersionNumber runtimeVersion = VersionNumber.parse((String)String.format("%s.%s.%s", v.getMajor(), v.getMinor(), v.getMicro()));
        return runtimeVersion;
    }

    public static VersionNumber getInstalledVersion() {
        File versionFile = DevCenterVersionUtils.getVersionFile();
        try {
            String version = Files.readFirstLine((File)versionFile, (Charset)Charsets.UTF_8);
            return VersionNumber.parse((String)version);
        }
        catch (Exception e) {
            DevCenterLogger.error(e.toString(), DevCenterVersionUtils.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
            return null;
        }
    }

    private static File getVersionFile() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String settingsPath = String.valueOf(root.getLocation().toOSString()) + DevCenterConstants.FILE_SEPARATOR + "settings";
        String versionPath = String.valueOf(settingsPath) + DevCenterConstants.FILE_SEPARATOR + "version";
        File versionFile = new File(versionPath);
        return versionFile;
    }

    public static void updateInstalledVersion() {
        File versionFile = DevCenterVersionUtils.getVersionFile();
        try {
            if (!versionFile.getParentFile().exists()) {
                versionFile.getParentFile().mkdirs();
            }
            Files.write((CharSequence)DevCenterVersionUtils.getRuntimeVersion().toString(), (File)versionFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            DevCenterLogger.error(e.toString(), DevCenterVersionUtils.class.getCanonicalName(), new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    public static boolean isRuntimeVersionNewer() {
        VersionNumber installedVersion = DevCenterVersionUtils.getInstalledVersion();
        if (installedVersion == null) {
            return true;
        }
        return DevCenterVersionUtils.getRuntimeVersion().compareTo(installedVersion) > 0;
    }

    public static boolean isFirstStart() {
        return !DevCenterVersionUtils.getVersionFile().exists();
    }
}

