/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.Bytes;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ExportTableUtils {
    private static final DateFormat CSV_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ssZ");
    private static final String CSV_DELIMITER = ",";
    private static final String CSV_DOUBLE_QUOTE = "\"";
    private static final String CSV_SINGLE_QUOTE = "'";

    public static String escapeQuotes(String str) {
        return str.replaceAll(CSV_DOUBLE_QUOTE, "\\\\\"");
    }

    public static String wrap(String inputStr, String wrapStr) {
        return String.valueOf(wrapStr) + inputStr + wrapStr;
    }

    public static Object quoteIfString(Object object) {
        if (object instanceof String) {
            return ExportTableUtils.wrap(ExportTableUtils.escapeQuotes((String)object), CSV_SINGLE_QUOTE);
        }
        return object;
    }

    public static String quoteMixedCase(String name) {
        if (!name.toLowerCase().equals(name)) {
            return CSV_DOUBLE_QUOTE + name + CSV_DOUBLE_QUOTE;
        }
        return name;
    }

    public static String columnToString(Object colObject) {
        if (colObject instanceof String) {
            return ExportTableUtils.escapeQuotes((String)colObject);
        }
        if (colObject instanceof InetAddress) {
            return ((InetAddress)colObject).getHostAddress();
        }
        if (colObject instanceof Date) {
            return CSV_DATEFORMAT.format((Date)colObject);
        }
        if (colObject instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)colObject;
            return Bytes.toHexString((ByteBuffer)bb);
        }
        if (colObject instanceof Collection) {
            Collection myValueList = (Collection)colObject;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object object : myValueList) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(ExportTableUtils.quoteIfString(object));
                first = false;
            }
            if (colObject instanceof Set) {
                return ExportTableUtils.wrap("{" + sb.toString() + "}", CSV_DOUBLE_QUOTE);
            }
            return ExportTableUtils.wrap("[" + sb.toString() + "]", CSV_DOUBLE_QUOTE);
        }
        if (colObject instanceof Map) {
            Map map = (Map)colObject;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(ExportTableUtils.quoteIfString(entry.getKey())).append(": ").append(ExportTableUtils.quoteIfString(entry.getValue()));
                first = false;
            }
            return ExportTableUtils.wrap("{" + sb.toString() + "}", CSV_DOUBLE_QUOTE);
        }
        if (colObject instanceof UDTValue) {
            return ExportTableUtils.wrap(String.valueOf(colObject), CSV_DOUBLE_QUOTE);
        }
        if (colObject instanceof TupleValue) {
            return ExportTableUtils.wrap(String.valueOf(colObject), CSV_DOUBLE_QUOTE);
        }
        return String.valueOf(colObject);
    }

    public static String selectionAsCSV(Table table, boolean allRows) {
        if (allRows) {
            Metrics.incrementCounter("copy_as_csv_count");
        } else {
            Metrics.incrementCounter("copy_all_as_csv_count");
        }
        TableItem[] selectedItems = allRows ? table.getItems() : table.getSelection();
        int columnCount = table.getColumnCount();
        StringBuilder data = new StringBuilder();
        TableItem[] tableItemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object dataObject = tableItem.getData();
            Object[] objectArray = (Object[])dataObject;
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                Object cellValue;
                if (columnIndex > 0) {
                    data.append(CSV_DELIMITER);
                }
                if ((cellValue = objectArray[columnIndex]) instanceof ICellWrapper) {
                    cellValue = ((ICellWrapper)cellValue).getCell();
                }
                data.append(ExportTableUtils.columnToString(cellValue));
                ++columnIndex;
            }
            data.append("\n");
            ++n2;
        }
        return data.toString();
    }

    public static String selectionAsInsert(Table table, ColumnDefinitions columnDefinitions, boolean allRows) {
        if (allRows) {
            Metrics.incrementCounter("copy_as_insert_count");
        } else {
            Metrics.incrementCounter("copy_all_as_insert_count");
        }
        TableItem[] selectedItems = allRows ? table.getItems() : table.getSelection();
        StringBuilder data = new StringBuilder();
        int columnCount = table.getColumnCount();
        String tableName = columnDefinitions.getTable(0);
        TableItem[] tableItemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object[] rowValues = (Object[])tableItem.getData();
            Insert insert = QueryBuilder.insertInto((String)ExportTableUtils.quoteMixedCase(tableName));
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                Object rowValue = rowValues[columnIndex];
                if (rowValue instanceof ICellWrapper) {
                    rowValue = ((ICellWrapper)rowValue).getCell();
                }
                insert.value(ExportTableUtils.quoteMixedCase(columnDefinitions.getName(columnIndex)), rowValue);
                ++columnIndex;
            }
            data.append(insert.toString()).append("\n");
            ++n2;
        }
        return data.toString();
    }

    public static void copyToClipboard(Display display, String str) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{str}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    public static interface ICellWrapper {
        public Object getCell();
    }
}

