/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.common.utils;

import com.datastax.driver.core.VersionNumber;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesUtils {
    public static String AUTOMATIC_UPDATE_PREF = "automatic-update";
    public static String ANONYMOUS_USAGE_PREF = "anonymous-usage";
    public static String SKIP_VERSION_PREF = "skip-version";
    public static String DEVCENTER_PREF_NODE = "com.datastax.devcenter.preferences";

    public static Boolean isUpdateEnabled() {
        return PreferencesUtils.getBooleanProperty(AUTOMATIC_UPDATE_PREF);
    }

    public static Boolean isUsageEnabled() {
        return PreferencesUtils.getBooleanProperty(ANONYMOUS_USAGE_PREF);
    }

    public static boolean getBooleanProperty(String key) {
        boolean property = true;
        IEclipsePreferences preferences = PreferencesUtils.getPreferences();
        property = preferences.get(key, null) != null ? preferences.getBoolean(key, true) : false;
        return property;
    }

    public static void setUpdateEnabled(boolean enabled) throws BackingStoreException {
        IEclipsePreferences preferences = PreferencesUtils.getPreferences();
        preferences.putBoolean(AUTOMATIC_UPDATE_PREF, enabled);
        preferences.flush();
    }

    public static void setUsageEnabled(boolean enabled) throws BackingStoreException {
        IEclipsePreferences preferences = PreferencesUtils.getPreferences();
        preferences.putBoolean(ANONYMOUS_USAGE_PREF, enabled);
        preferences.flush();
    }

    public static void skipVersion(VersionNumber version) throws BackingStoreException {
        IEclipsePreferences preferences = PreferencesUtils.getPreferences();
        preferences.put(SKIP_VERSION_PREF, version.toString());
        preferences.flush();
    }

    public static VersionNumber getSkipVersion() {
        IEclipsePreferences preferences = PreferencesUtils.getPreferences();
        return VersionNumber.parse((String)preferences.get(SKIP_VERSION_PREF, null));
    }

    private static IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(DEVCENTER_PREF_NODE);
        return preferences;
    }
}

