/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.managers;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.interfaces.DevCenterConstants;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.views.CqlScriptsViewPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class CqlFilesScriptsManager
implements IInputValidator {
    private static final String CQL_FILE_EXTENSION = ".cql";
    private static int scratchPadCounter = 1;
    private IProject cqlProject;
    private IFolder scratchPadIFolder;
    private IFolder scriptsIFolder;
    private EventAdmin connectionsEventAdmin;

    public void initialize() {
        try {
            File cqlScriptsDirectory;
            File cqlScratchPadsDirectory;
            File cqlProjectDirectory;
            IWorkspaceRoot cqlWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.cqlProject = cqlWorkspaceRoot.getProject("DevCenter");
            if (!this.cqlProject.exists()) {
                this.cqlProject.create(null);
            }
            this.cqlProject.open(null);
            if (!this.cqlProject.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                IProjectDescription description = this.cqlProject.getDescription();
                description.setNatureIds(new String[]{"org.eclipse.xtext.ui.shared.xtextNature"});
                this.cqlProject.setDescription(description, null);
            }
            if (!(cqlProjectDirectory = new File(DevCenterConstants.CQL_PROJECT_DIRECTORY)).exists()) {
                FileUtils.forceMkdir((File)cqlProjectDirectory);
            }
            this.scratchPadIFolder = this.cqlProject.getFolder(".default");
            if (!this.scratchPadIFolder.exists()) {
                this.scratchPadIFolder.create(0, true, null);
            }
            if (!(cqlScratchPadsDirectory = new File(String.valueOf(DevCenterConstants.CQL_PROJECT_DIRECTORY) + DevCenterConstants.FILE_SEPARATOR + ".default")).exists()) {
                FileUtils.forceMkdir((File)cqlScratchPadsDirectory);
            }
            this.scriptsIFolder = this.cqlProject.getFolder("CQLScripts");
            if (!this.scriptsIFolder.exists()) {
                this.scriptsIFolder.create(0, true, null);
            }
            if (!(cqlScriptsDirectory = new File(String.valueOf(DevCenterConstants.CQL_PROJECT_DIRECTORY) + DevCenterConstants.FILE_SEPARATOR + "CQLScripts")).exists()) {
                FileUtils.forceMkdir((File)cqlScriptsDirectory);
            }
            BundleContext cqlBundleContext = CqlActivator.getCqlBundleContext();
            ServiceReference connectionsEventAdminServiceReference = cqlBundleContext.getServiceReference(EventAdmin.class);
            this.connectionsEventAdmin = (EventAdmin)cqlBundleContext.getService(connectionsEventAdminServiceReference);
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    public IFile createNewCqlScratchPad() throws CoreException {
        String scratchPadFileName = "default_" + scratchPadCounter + CQL_FILE_EXTENSION;
        ++scratchPadCounter;
        IFile scratchPadIFile = this.scratchPadIFolder.getFile(scratchPadFileName);
        if (scratchPadIFile.exists()) {
            String osFileName = scratchPadIFile.getLocation().toOSString();
            File osFile = new File(osFileName);
            if (osFile.exists()) {
                osFile.delete();
            }
            scratchPadIFile.delete(true, null);
        }
        byte[] bytes = "".getBytes();
        ByteArrayInputStream source = new ByteArrayInputStream(bytes);
        scratchPadIFile.create((InputStream)source, 0, null);
        HashMap<String, IFile> scriptsEventProperties = new HashMap<String, IFile>();
        scriptsEventProperties.put("scratch_pad_added", scratchPadIFile);
        Event event = new Event("scratch_pad_added", scriptsEventProperties);
        this.connectionsEventAdmin.sendEvent(event);
        return scratchPadIFile;
    }

    public IFolder getScriptsIFolder() {
        return this.scriptsIFolder;
    }

    public boolean cqlFileExists(String fileName) {
        return this.scriptsIFolder.getFile(fileName).exists();
    }

    public String isValid(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "File name cannot be empty.";
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(fileName, 1);
        if (!result.isOK()) {
            return result.getMessage();
        }
        if (this.cqlFileExists(fileName = this.sanitizeCqlFileName(fileName))) {
            return "File name already exists.";
        }
        return null;
    }

    public void notifyScriptsFolderChanged() {
        IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.datastax.devcenter.cql.ui.views.CqlScriptsViewPart");
        CqlScriptsViewPart cqlScriptsViewPart = (CqlScriptsViewPart)iViewPart;
        cqlScriptsViewPart.notifyScriptsFolderChanged();
    }

    public IFile saveDocumentToFile(String fileName, IDocument document) throws Exception {
        IFile cqlScriptIFile = this.scriptsIFolder.getFile(this.sanitizeCqlFileName(fileName));
        String cqlScriptString = document.get();
        byte[] bytes = cqlScriptString.getBytes("UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        cqlScriptIFile.create((InputStream)is, 0, null);
        return cqlScriptIFile;
    }

    private String sanitizeCqlFileName(String fileName) {
        if (!StringUtils.endsWith((String)fileName, (String)CQL_FILE_EXTENSION)) {
            fileName = String.valueOf(fileName) + CQL_FILE_EXTENSION;
        }
        return fileName;
    }
}

