/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui;

import com.datastax.devcenter.cql.ui.JsonHighlightingConfiguration;
import javax.inject.Inject;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class CqlHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    @Inject
    private JsonHighlightingConfiguration jsonHighlightingConfiguration;
    public static final String DEFAULT = "Default";
    public static final String COMMENT = "Comment";
    public static final String KEYWORD = "Keyword";
    public static final String CONSTANT = "Constant";
    public static final String STRING = "String";
    public static final String SINGLE_QUOTE = "Single quote";
    public static final String KEYSPACENAME = "Keyspace Name";
    public static final String TABLENAME = "Table Name";
    public static final String COLUMNNAME = "Column Name";
    public static final String INDEXNAME = "Index Name";
    public static final String TRIGGERNAME = "Trigger Name";
    public static final String USERNAME = "User Name";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        super.configure(acceptor);
        this.addType(acceptor, KEYSPACENAME, 38, 139, 210, 1);
        this.addType(acceptor, TABLENAME, 38, 139, 210, 1);
        this.addType(acceptor, COLUMNNAME, 108, 113, 196, 1);
        this.addType(acceptor, INDEXNAME, 38, 139, 210, 1);
        this.addType(acceptor, TRIGGERNAME, 38, 139, 210, 1);
        this.addType(acceptor, USERNAME, 38, 139, 210, 1);
        this.addType(acceptor, COMMENT, 88, 110, 117, 2);
        this.addType(acceptor, KEYWORD, 165, 121, 0, 0);
        this.addType(acceptor, STRING, 42, 161, 152, 0);
        this.addType(acceptor, CONSTANT, 133, 153, 0, 0);
        this.jsonHighlightingConfiguration.customConfigure(acceptor);
    }

    public void addType(IHighlightingConfigurationAcceptor acceptor, String s, int r, int g, int b, int style) {
        TextStyle textStyle = new TextStyle();
        textStyle.setBackgroundColor(new RGB(255, 255, 255));
        textStyle.setColor(new RGB(r, g, b));
        textStyle.setStyle(style);
        acceptor.acceptDefaultHighlighting(s, s, textStyle);
    }
}

