/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TriggerEntity;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UserEntity;
import com.datastax.devcenter.cql.ui.JsonSemanticHighlightingCalculator;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;

public class CqlSemanticHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    @Inject
    private JsonSemanticHighlightingCalculator jsonSemanticHighlightingCalculator;
    private static final String KEYSPACE_NAME_IDENT = "KeyspaceNameIdent";
    private static final String TABLE_NAME_IDENT = "TableNameIdent";
    private static final String COLUMN_NAME_IDENT = "ColumnNameIdent";
    private static final String TYPE_NAME_IDENT = "TypeNameIdent";
    private static final String FIELD_NAME_IDENT = "FieldNameIdent";
    private static final String INDEX_NAME_IDENT = "IndexNameIdent";
    private static final String TRIGGER_NAME_IDENT = "TriggerNameIdent";
    private static final String USER_NAME_IDENT = "UserNameIdent";
    private static final String ALIAS_NAME_IDENT = "AliasNameIdent";

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        super.provideHighlightingFor(resource, acceptor);
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            EObject semanticElement = node.getSemanticElement();
            boolean matched = this.matchCrossReference(acceptor, node);
            if (!matched && !(matched = this.matchSemanticElement(acceptor, node, semanticElement)) && !(matched = this.matchAlias(acceptor, node, semanticElement)) && !(matched = this.jsonSemanticHighlightingCalculator.matchJsonSemanticElement(acceptor, node, semanticElement))) continue;
        }
    }

    private boolean matchAlias(IHighlightedPositionAcceptor acceptor, INode node, EObject semanticElement) {
        AbstractRule rule;
        boolean matched = false;
        if (semanticElement instanceof Selector && node.getGrammarElement() instanceof RuleCall && ALIAS_NAME_IDENT.equals((rule = ((RuleCall)node.getGrammarElement()).getRule()).getName())) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Column Name"});
            matched = true;
        }
        return matched;
    }

    private boolean matchSemanticElement(IHighlightedPositionAcceptor acceptor, INode node, EObject semanticElement) {
        boolean matched = false;
        if (semanticElement instanceof ColumnEntity || semanticElement instanceof FieldEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Column Name"});
            matched = true;
        }
        if (semanticElement instanceof TableEntity || semanticElement instanceof TypeEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Table Name"});
            matched = true;
        }
        if (semanticElement instanceof KeyspaceEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Keyspace Name"});
            matched = true;
        }
        if (semanticElement instanceof IndexEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Index Name"});
            matched = true;
        }
        if (semanticElement instanceof TriggerEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Trigger Name"});
            matched = true;
        }
        if (semanticElement instanceof UserEntity) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"User Name"});
            matched = true;
        }
        return matched;
    }

    private boolean matchCrossReference(IHighlightedPositionAcceptor acceptor, INode node) {
        boolean matched = false;
        if (node.getGrammarElement() instanceof CrossReference) {
            CrossReference cr = (CrossReference)node.getGrammarElement();
            String terminalRuleCallName = ((RuleCall)cr.getTerminal()).getRule().getName();
            if (KEYSPACE_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Keyspace Name"});
                matched = true;
            }
            if (TABLE_NAME_IDENT.equals(terminalRuleCallName) || TYPE_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Table Name"});
                matched = true;
            }
            if (COLUMN_NAME_IDENT.equals(terminalRuleCallName) || FIELD_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Column Name"});
                matched = true;
            }
            if (INDEX_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Index Name"});
                matched = true;
            }
            if (TRIGGER_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Trigger Name"});
                matched = true;
            }
            if (USER_NAME_IDENT.equals(terminalRuleCallName)) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"User Name"});
                matched = true;
            }
        }
        return matched;
    }
}

