/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui;

import com.datastax.devcenter.cql.cql.EmbeddedJSONString;
import com.datastax.devcenter.json.json.JsonArrayValue;
import com.datastax.devcenter.json.json.JsonKeyValue;
import com.datastax.devcenter.json.json.JsonObject;
import com.datastax.devcenter.json.json.JsonObjectValue;
import com.datastax.devcenter.json.json.JsonValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;

public class JsonSemanticHighlightingCalculator
extends DefaultSemanticHighlightingCalculator {
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        super.provideHighlightingFor(resource, acceptor);
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            EObject semanticElement;
            boolean matched = this.matchJsonSemanticElement(acceptor, node, semanticElement = node.getSemanticElement());
            if (!matched) continue;
        }
    }

    public boolean matchJsonSemanticElement(IHighlightedPositionAcceptor acceptor, INode node, EObject semanticElement) {
        boolean matched = false;
        if (semanticElement instanceof JsonKeyValue || semanticElement instanceof JsonKeyValue) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Json Field name"});
            matched = true;
        } else if (semanticElement instanceof JsonValue && !(semanticElement instanceof JsonObjectValue) && !(semanticElement instanceof JsonArrayValue)) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Json Field value"});
            matched = true;
        } else if (semanticElement instanceof JsonObject || semanticElement instanceof EmbeddedJSONString) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Json Default"});
            matched = true;
        }
        return matched;
    }
}

