/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public class UiConstant {
    private static Map<ImageType, Image> images = new HashMap<ImageType, Image>();

    private static Image getImageFromResource(String iconFilePath) {
        Bundle bundle = Platform.getBundle((String)"com.datastax.devcenter.cql.ui");
        URL url = BundleUtility.find((Bundle)bundle, (String)iconFilePath);
        Image image = ImageDescriptor.createFromURL((URL)url).createImage();
        return image;
    }

    public static enum ImageType {
        COLUMN("icons/column.gif", "column", 100, ""),
        FIELD("icons/column.gif", "type field", 100, ""),
        UDF("icons/udf.gif", "user defined function", 91, ""),
        TABLE("icons/table.gif", "table", 90, ""),
        TYPE("icons/table.gif", "user type", 90, ""),
        KEYSPACE("icons/keyspace.gif", "keyspace", 80, ""),
        TEMPLATE("icons/template.gif", "template", 80, ""),
        INDEX("icons/index.gif", "index", 5, ""),
        TRIGGER("icons/trigger.gif", "trigger", 4, ""),
        USERNAME("icons/username.png", "username", 3, ""),
        NATIVETYPE("icons/nativetype.gif", "native type", 2, ""),
        KEYWORD("icons/keyword.gif", "keyword", 1, ""),
        CONNECTION("icons/connection.jpg", "connection", 0, ""),
        PUNCTUATION("icons/punctuation.png", "punctuation", 0, "");

        private final String filePath;
        private final String prefix;
        private final String name;
        private final int priority;

        private ImageType(String filePath, String name, int priority, String prefix) {
            this.filePath = filePath;
            this.name = name;
            this.priority = priority;
            this.prefix = prefix;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getPriority() {
            return this.priority;
        }

        public Image getImage() {
            Image image = (Image)images.get((Object)this);
            if (image == null) {
                image = UiConstant.getImageFromResource(this.getFilePath());
                images.put(this, image);
            }
            return image;
        }
    }
}

