/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.contentassist;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.AlterKeyspaceStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.CollectionType;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.ColumnOperation;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateAggregateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.DataResource;
import com.datastax.devcenter.cql.cql.DeleteOp;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.DropKeyspaceStatement;
import com.datastax.devcenter.cql.cql.EmbeddedJSONString;
import com.datastax.devcenter.cql.cql.FunctionResource;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.JSONInsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.Resource;
import com.datastax.devcenter.cql.cql.RoleResource;
import com.datastax.devcenter.cql.cql.RulesWithColumnRef;
import com.datastax.devcenter.cql.cql.RulesWithResource;
import com.datastax.devcenter.cql.cql.RulesWithTypeRef;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorFunction;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.UseStatement;
import com.datastax.devcenter.cql.cql.impl.ColumnDefImpl;
import com.datastax.devcenter.cql.ui.UiConstant;
import com.datastax.devcenter.cql.ui.contentassist.AbstractCqlProposalProvider;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Permission;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class CqlProposalProvider
extends AbstractCqlProposalProvider {
    @Inject
    private CqlContextProvider cqlContextProvider;
    @Inject
    private ISerializer serializer;

    @Override
    public void completePrimaryKeyDefinition_Columns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completePrimaryKeyProposal(model, assignment, context, acceptor);
    }

    @Override
    public void completePrimaryKeyDefinition_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completePrimaryKeyProposal(model, assignment, context, acceptor);
    }

    private void completePrimaryKeyProposal(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CreateTableStatement stmt = (CreateTableStatement)ModelUtil.getAncestorOfType((EObject)model, CreateTableStatement.class);
        if (stmt != null) {
            ColumnDef primaryKeyColumnDef = this.getPrimaryKeyColumnDef(stmt);
            for (ColumnDef c : stmt.getColumnDefinitions()) {
                ColumnEntity column = c.getColumn();
                if (c.isPrimaryKey() || column == null || this.isColumnInPrimaryKey(column, primaryKeyColumnDef)) continue;
                this.proposeName(column.getName(), "", "", column.getName(), "", " " + this.getType(c.getType()), context, acceptor, UiConstant.ImageType.COLUMN);
            }
        }
    }

    private String getType(Type colType) {
        return this.serializer.serialize((EObject)colType);
    }

    private ColumnDef getPrimaryKeyColumnDef(CreateTableStatement stmt) {
        for (ColumnDef colDef : stmt.getColumnDefinitions()) {
            if (!colDef.isPrimaryKey() || colDef.getColumn() != null) continue;
            return colDef;
        }
        return null;
    }

    private boolean isColumnInPrimaryKey(ColumnEntity columnEntity, ColumnDef primaryKeyColumnDef) {
        for (PrimaryKeyDefinition pkColDef : primaryKeyColumnDef.getPrimaryKeyDefinitions()) {
            if (pkColDef.getColumn() != null && pkColDef.getColumn().getName().equals(columnEntity.getName())) {
                return true;
            }
            if (pkColDef.getColumns() == null) continue;
            for (ColumnEntity partitionkey : pkColDef.getColumns()) {
                if (!partitionkey.getName().equals(columnEntity.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void completeColumnDef_PrimaryKey(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CreateTableStatement stmt = (CreateTableStatement)ModelUtil.getAncestorOfType((EObject)model, CreateTableStatement.class);
        if (stmt.getColumnDefinitions() == null) {
            return;
        }
        boolean isPrimaryKeyDefined = false;
        for (ColumnDef tableColumn : stmt.getColumnDefinitions()) {
            if (tableColumn == null || !tableColumn.isPrimaryKey()) continue;
            isPrimaryKeyDefined = true;
            break;
        }
        if (!isPrimaryKeyDefined) {
            this.proposeText("PRIMARY KEY", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_PermissionOrAll(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Set<Object> permissionProposals = Sets.newHashSet((Iterable)Permission.ALL);
        RulesWithResource stmt = (RulesWithResource)ModelUtil.getAncestorOfType((EObject)model, RulesWithResource.class);
        if (stmt != null && stmt.getResource() != null) {
            permissionProposals = this.getResourceSpecificPermissions(stmt.getResource());
        }
        this.proposeText("ALL PERMISSIONS", context, acceptor, UiConstant.ImageType.KEYWORD);
        for (Permission permission : permissionProposals) {
            this.proposeText(permission.name().toUpperCase(), context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    private Set<Permission> getResourceSpecificPermissions(Resource resource) {
        RoleResource roleResource;
        FunctionResource functionResource;
        DataResource dataResource;
        Set resourcePermissions = Sets.newHashSet((Iterable)Permission.ALL);
        resourcePermissions = resource.getDataResource() != null ? ((dataResource = resource.getDataResource()).isAll() || dataResource.isKeyspaceResource() ? Permission.KEYSPACE_LEVEL_PERMISSIONS : Permission.TABLE_LEVEL_PERMISSIONS) : (resource.getFunctionResource() != null ? ((functionResource = resource.getFunctionResource()).isAll() || functionResource.isAllInKeyspace() ? Permission.MULTIPLE_FUNCTION_PERMISSIONS : Permission.SINGLE_FUNCTION_PERMISSIONS) : ((roleResource = resource.getRoleResource()).isAll() ? Permission.MULTIPLE_ROLE_PERMISSIONS : Permission.SINGLE_ROLE_PERMISSIONS));
        return resourcePermissions;
    }

    @Override
    public void completeAlterUserStatement_User(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropUserStatement_User(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeGrantStatement_UserOrRole(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeGrantStatement_Grantee(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRevokeStatement_UserOrRole(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRevokeStatement_Revokee(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeListPermissionsStatement_UserOrRole(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithUserRef_User(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeUserEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithUserOrRoleRef_UserOrRole(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeUserOrRoleEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRoleResource_UserOrRole(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUsers(model, assignment, context, acceptor);
    }

    private void proposeUsers(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            Schema schema = cqlContext.getSchema(index);
            this.proposeNames(schema.getUsers(), context, acceptor, UiConstant.ImageType.USERNAME);
        }
    }

    @Override
    public void completeCreateIndexStatement_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeName("", "(use default name)", context, acceptor, UiConstant.ImageType.INDEX);
    }

    @Override
    public void completeDropIndexStatement_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeIndexes(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithIndexRef_Index(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeIndexes(model, assignment, context, acceptor);
    }

    @Override
    public void completeIndexEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeIndexes(model, assignment, context, acceptor);
    }

    private void proposeIndexes(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int stmtIndex = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && stmtIndex >= 0) {
            Schema schema = cqlContext.getSchema(stmtIndex);
            for (Index index : schema.getIndices()) {
                String indexName = index.getName();
                if (cqlContext.getCassandraVersion().compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0) {
                    indexName = ModelUtil.escapeName((String)indexName);
                }
                this.proposeName(indexName, indexName, context, acceptor, UiConstant.ImageType.INDEX);
            }
        }
    }

    @Override
    public void completeDropTriggerStatement_Trigger(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTriggers(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithTriggerRef_Trigger(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTriggers(model, assignment, context, acceptor);
    }

    @Override
    public void completeTriggerEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTriggers(model, assignment, context, acceptor);
    }

    private void proposeTriggers(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            Schema schema = cqlContext.getSchema(index);
            this.proposeNames(schema.getTriggers(), context, acceptor, UiConstant.ImageType.TRIGGER);
        }
    }

    @Override
    public void completeDataResource_All(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALL KEYSPACES", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void completeDataResource_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDataResource_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeRoleResource_All(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALL ROLES", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void completeFunctionResource_All(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALL FUNCTIONS", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void completeFunctionResource_AllInKeyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALL FUNCTIONS IN KEYSPACE", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void completeFunctionResource_FunctionName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserDefinedFunctions(model, context, acceptor, true);
    }

    @Override
    public void completeDropFunctionStatement_Function(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserDefinedFunctions(model, context, acceptor, true);
    }

    private void proposeUserDefinedFunctions(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, boolean prefixWithKeyspace) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
            if (ksMeta != null) {
                this.proposeUserDefinedFunctionsInKeyspace(prefixWithKeyspace, context, acceptor, ksMeta);
            } else {
                this.proposeAllUserDefinedFunctions(prefixWithKeyspace, context, acceptor, schema);
            }
        }
    }

    private void proposeAllUserDefinedFunctions(boolean prefixWithKeyspace, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Schema schema) {
        for (Keyspace ks : schema.getKeyspaces()) {
            this.proposeUserDefinedFunctionsInKeyspace(prefixWithKeyspace, context, acceptor, ks);
        }
    }

    private void proposeUserDefinedFunctionsInKeyspace(boolean prefixWithKeyspace, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Keyspace ks) {
        if (ks != null) {
            String keyspacePrefix = prefixWithKeyspace ? String.valueOf(ks.getName()) + "." : "";
            for (SchemaFunction function : ks.getFunctions()) {
                String functionProposal = String.valueOf(keyspacePrefix) + FunctionUtil.getFunctionDisplayString((SchemaFunction)function);
                this.proposeText(functionProposal, context, acceptor, UiConstant.ImageType.UDF);
            }
        }
    }

    @Override
    public void complete_SelectorFunctionArgs(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String name;
        SelectorFunction selectorFunction;
        if (model != null && model instanceof SelectorFunction && (selectorFunction = (SelectorFunction)model).getFunctionName() != null && selectorFunction.getFunctionName().getName() != null && ((name = selectorFunction.getFunctionName().getName()).equalsIgnoreCase("toJson") || name.equalsIgnoreCase("max") || name.equalsIgnoreCase("min") || name.equalsIgnoreCase("avg") || name.equalsIgnoreCase("sum"))) {
            this.proposeColumns("", "", model, context, acceptor);
        }
    }

    @Override
    public void completeAlterKeyspaceStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropKeyspaceStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeUseStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateTableStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeAlterTableStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTableStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateIndexStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropIndexStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateTriggerStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTriggerStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeInsertStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelectStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeUpdateStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDeleteStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeTruncateStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithKeyspaceRef_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateTypeStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeAlterTypeStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTypeStatement_Keyspace(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    @Override
    public void completeKeyspaceEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeyspaces(model, assignment, context, acceptor);
    }

    private void proposeKeyspaces(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            Schema schema = cqlContext.getSchema(index);
            Resource r = ModelUtil.getResource((CqlStatement)stmt);
            if (r != null && r.getDataResource() != null) {
                if (r.getDataResource().isKeyspaceResource()) {
                    this.proposeNames(schema.getKeyspaces(), context, acceptor, UiConstant.ImageType.KEYSPACE);
                } else {
                    this.proposeNames(schema.getKeyspaces(), "", ".", context, acceptor, UiConstant.ImageType.KEYSPACE);
                }
            } else if (stmt instanceof UseStatement || stmt instanceof DropKeyspaceStatement || stmt instanceof AlterKeyspaceStatement) {
                this.proposeNames(schema.getKeyspaces(), context, acceptor, UiConstant.ImageType.KEYSPACE);
            } else {
                this.proposeNames(schema.getKeyspaces(), "", ".", context, acceptor, UiConstant.ImageType.KEYSPACE);
            }
        }
    }

    @Override
    public void completeAlterTableStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTableStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateIndexStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateTriggerStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTriggerStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeInsertStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelectStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeUpdateStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeDeleteStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeTruncateStatement_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithTableRef_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    @Override
    public void completeTableEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(model, assignment, context, acceptor);
    }

    private void proposeTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
            if (ksMeta != null) {
                this.proposeNames(ksMeta.getTables(), context, acceptor, UiConstant.ImageType.TABLE);
            }
        }
    }

    @Override
    public void completeType_UserType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserTypes(model, assignment, context, acceptor);
    }

    @Override
    public void completeAlterTypeStatement_UserType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserTypes(model, assignment, context, acceptor);
    }

    @Override
    public void completeDropTypeStatement_UserType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserTypes(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithTypeRef_UserType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserTypes(model, assignment, context, acceptor);
    }

    @Override
    public void completeTypeEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeUserTypes(model, assignment, context, acceptor);
    }

    private void proposeUserTypes(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
            if (ksMeta != null) {
                this.proposeNames(ksMeta.getUserTypes(), context, acceptor, UiConstant.ImageType.TYPE);
            }
        }
    }

    @Override
    public void completeTableOrdering_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeAlterTableStatement_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeCreateIndexStatement_IndexColumnDef(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeIndexColumnDef_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelector_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelectorWritetime_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelectorTTL_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeOrderByClause_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeColumnOperation_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeColumnOperation_OtherColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeDeleteOp_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithColumnRef_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeColumnEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ColumnDefImpl columnDef = (ColumnDefImpl)ModelUtil.getAncestorOfType((EObject)model, ColumnDefImpl.class);
        if (columnDef != null && !columnDef.isPrimaryKey()) {
            this.proposeColumns(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeAlterTableStatement_OldColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void completeStandardInsertStatement_Columns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    @Override
    public void complete_JsonKeyValue(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model.eContainer() instanceof EmbeddedJSONString) {
            String text = context.getCurrentNode().getText();
            if (text.startsWith("\"") && text.endsWith("\"")) {
                this.proposeColumns("\"", "", model, context, acceptor);
            } else {
                this.proposeColumns("\"", "\"", model, context, acceptor);
                this.proposeText("\"\"", 1, context, acceptor, UiConstant.ImageType.PUNCTUATION);
            }
        }
    }

    @Override
    public void completeRelation_Columns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumns(model, assignment, context, acceptor);
    }

    private void proposeColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        this.proposeColumns("", "", model, context, acceptor);
    }

    private void proposeColumns(String prefix, String suffix, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        if (stmt instanceof AlterTableStatement && ((AlterTableStatement)stmt).getOperation().equalsIgnoreCase("add")) {
            return;
        }
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Table tableMetadata = schema.getTable(keyspaceEntity, tableEntity);
            if (tableMetadata != null) {
                LinkedHashSet<Column> columns = new LinkedHashSet<Column>(tableMetadata.getColumns());
                this.maybeFilterPrimaryKeyColumns(stmt, tableMetadata, columns);
                this.proposeEntitiesNotInCollection(prefix, suffix, columns, this.collectUsedColumnNames(model), context, acceptor, UiConstant.ImageType.COLUMN);
            }
        }
    }

    private void maybeFilterPrimaryKeyColumns(CqlStatement stmt, Table tableMetadata, Collection<Column> columns) {
        if (stmt instanceof CreateIndexStatement || stmt instanceof AlterTableStatement && ((AlterTableStatement)stmt).getOperation().equalsIgnoreCase("drop")) {
            columns.removeAll(tableMetadata.getPrimaryKeys());
        }
    }

    @Override
    public void completeRelation_Column(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Table tableMetadata = schema.getTable(keyspaceEntity, tableEntity);
            if (tableMetadata != null) {
                LinkedHashSet<Column> whereClauseColumns = new LinkedHashSet<Column>(tableMetadata.getPrimaryKeys());
                if (!(stmt instanceof DeleteStatement)) {
                    for (Column column : tableMetadata.getColumns()) {
                        if (column.getIndex() == null) continue;
                        whereClauseColumns.add(column);
                    }
                }
                this.proposeNames(whereClauseColumns, context, acceptor, UiConstant.ImageType.COLUMN);
            }
        }
    }

    @Override
    public void completeTokenArgs_Columns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            Table tableMetadata = schema.getTable(keyspaceEntity, tableEntity);
            if (tableMetadata != null) {
                LinkedHashSet whereClauseColumns = new LinkedHashSet(tableMetadata.getPrimaryKeys());
                this.proposeNames(whereClauseColumns, context, acceptor, UiConstant.ImageType.COLUMN);
            }
        }
    }

    private Collection<Column> collectUsedColumnNames(EObject model) {
        ArrayList<Column> proposedColumns = new ArrayList<Column>();
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
        TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
        if (tableEntity == null) {
            return proposedColumns;
        }
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (index == -1) {
            return proposedColumns;
        }
        Schema schema = cqlContext.getSchema(index);
        if (schema == null) {
            return proposedColumns;
        }
        Table cfMeta = schema.getTable(keyspaceEntity, tableEntity);
        if (cfMeta == null) {
            return proposedColumns;
        }
        List<String> proposedNames = this.collectProposedColumnNames(stmt);
        for (Column column : cfMeta.getColumns()) {
            if (!proposedNames.contains(column.getName())) continue;
            proposedColumns.add(column);
        }
        return proposedColumns;
    }

    private List<String> collectProposedColumnNames(CqlStatement stmt) {
        ArrayList<String> proposed;
        block11: {
            block12: {
                block10: {
                    proposed = new ArrayList<String>();
                    if (!(stmt instanceof SelectStatement)) break block10;
                    SelectClause sc = ((SelectStatement)stmt).getSelectClause();
                    if (sc == null || sc.getSelectors() == null) break block11;
                    for (Selector sel : sc.getSelectors()) {
                        if (sel.getColumn() == null) continue;
                        proposed.add(ModelUtil.stripName((String)sel.getColumn().getName()));
                    }
                    break block11;
                }
                if (!(stmt instanceof InsertStatement)) break block12;
                InsertStatement insert = (InsertStatement)stmt;
                if (insert.getStandardInsertPart() == null || insert.getStandardInsertPart().getColumns() == null) break block11;
                for (ColumnEntity colName : insert.getStandardInsertPart().getColumns()) {
                    proposed.add(ModelUtil.stripName((String)colName.getName()));
                }
                break block11;
            }
            if (stmt instanceof UpdateStatement) {
                for (ColumnOperation colop : ((UpdateStatement)stmt).getOperations()) {
                    if (colop.getColumn() == null) continue;
                    proposed.add(ModelUtil.stripName((String)colop.getColumn().getName()));
                }
            } else if (stmt instanceof DeleteStatement) {
                for (DeleteOp delop : ((DeleteStatement)stmt).getSelections()) {
                    if (delop.getColumn() == null) continue;
                    proposed.add(ModelUtil.stripName((String)delop.getColumn().getName()));
                }
            } else if (stmt instanceof AlterTableStatement) {
                for (ColumnEntity colName : ((AlterTableStatement)stmt).getOldColumns()) {
                    proposed.add(ModelUtil.stripName((String)colName.getName()));
                }
            }
        }
        return proposed;
    }

    @Override
    public void completeAlterTypeStatement_UserTypeField(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeUserTypeEntry_UserTypeField(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithFieldRef_UserTypeField(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeFieldEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeAlterTypeStatement_OlduserTypeFields(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeSelector_UserTypeFields(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    @Override
    public void completeRulesWithFieldsRef_UserTypeFields(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeFields(model, assignment, context, acceptor);
    }

    private void proposeFields(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        if (stmt instanceof AlterTypeStatement && ((AlterTypeStatement)stmt).getOperation().equalsIgnoreCase("add")) {
            return;
        }
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (stmt != null && index >= 0) {
            TypeEntity typeEntity;
            KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
            Schema schema = cqlContext.getSchema(index);
            UserType typeMetadata = schema.getUserType(keyspaceEntity, typeEntity = this.getTypeEntityFromModel(model, schema, keyspaceEntity));
            if (typeMetadata != null) {
                this.proposeNames(typeMetadata.getFields(), context, acceptor, UiConstant.ImageType.FIELD);
            }
        }
    }

    private TypeEntity getTypeEntityFromModel(EObject model, Schema schema, KeyspaceEntity keyspaceEntity) {
        Column col;
        ColumnEntity columnEntity;
        RulesWithTypeRef rulesWithTypeRef = (RulesWithTypeRef)ModelUtil.getAncestorOfType((EObject)model, RulesWithTypeRef.class);
        if (rulesWithTypeRef != null) {
            return rulesWithTypeRef.getUserType();
        }
        TypeEntity tempTypeEntity = null;
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
        RulesWithColumnRef ruleWithColumnRef = (RulesWithColumnRef)ModelUtil.getAncestorOfType((EObject)model, RulesWithColumnRef.class);
        if (ruleWithColumnRef != null && (columnEntity = ruleWithColumnRef.getColumn()) != null && schema != null && (col = schema.getColumn(keyspaceEntity, tableEntity, columnEntity)) != null && col.getType().isUserDefinedType()) {
            tempTypeEntity = !col.getType().isFrozen() ? col.getType().toGrammarType().getUserType() : col.getType().toGrammarType().getFrozenType().getUserType();
        }
        return tempTypeEntity;
    }

    @Override
    public void completeMapEntry_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeMapEntry_Value(model, assignment, context, acceptor);
        Property property = (Property)ModelUtil.getAncestorOfType((EObject)model, Property.class);
        MapEntry option = (MapEntry)ModelUtil.getAncestorOfType((EObject)model, MapEntry.class);
        if (property == null || option == null) {
            return;
        }
        String propertyName = property.getName().toLowerCase();
        String optionName = ModelUtil.termToString((Term)option.getKey());
        if (propertyName.equals("compression")) {
            if (optionName.equals("'sstable_compression'")) {
                this.proposeText("'SnappyCompressor'", "Snappy Compressor", context, acceptor, UiConstant.ImageType.KEYWORD);
                this.proposeText("'DeflateCompressor'", "Deflate Compressor", context, acceptor, UiConstant.ImageType.KEYWORD);
                this.proposeText("'LZ4Compressor'", "LZ4 Compressor", context, acceptor, UiConstant.ImageType.KEYWORD);
                this.proposeText("''", "Disable Compression", context, acceptor, UiConstant.ImageType.KEYWORD);
            }
        } else if (propertyName.equals("compaction")) {
            if (optionName.equals("'class'")) {
                this.proposeText("'SizeTieredCompactionStrategy'", "SizeTieredCompactionStrategy", context, acceptor, UiConstant.ImageType.KEYWORD);
                this.proposeText("'LeveledCompactionStrategy'", "LeveledCompactionStrategy", context, acceptor, UiConstant.ImageType.KEYWORD);
            }
        } else if (propertyName.equals("replication") && optionName.equals("'class'")) {
            this.proposeText("'SimpleStrategy'", "SimpleStrategy", context, acceptor, UiConstant.ImageType.KEYWORD);
            this.proposeText("'NetworkTopologyStrategy'", "NetworkTopologyStrategy", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void completeProperty_PropertyValue(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeProperty_PropertyValue(model, assignment, context, acceptor);
        Property property = null;
        property = (Property)ModelUtil.getAncestorOfType((EObject)model, Property.class);
        if (property == null) {
            return;
        }
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("caching")) {
            this.proposeText("'all'", "all", context, acceptor, UiConstant.ImageType.KEYWORD);
            this.proposeText("'keys_only'", "keys only", context, acceptor, UiConstant.ImageType.KEYWORD);
            this.proposeText("'rows_only'", "rows only", context, acceptor, UiConstant.ImageType.KEYWORD);
            this.proposeText("'none'", "none", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_RelationType(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("> ", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        this.proposeText("< ", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        this.proposeText("= ", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        this.proposeText(">= ", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        this.proposeText("<= ", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void completeUpdateStatement_KSet(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeUpdateStatement_KSet(model, assignment, context, acceptor);
        this.proposeText("SET", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_NativeType(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ascii", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("bigint", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("blob", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("boolean", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        if (!(model instanceof CollectionType)) {
            this.proposeText("counter", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        }
        this.proposeText("date", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("decimal", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("double", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("float", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("inet", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("int", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("smallint", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("text", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("time", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("timestamp", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("tinyint", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("uuid", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("varchar", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("varint", context, acceptor, UiConstant.ImageType.NATIVETYPE);
        this.proposeText("timeuuid", context, acceptor, UiConstant.ImageType.NATIVETYPE);
    }

    @Override
    public void complete_K_IF(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("IF ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_IfNotExists(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean shouldPropose;
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_0.compareTo(cqlContext.getCassandraVersion()) <= 0 && (shouldPropose = this.checkUDFIfNotExistsAndOrReplace(model))) {
            this.proposeText("IF NOT EXISTS ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    private boolean checkUDFIfNotExistsAndOrReplace(EObject model) {
        boolean shouldReplace = true;
        if (model != null && model instanceof CreateFunctionStatement && ((CreateFunctionStatement)model).isReplace()) {
            shouldReplace = false;
        } else if (model != null && model instanceof CreateAggregateFunctionStatement && ((CreateAggregateFunctionStatement)model).isReplace()) {
            shouldReplace = false;
        }
        return shouldReplace;
    }

    @Override
    public void complete_IfExists(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("IF EXISTS ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_TRIGGER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("TRIGGER ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_STATIC(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_6.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("STATIC", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_TUPLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_1_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("TUPLE", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_FROZEN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_1_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("FROZEN", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_CONTAINS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_1_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("CONTAINS ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_KEYS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_1_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("KEYS ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_FULL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_1_3.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("FULL ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_ENTRIES(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_2_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("ENTRIES ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_EXISTS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_0_7.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("EXISTS", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    private void proposeEntitiesNotInCollection(String prefix, String suffix, Collection<? extends ISchemaElement> entities, Collection<? extends ISchemaElement> filterCollection, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        ArrayList<ISchemaElement> proposedEntities = new ArrayList<ISchemaElement>();
        for (ISchemaElement iSchemaElement : entities) {
            if (filterCollection.contains(iSchemaElement)) continue;
            proposedEntities.add(iSchemaElement);
        }
        this.proposeNames(prefix, suffix, proposedEntities, context, acceptor, type);
    }

    private void proposeNames(Collection<? extends ISchemaElement> entities, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        this.proposeNames("", "", entities, context, acceptor, type);
    }

    private void proposeNames(String prefix, String suffix, Collection<? extends ISchemaElement> entities, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        this.proposeNames(entities, prefix, suffix, context, acceptor, type);
    }

    private void proposeNames(Collection<? extends ISchemaElement> entities, String enterPrefix, String enterSuffix, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        if (entities != null) {
            for (ISchemaElement iSchemaElement : entities) {
                if (StringUtils.isEmpty((String)iSchemaElement.getName())) continue;
                this.proposeName(iSchemaElement, enterPrefix, enterSuffix, context, acceptor, type);
            }
        }
    }

    private void proposeName(ISchemaElement entity, String enterPrefix, String enterSuffix, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        if (type.equals((Object)UiConstant.ImageType.COLUMN)) {
            Column column = (Column)entity;
            this.proposeName(entity.getName(), enterPrefix, enterSuffix, entity.getName(), "", " " + column.getType().toCanonicalString(), context, acceptor, type);
        } else {
            this.proposeName(entity.getName(), enterPrefix, enterSuffix, entity.getName(), "", "", context, acceptor, type);
        }
    }

    protected void proposeName(String enter, String enterPrefix, String enterSuffix, String description, String descriptionPrefix, String descriptionSuffix, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        String textInEdit = type.equals((Object)UiConstant.ImageType.INDEX) ? enter : ModelUtil.escapeName((String)enter);
        String enterString = String.valueOf(enterPrefix) + textInEdit + enterSuffix;
        String descriptionString = String.valueOf(descriptionPrefix) + description + descriptionSuffix;
        this.proposeText(enterString, descriptionString, context, acceptor, type);
    }

    private void proposeName(String enter, String description, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType type) {
        this.proposeName(enter, "", "", description, "", "", context, acceptor, type);
    }

    @Override
    public void complete_K_SELECT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("SELECT ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_FROM(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("FROM ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_WHERE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("WHERE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_AND(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("AND ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_KEY(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("KEY ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INSERT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("INSERT INTO ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_UPDATE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("UPDATE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_WITH(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        if (!(stmt instanceof CreateIndexStatement) || ((CreateIndexStatement)stmt).isCustom()) {
            this.proposeText("WITH ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_LIMIT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("LIMIT ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_USING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        if (!(stmt instanceof CreateIndexStatement) || ((CreateIndexStatement)stmt).isCustom()) {
            this.proposeText("USING ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_K_USE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("USE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_COUNT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("COUNT(*) ", "COUNT(*)", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BEGIN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("BEGIN ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_UNLOGGED(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("UNLOGGED ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BATCH(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("BATCH ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_APPLY(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("APPLY BATCH;\n", "APPLY BATCH", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TRUNCATE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TRUNCATE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DELETE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("DELETE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_IN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("IN (", "IN", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_CREATE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("CREATE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_KEYSPACE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("KEYSPACE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_KEYSPACES(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("KEYSPACES ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TABLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TABLE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INDEX(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("INDEX ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_CUSTOM(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("CUSTOM ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ON(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ON ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TO(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TO ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DROP(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("DROP ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INTO(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("INTO ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_VALUES(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("VALUES ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TIMESTAMP(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TIMESTAMP ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TTL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TTL( ", "TTL", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ALTER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALTER ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_RENAME(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("RENAME ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ADD(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ADD ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TYPE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TYPE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_COMPACT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("COMPACT STORAGE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_STORAGE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("STORAGE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ORDER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ORDER BY ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BY(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("BY ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ASC(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ASC", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DESC(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("DESC", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_AllowFiltering(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ALLOW FILTERING", "ALLOW FILTERING", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_GRANT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("GRANT ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_PERMISSION(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("PERMISSION ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_PERMISSIONS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("PERMISSIONS ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_OF(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("OF ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_REVOKE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("REVOKE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_MODIFY(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("MODIFY ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_AUTHORIZE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("AUTHORIZE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DESCRIBE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("DESCRIBE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_EXECUTE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("EXECUTE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_NORECURSIVE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("NORECURSIVE", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_USER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("USER ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_USERS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("USERS ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_SUPERUSER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("SUPERUSER", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_NOSUPERUSER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("NOSUPERUSER", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_PASSWORD(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("PASSWORD ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ASCII(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ascii ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BIGINT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("bigint ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BLOB(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("blob ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_BOOLEAN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("boolean ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_COUNTER(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("counter ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DECIMAL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("decimal ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DOUBLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("double ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_FLOAT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("float ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INET(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("inet ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("int ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_SMALLINT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("smallint ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TINYINT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("tinyint ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_DATE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("date ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TIME(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("time ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TEXT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("text ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_UUID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("uuid ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_VARCHAR(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("varchar ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_VARINT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("varint ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_TIMEUUID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("timeuuid ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_WRITETIME(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("WRITETIME( ", "WRITETIME", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_NAN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("NaN", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INFINITY(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("Infinity", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_T_SEMICOLON(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText(";", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_T_L_PAREN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("(", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_T_R_PAREN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText(")", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_BOOLEAN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("TRUE", context, acceptor, UiConstant.ImageType.KEYWORD);
        this.proposeText("FALSE", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_T_EQ(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("=", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_K_JSON(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        if (CqlConstants.CASSANDRA_2_2_0.compareTo(cqlContext.getCassandraVersion()) <= 0) {
            this.proposeText("JSON ", context, acceptor, UiConstant.ImageType.KEYWORD);
        }
    }

    @Override
    public void complete_T_ASTERISK(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("*", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_K_ROLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ROLE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_ROLES(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("ROLES ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_OPTIONS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("OPTIONS ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_REPLACE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("REPLACE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_LOGIN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("LOGIN ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_FUNCTION(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("FUNCTION ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_RETURNS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("RETURNS ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_LANGUAGE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("LANGUAGE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_AS(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("AS ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_AGGREGATE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("AGGREGATE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_SFUNC(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("SFUNC ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_STYPE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("STYPE ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_FINALFUNC(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("FINALFUNC ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_INITCOND(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("INITCOND ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_SINGLE_QUOTE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (context.getCurrentModel() instanceof JSONInsertStatement) {
            this.proposeText("'{}'", 2, context, acceptor, UiConstant.ImageType.PUNCTUATION);
        } else {
            this.proposeText("'", 1, context, acceptor, UiConstant.ImageType.PUNCTUATION);
        }
    }

    @Override
    public void complete_K_INPUT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("INPUT ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_CALLED(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("CALLED ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_NULL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("NULL ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }

    @Override
    public void complete_K_OR(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("OR ", context, acceptor, UiConstant.ImageType.KEYWORD);
    }
}

