/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.contentassist;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.AlterKeyspaceStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.Function;
import com.datastax.devcenter.cql.cql.FunctionDeclarationStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TableOrdering;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.impl.DropFunctionStatementImpl;
import com.datastax.devcenter.cql.services.CqlGrammarAccess;
import com.datastax.devcenter.cql.ui.UiConstant;
import com.datastax.devcenter.cql.ui.contentassist.StyledStringTemplateProposal;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;

public class CqlTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    ContextTypeIdHelper helper;
    @Inject
    private CqlContextProvider cqlContextProvider;
    @Inject
    private CqlGrammarAccess ga;

    @Inject
    public CqlTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.helper = helper;
    }

    public Image getImage(Template template) {
        return UiConstant.ImageType.TEMPLATE.getImage();
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        CqlContext cqlContext;
        super.createTemplates(templateContext, context, acceptor);
        String currentId = templateContext.getContextType().getId();
        EObject currentModel = context.getCurrentModel();
        if (this.helper.getId((AbstractRule)this.ga.getCollectionTypeRule()).equals(currentId) && (currentModel instanceof ColumnEntity || currentModel instanceof AlterTableStatement)) {
            this.proposeCollectionTypeTemplate(templateContext, context, acceptor);
        }
        if (this.helper.getId((AbstractRule)this.ga.getPropertyRule()).equals(currentId)) {
            this.proposePropertyTemplate(templateContext, context, acceptor);
        }
        Property property = (Property)ModelUtil.getAncestorOfType((EObject)currentModel, Property.class);
        if (this.helper.getId((AbstractRule)this.ga.getMapEntryRule()).equals(currentId) && property != null) {
            this.proposePropertyOptionTemplate(templateContext, context, acceptor);
        }
        if (this.helper.getId((AbstractRule)this.ga.getTableOrderingRule()).equals(currentId)) {
            this.proposeTableOrderingTemplate(templateContext, context, acceptor);
        }
        if (this.helper.getId((AbstractRule)this.ga.getColumnEntityRule()).equals(currentId)) {
            this.proposeColumnNameTemplate(templateContext, context, acceptor);
        }
        if (this.helper.getId((AbstractRule)this.ga.getRelationRule()).equals(currentId)) {
            this.proposeRelationCompareTemplate(templateContext, context, acceptor);
        }
        if (this.helper.getId((AbstractRule)this.ga.getTokenRelationRule()).equals(currentId)) {
            this.proposeTokenRelationTemplate(templateContext, context, acceptor, currentId);
        }
        if (this.helper.getId((AbstractRule)this.ga.getSelectorFunctionRule()).equals(currentId)) {
            this.proposeTokenSelectorTemplate(templateContext, context, acceptor, currentId);
        }
        if (this.helper.getId((AbstractRule)this.ga.getFunctionNameRule()).equals(currentId)) {
            this.proposeFunctions(templateContext, context, acceptor, currentId, this.ga.getFunctionNameRule());
        }
        if (this.helper.getId((AbstractRule)this.ga.getFieldEntityRule()).equals(currentId)) {
            this.proposeFunctions(templateContext, context, acceptor, currentId, this.ga.getFieldEntityRule());
        }
        if ((cqlContext = this.getCqlContext(context)).isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            this.proposeVersion2Templates(templateContext, context, acceptor, currentId);
        }
        if (cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0)) {
            this.proposeVersion21Templates(templateContext, context, acceptor, currentId);
        }
        if (cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_2_0)) {
            this.proposeVersion22Templates(templateContext, context, acceptor, currentId);
        }
    }

    private CqlContext getCqlContext(ContentAssistContext cac) {
        XtextDocument document = (XtextDocument)cac.getDocument();
        URI resourceURI = document.getResourceURI();
        return this.cqlContextProvider.get(resourceURI);
    }

    private void proposeVersion2Templates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String currentId) {
        if (this.helper.getId((AbstractRule)this.ga.getCreateTriggerStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "CREATE TRIGGER", "", this.helper.getId((AbstractRule)this.ga.getTriggerEntityRule()), "CREATE TRIGGER ${triggerName} ON ${tableName} USING '${triggerClass}';");
        }
        if (this.helper.getId((AbstractRule)this.ga.getDropTriggerStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "DROP TRIGGER", "", this.helper.getId((AbstractRule)this.ga.getTriggerEntityRule()), "DROP TRIGGER ${triggerName} ON ${tableName};");
        }
    }

    private void proposeVersion21Templates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String currentId) {
        if (this.helper.getId((AbstractRule)this.ga.getCreateTypeStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "CREATE TYPE", "", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "CREATE TYPE ${typeName} (\n\t${columnName} ${type}\n);");
        }
        if (this.helper.getId((AbstractRule)this.ga.getDropTypeStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "DROP TYPE", "", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "DROP TYPE ${typeName};");
        }
        if (this.helper.getId((AbstractRule)this.ga.getAlterTypeStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "ALTER TYPE", "Add type", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER TYPE ${typeName} ADD ${fieldName} ${columnType};");
            this.proposeTemplate(templateContext, context, acceptor, "ALTER TYPE", "Alter field type", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER TYPE ${typeName} ALTER ${fieldName} TYPE ${columnType};");
            this.proposeTemplate(templateContext, context, acceptor, "ALTER TYPE", "Rename field", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER TYPE ${typeName} RENAME ${fieldName} TO ${newName};");
        }
    }

    private void proposeVersion22Templates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String currentId) {
        if (this.helper.getId((AbstractRule)this.ga.getCreateRoleStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "CREATE ROLE", "", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "CREATE ROLE ${roleName} WITH PASSWORD = '${password}';");
        }
        if (this.helper.getId((AbstractRule)this.ga.getDropRoleStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "DROP ROLE", "", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "DROP ROLE ${roleName};");
        }
        if (this.helper.getId((AbstractRule)this.ga.getAlterTypeStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "ALTER ROLE", "Change password", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER ROLE ${roleName} WITH PASSWORD = '${password}';");
            this.proposeTemplate(templateContext, context, acceptor, "ALTER ROLE", "Change login", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER ROLE ${roleName} WITH LOGIN = ${};");
            this.proposeTemplate(templateContext, context, acceptor, "ALTER ROLE", "Change superuser", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "ALTER ROLE ${roleName} WITH SUPERUSER = ${};");
        }
        if (this.helper.getId((AbstractRule)this.ga.getListRolesStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "LIST ROLES", "List all roles", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "LIST ROLES;");
            this.proposeTemplate(templateContext, context, acceptor, "LIST ROLES", "List roles of role", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "LIST ROLES OF ${roleName};");
            this.proposeTemplate(templateContext, context, acceptor, "LIST ROLES", "List roles of role norecursive", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "LIST ROLES OF ${roleName} NORECURSIVE;");
        }
        if (this.helper.getId((AbstractRule)this.ga.getGrantStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "GRANT", "Grant role to a user or role", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "GRANT ${roleName} TO ${userOrRoleName};");
        }
        if (this.helper.getId((AbstractRule)this.ga.getRevokeStatementRule()).equals(currentId)) {
            this.proposeTemplate(templateContext, context, acceptor, "REVOKE", "Revoke role from a user or role", this.helper.getId((AbstractRule)this.ga.getTypeEntityRule()), "REVOKE ${roleName} FROM ${userOrRoleName};");
        }
    }

    private void proposeTokenSelectorTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String targetId) {
        EObject o = context.getCurrentModel();
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)o);
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
        TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
        if (tableEntity == null) {
            return;
        }
        CqlContext cqlContext = this.cqlContextProvider.get(o);
        Table cfMeta = cqlContext.getSchemaToCheck().getTable(keyspaceEntity, tableEntity);
        if (cfMeta == null) {
            return;
        }
        List partitionKeys = cfMeta.getPartitionKeys();
        if (partitionKeys.size() == 0) {
            return;
        }
        String args = ModelUtil.escapeName((String)((Column)partitionKeys.get(0)).getName());
        int i = 1;
        while (i < partitionKeys.size()) {
            args = String.valueOf(args) + ", " + ModelUtil.escapeName((String)((Column)partitionKeys.get(i)).getName());
            ++i;
        }
        this.proposeTemplate(templateContext, context, acceptor, "Function", "token(" + args + ")", targetId, "token(" + args + ")");
    }

    private void proposeTokenRelationTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String targetId) {
        EObject o = context.getCurrentModel();
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)o);
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace((CqlStatement)stmt);
        TableEntity tableEntity = ModelUtil.getTable((CqlStatement)stmt);
        if (tableEntity == null) {
            return;
        }
        CqlContext cqlContext = this.cqlContextProvider.get(o);
        Table cfMeta = cqlContext.getSchemaToCheck().getTable(keyspaceEntity, tableEntity);
        if (cfMeta == null) {
            return;
        }
        List partitionKeys = cfMeta.getPartitionKeys();
        String args = ModelUtil.escapeName((String)((Column)partitionKeys.get(0)).getName());
        String types = String.format("${%sType1}", ((Column)partitionKeys.get(0)).getType().toString());
        int i = 1;
        while (i < partitionKeys.size()) {
            args = String.valueOf(args) + ", " + ModelUtil.escapeName((String)((Column)partitionKeys.get(i)).getName());
            types = String.valueOf(types) + String.format(", ${%sType%d}", ((Column)partitionKeys.get(i)).getType().toString(), i + 1);
            ++i;
        }
        this.proposeTemplate(templateContext, context, acceptor, "Relation", "token (partition key) compare with token", targetId, "token(" + args + ") ${comparator} token(" + types + ")");
    }

    private void proposeRelationCompareTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)context.getCurrentModel());
        if (stmt instanceof SelectStatement) {
            this.proposeTemplate(templateContext, context, acceptor, "Relation", "compare", this.helper.getId((AbstractRule)this.ga.getRelationRule()), "${columnName} ${comparator} ${term}");
        } else if (stmt instanceof UpdateStatement || stmt instanceof DeleteStatement) {
            this.proposeTemplate(templateContext, context, acceptor, "Relation", "equal", this.helper.getId((AbstractRule)this.ga.getRelationRule()), "${columnName} = ${term}");
        }
    }

    private void proposeColumnNameTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        CreateTableStatement stmt = (CreateTableStatement)ModelUtil.getAncestorOfType((EObject)context.getCurrentModel(), CreateTableStatement.class);
        if (stmt == null || stmt.getColumnDefinitions() == null) {
            return;
        }
        boolean isPrimaryKeyDefined = false;
        for (ColumnDef tableColumn : stmt.getColumnDefinitions()) {
            if (tableColumn == null || !tableColumn.isPrimaryKey()) continue;
            isPrimaryKeyDefined = true;
            break;
        }
        if (!isPrimaryKeyDefined) {
            this.proposeTemplate(templateContext, context, acceptor, "Table Column Primary Key", "", this.helper.getId((AbstractRule)this.ga.getColumnEntityRule()), "${columName} ${type} PRIMARY KEY");
        }
    }

    private void proposeTableOrderingTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        CreateTableStatement stmt = (CreateTableStatement)ModelUtil.getAncestorOfType((EObject)context.getCurrentModel(), CreateTableStatement.class);
        if (stmt.getColumnDefinitions() == null) {
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDef tableColumn : stmt.getColumnDefinitions()) {
            if (tableColumn.getPrimaryKeyDefinitions() == null) continue;
            int i = 1;
            while (i < tableColumn.getPrimaryKeyDefinitions().size()) {
                PrimaryKeyDefinition pkdef = (PrimaryKeyDefinition)tableColumn.getPrimaryKeyDefinitions().get(i);
                if (pkdef.getColumn() != null) {
                    columnNames.add(pkdef.getColumn().getName());
                }
                ++i;
            }
        }
        ArrayList<String> listedColumnNames = new ArrayList<String>();
        for (TableProperty property : stmt.getProperties()) {
            if (property.getOrderings() == null) continue;
            for (TableOrdering ordering : property.getOrderings()) {
                ColumnEntity col = ordering.getColumn();
                if (col == null) continue;
                listedColumnNames.add(col.getName());
            }
        }
        for (String colName : columnNames) {
            if (listedColumnNames.contains(colName)) continue;
            this.proposeTemplate(templateContext, context, acceptor, String.format("Order by %s", colName), "", this.helper.getId((AbstractRule)this.ga.getTableOrderingRule()), String.format("%s ${ASC}", colName));
        }
    }

    private void proposePropertyOptionTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Property property = (Property)ModelUtil.getAncestorOfType((EObject)context.getCurrentModel(), Property.class);
        String propertyOptionId = this.helper.getId((AbstractRule)this.ga.getMapEntryRule());
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("compression")) {
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'sstable_compression'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option sstable_compression", "'SnappyCompressor', 'DeflateCompressor' or '' (disable)", propertyOptionId, "'sstable_compression': '${SnappyCompressor}'");
            }
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'chunk_length_kb'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option chunk_length_kb", "", propertyOptionId, "'chunk_length_kb': ${64}");
            }
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'crc_check_chance'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option crc_check_chance", "Set to 0 to disable checksum checking and to 0.5 for instance to check them every other read", propertyOptionId, "'crc_check_chance': ${checkingRate}");
            }
        } else if (propertyName.equals("compaction")) {
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'tombstone_threshold'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option tombstone_threshold", "default is 0.2", propertyOptionId, "'tombstone_threshold': ${ratio}");
            }
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'tombstone_compaction_interval'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option tombstone_compaction_interval", "default is 1", propertyOptionId, "'tombstone_compaction_interval': ${1}");
            }
            if (ModelUtil.isOptionPairExist((Property)property, (String)"'class'", (String)"'SizeTieredCompactionStrategy'")) {
                if (!ModelUtil.isOptionNameExist((Property)property, (String)"'min_sstable_size'")) {
                    this.proposeTemplate(templateContext, context, acceptor, "Option min_sstable_size", "default is 50MB (in bytes)", propertyOptionId, "'min_sstable_size': ${52428800}");
                }
                if (!ModelUtil.isOptionNameExist((Property)property, (String)"'min_threshold'")) {
                    this.proposeTemplate(templateContext, context, acceptor, "Option min_threshold", "default is 4", propertyOptionId, "'min_threshold': ${4}");
                }
                if (!ModelUtil.isOptionNameExist((Property)property, (String)"'max_threshold'")) {
                    this.proposeTemplate(templateContext, context, acceptor, "Option max_threshold", "default is 32", propertyOptionId, "'max_threshold': ${32}");
                }
                if (!ModelUtil.isOptionNameExist((Property)property, (String)"'bucket_low'")) {
                    this.proposeTemplate(templateContext, context, acceptor, "Option bucket_low", "default is 0.5", propertyOptionId, "'bucket_low': ${ratio}");
                }
                if (!ModelUtil.isOptionNameExist((Property)property, (String)"'bucket_high'")) {
                    this.proposeTemplate(templateContext, context, acceptor, "Option bucket_high", "default is 1.2", propertyOptionId, "'bucket_high': ${ratio}");
                }
            } else if (ModelUtil.isOptionPairExist((Property)property, (String)"'class'", (String)"'LeveledCompactionStrategy'") && !ModelUtil.isOptionNameExist((Property)property, (String)"'sstable_size_in_mb'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option sstable_size_in_mb", "default is 5MB (in MB)", propertyOptionId, "'sstable_size_in_mb': ${5}");
            }
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'class'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option class", "Built-in classes are 'SizeTieredCompactionStrategy' and 'LeveledCompactionStrategy'", propertyOptionId, "'class': '${SizeTieredCompactionStrategy}'");
            }
        } else if (propertyName.equals("replication")) {
            if (ModelUtil.isOptionPairExist((Property)property, (String)"'class'", (String)"'NetworkTopologyStrategy'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option data center's replication factor", "Specify replication factor of each data center", propertyOptionId, "'${dataCenterName}': ${replicationFactor}");
            } else if (ModelUtil.isOptionPairExist((Property)property, (String)"'class'", (String)"'SimpleStrategy'") && !ModelUtil.isOptionNameExist((Property)property, (String)"'replication_factor'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option replication_factor", "", propertyOptionId, "'replication_factor' : ${3}");
            }
            if (!ModelUtil.isOptionNameExist((Property)property, (String)"'class'")) {
                this.proposeTemplate(templateContext, context, acceptor, "Option class", "'NetworkTopologyStrategy'", propertyOptionId, "'class': 'NetworkTopologyStrategy', '${datacenterName}' : ${3}");
                this.proposeTemplate(templateContext, context, acceptor, "Option class", "'SimpleStrategy'", propertyOptionId, "'class': 'SimpleStrategy', 'replication_factor' : ${3}");
            }
        }
    }

    private void proposePropertyTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Collection elist;
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)context.getCurrentModel());
        String propertyId = this.helper.getId((AbstractRule)this.ga.getPropertyRule());
        if (stmt instanceof CreateKeyspaceStatement || stmt instanceof AlterKeyspaceStatement) {
            Collection elist2 = ModelUtil.getPropertyList((CqlStatement)stmt);
            if (!ModelUtil.isPropertyNamesExist((Collection)elist2, (String)"replication")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property replication (Simple Strategy)", "", propertyId, "replication = {'class': 'SimpleStrategy', 'replication_factor' : ${3}}");
                this.proposeTemplate(templateContext, context, acceptor, "Property replication (Network Topology Strategy)", "Each data center specifies its own replication factor", propertyId, "replication = {'class': 'NetworkTopologyStrategy', '${datacenterName}' : ${3}}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist2, (String)"durable_writes")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property durable_writes", "", propertyId, " durable_writes = ${true}");
            }
        } else if (stmt instanceof CreateTableStatement || stmt instanceof AlterTableStatement) {
            Collection elist3 = ModelUtil.getPropertyList((CqlStatement)stmt);
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"comment")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property comment", "", propertyId, "comment = '${comment}'");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"read_repair_chance")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property read_repair_chance", "default probability is 0.1", propertyId, "read_repair_chance = ${probability}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"dclocal_read_repair_chance")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property dclocal_read_repair_chance", "default probability is 0", propertyId, "dclocal_read_repair_chance = ${0:probability}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"gc_grace_seconds")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property gc_grace_seconds", "Time to wait before garbage collecting tombstones", propertyId, "gc_grace_seconds = ${864000}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"bloom_filter_fp_chance")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property bloom_filter_fp_chance", "default probability is 0.00075", propertyId, "bloom_filter_fp_chance = ${probability}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"compaction")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property compaction", "", propertyId, "compaction = {${subOption}}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"compression")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property compression", "", propertyId, "compression = {${subOption}}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"replicate_on_write")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property replicate_on_write", "", propertyId, "replicate_on_write = ${true}");
            }
            if (!ModelUtil.isPropertyNamesExist((Collection)elist3, (String)"caching")) {
                this.proposeTemplate(templateContext, context, acceptor, "Property caching", "'all', 'keys_only', 'rows_only' or 'none'.", propertyId, "caching = '${keys_only}'");
            }
        } else if (stmt instanceof CreateIndexStatement && !ModelUtil.isPropertyNamesExist((Collection)(elist = ModelUtil.getPropertyList((CqlStatement)stmt)), (String)"options")) {
            this.proposeTemplate(templateContext, context, acceptor, "Property OPTIONS", "", propertyId, "OPTIONS = {'${optionName}' : ${optionValue}}");
        }
    }

    private void proposeFunctions(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String targetId, ParserRule parserRule) {
        INode lastCompleteNode;
        Selector selector;
        EObject model = context.getCurrentModel();
        CqlStatement stmt = ModelUtil.getCqlStatement((EObject)model);
        CqlContext cqlContext = this.cqlContextProvider.get(model);
        int index = cqlContext.getStatementIndexMap().getStatementIndex(stmt);
        if (index < 0) {
            return;
        }
        Schema schema = cqlContext.getSchema(index);
        Keyspace ks = null;
        if (model instanceof Function) {
            Function cqlFunction = (Function)model;
            ks = schema.getKeyspace(cqlFunction.getKeyspace());
        } else if (model instanceof FunctionDeclarationStatement) {
            FunctionDeclarationStatement functionDeclaration = (FunctionDeclarationStatement)model;
            if (functionDeclaration.getFunction() != null) {
                ks = schema.getKeyspace(functionDeclaration.getFunction().getKeyspace());
            }
        } else if (model instanceof Selector ? (selector = (Selector)model).getColumn() != null && selector.getColumn().getName() != null && selector.getColumn().getName().length() > 0 && selector.getSelectorSeparators().size() == 1 && (ks = schema.getKeyspace(selector.getColumn().getName())) == null : model instanceof SelectClause && (lastCompleteNode = context.getLastCompleteNode()) != null && lastCompleteNode.getText() != null && lastCompleteNode.getText().equals(".")) {
            return;
        }
        if (ks == null) {
            ks = schema.getCurrentKeyspace();
        }
        if (!(model instanceof Selector) || this.ga.getFieldEntityRule().equals(parserRule)) {
            this.proposeUserDefinedFunctionsInKeyspace(false, templateContext, context, acceptor, targetId, ks);
        }
        this.proposeFromJson(templateContext, context, acceptor, targetId);
    }

    private void proposeFromJson(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String targetId) {
        this.proposeTemplate(templateContext, context, acceptor, "fromJson", "", targetId, "fromJson('{\"${firstKey}\" : ${firstValue}}')", UiConstant.ImageType.TEMPLATE.getImage());
    }

    private void proposeUserDefinedFunctionsInKeyspace(boolean prefixWithKeyspace, TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String targetId, Keyspace ks) {
        DropFunctionStatement dropStatement = null;
        if (context != null && context.getCurrentModel() != null) {
            dropStatement = (DropFunctionStatement)ModelUtil.getAncestorOfType((EObject)context.getCurrentModel(), DropFunctionStatementImpl.class);
        }
        if (ks != null) {
            for (SchemaFunction function : ks.getFunctions()) {
                String functionSignature = String.valueOf(this.getKeyspacePrefix(prefixWithKeyspace, ks)) + FunctionUtil.getFunctionDisplayString((SchemaFunction)function);
                String templateString = String.valueOf(this.getKeyspacePrefix(prefixWithKeyspace, ks)) + (dropStatement == null ? FunctionUtil.getFunctionProposalString((SchemaFunction)function, (boolean)true) : functionSignature);
                this.proposeTemplate(templateContext, context, acceptor, functionSignature, "", targetId, templateString, UiConstant.ImageType.UDF.getImage(), UiConstant.ImageType.UDF.getPriority());
            }
        }
    }

    private String getKeyspacePrefix(boolean prefixWithKeyspace, Keyspace ks) {
        return prefixWithKeyspace ? String.valueOf(ks.getName()) + "." : "";
    }

    private void proposeCollectionTypeTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        this.proposeTemplate(templateContext, context, acceptor, "map <type1, type2>", "map collection type", "CollectionMap", "map <${type1}, ${type2}>");
        this.proposeTemplate(templateContext, context, acceptor, "list <type>", "list collection type", "CollectionList", "list <${type}>");
        this.proposeTemplate(templateContext, context, acceptor, "set <type>", "set collection type", "CollectionSet", "set <${type}>");
    }

    private void proposeTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String name, String description, String contextTypeId, String pattern) {
        this.proposeTemplate(templateContext, context, acceptor, name, description, contextTypeId, pattern, UiConstant.ImageType.TEMPLATE.getImage());
    }

    private void proposeTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String name, String description, String contextTypeId, String pattern, Image image) {
        Template template = new Template(name, description, contextTypeId, pattern, true);
        acceptor.accept(this.createProposal(template, templateContext, context, image, this.getRelevance(template)));
    }

    private void proposeTemplate(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor, String name, String description, String contextTypeId, String pattern, Image image, int relevance) {
        Template template = new Template(name, description, contextTypeId, pattern, true);
        acceptor.accept(this.createProposal(template, templateContext, context, image, relevance));
    }

    protected TemplateProposal doCreateProposal(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        return new StyledStringTemplateProposal(template, templateContext, context.getReplaceRegion(), image, relevance);
    }
}

