/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.contentassist.antlr.parser;

import com.datastax.devcenter.cql.ui.contentassist.antlr.CqlParser;
import com.datastax.devcenter.cql.ui.contentassist.antlr.internal.InternalCqlParser;
import com.datastax.devcenter.cql.ui.contentassist.antlr.lexer.UICustomCqlLexer;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.regex.Pattern;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.InfiniteRecursion;

public class CustomCqlParser
extends CqlParser {
    private Pattern danglingJsonStringPattern = Pattern.compile("(?s)(.*)(JSON|json)(.*)'(.*)$");

    public Collection<FollowElement> getFollowElements(String input, boolean strict) {
        TokenSource tokenSource = this.modifyInputIfDanglingJSON(input);
        InternalCqlParser parser = this.createParser();
        parser.setStrict(strict);
        ObservableXtextTokenStream tokens = new ObservableXtextTokenStream(tokenSource, (ITokenDefProvider)parser);
        tokens.setInitialHiddenTokens(this.getInitialHiddenTokens());
        parser.setTokenStream((TokenStream)tokens);
        IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.getUnorderedGroupHelper().get();
        parser.setUnorderedGroupHelper(helper);
        helper.initializeWith((BaseRecognizer)parser);
        tokens.setListener((ObservableXtextTokenStream.StreamListener)parser);
        try {
            return Lists.newArrayList(this.getFollowElements(parser));
        }
        catch (InfiniteRecursion infiniteRecursion) {
            return Lists.newArrayList((Iterable)parser.getFollowElements());
        }
    }

    private TokenSource modifyInputIfDanglingJSON(String input) {
        TokenSource tokenSource;
        String lastStatement;
        boolean danglingJsonEndsInput = false;
        String[] lines = input.split(";");
        if (lines.length > 0 && this.danglingJsonStringPattern.matcher(lastStatement = lines[lines.length - 1].trim()).matches()) {
            input = String.valueOf(lines[lines.length - 1]) + "'";
            danglingJsonEndsInput = true;
        }
        if ((tokenSource = this.createTokenSource(input)) instanceof UICustomCqlLexer) {
            ((UICustomCqlLexer)tokenSource).setSyntheticEndQuote(danglingJsonEndsInput);
        }
        return tokenSource;
    }
}

