/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.binding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;

public class BindingBuilder {
    private final DataBindingContext ctx;
    private final IObservableValue target;
    private final IObservableValue model;
    private UpdatePolicy targetToModelUpdatePolicy = UpdatePolicy.UPDATE;
    private UpdatePolicy modelToTargetUpdatePolicy = UpdatePolicy.UPDATE;
    private IValidator targetToModelAfterGetValidator;
    private IValidator modelToTargetAfterGetValidator;
    private IValidator targetToModelBeforeSetValidator;
    private IValidator modelToTargetBeforeSetValidator;
    private IConverter targetToModelConverter;
    private IConverter modelToTargetConverter;
    private int controlDecorationStyle;

    public BindingBuilder(DataBindingContext ctx, IObservableValue target, IObservableValue model) {
        this.ctx = ctx;
        this.target = target;
        this.model = model;
    }

    public BindingBuilder withTargetToModelUpdatePolicy(UpdatePolicy policy) {
        this.targetToModelUpdatePolicy = policy;
        return this;
    }

    public BindingBuilder withModelToTargetUpdatePolicy(UpdatePolicy policy) {
        this.modelToTargetUpdatePolicy = policy;
        return this;
    }

    public BindingBuilder withTargetToModelBeforeSetValidator(IValidator validator) {
        this.targetToModelBeforeSetValidator = validator;
        return this;
    }

    public BindingBuilder withModelToTargetBeforeSetValidator(IValidator validator) {
        this.modelToTargetBeforeSetValidator = validator;
        return this;
    }

    public BindingBuilder withTargetToModelAfterGetValidator(IValidator validator) {
        this.targetToModelAfterGetValidator = validator;
        return this;
    }

    public BindingBuilder withModelToTargetAfterGetValidator(IValidator validator) {
        this.modelToTargetAfterGetValidator = validator;
        return this;
    }

    public BindingBuilder withTargetToModelConverter(IConverter targetToModelConverter) {
        this.targetToModelConverter = targetToModelConverter;
        return this;
    }

    public BindingBuilder withModelToTargetConverter(IConverter modelToTargetConverter) {
        this.modelToTargetConverter = modelToTargetConverter;
        return this;
    }

    public BindingBuilder withControlDecoration(int style) {
        this.controlDecorationStyle = style;
        return this;
    }

    public Binding build() {
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(this.targetToModelUpdatePolicy.value());
        targetToModel.setAfterGetValidator(this.targetToModelAfterGetValidator);
        targetToModel.setBeforeSetValidator(this.targetToModelBeforeSetValidator);
        targetToModel.setConverter(this.targetToModelConverter);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(this.modelToTargetUpdatePolicy.value());
        modelToTarget.setAfterGetValidator(this.modelToTargetAfterGetValidator);
        modelToTarget.setBeforeSetValidator(this.modelToTargetBeforeSetValidator);
        modelToTarget.setConverter(this.modelToTargetConverter);
        Binding bindValue = this.ctx.bindValue(this.target, this.model, targetToModel, modelToTarget);
        if (this.controlDecorationStyle != 0) {
            ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)this.controlDecorationStyle);
        }
        return bindValue;
    }

    public static enum UpdatePolicy {
        NEVER(UpdateValueStrategy.POLICY_NEVER),
        ON_REQUEST(UpdateValueStrategy.POLICY_ON_REQUEST),
        CONVERT(UpdateValueStrategy.POLICY_CONVERT),
        UPDATE(UpdateValueStrategy.POLICY_UPDATE);

        private int value;

        private UpdatePolicy(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

