/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.binding;

import com.datastax.devcenter.cql.ui.databinding.binding.BindingCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;

public abstract class MultiBinding<T, M> {
    protected static final BindingCategory MODEL = new BindingCategory();
    protected static final BindingCategory TARGET = new BindingCategory();
    protected static final BindingCategory MODEL_TO_TARGET = new BindingCategory();
    protected static final BindingCategory TARGET_TO_MODEL = new BindingCategory();
    protected final DataBindingContext ctx;
    protected final T target;
    protected final M model;
    protected IConverter targetToModelConverter;
    protected IConverter modelToTargetConverter;
    private final Map<BindingCategory, List<Binding>> bindingsByCategory = new HashMap<BindingCategory, List<Binding>>();

    public MultiBinding(DataBindingContext ctx, T target, M model) {
        this.ctx = ctx;
        this.model = model;
        this.target = target;
    }

    public T getTarget() {
        return this.target;
    }

    public M getModel() {
        return this.model;
    }

    public void setTargetToModelConverter(IConverter targetToModelConverter) {
        this.targetToModelConverter = targetToModelConverter;
    }

    public void setModelToTargetConverter(IConverter modelToTargetConverter) {
        this.modelToTargetConverter = modelToTargetConverter;
    }

    public void bind() {
        this.bindModel();
        this.bindModelToTarget();
        this.bindTarget();
        this.bindTargetToModel();
    }

    public void updateTarget() {
        this.updateBindings(TARGET);
    }

    public void updateModel() {
        this.updateBindings(MODEL);
    }

    public void updateTargetToModel() {
        this.updateBindings(TARGET_TO_MODEL);
    }

    public void updateModelToTarget() {
        this.updateBindings(MODEL_TO_TARGET);
    }

    protected void updateBindings(BindingCategory category) {
        List<Binding> bindings = this.getBindings(category);
        if (bindings != null) {
            for (Binding binding : bindings) {
                binding.updateTargetToModel();
            }
        }
    }

    protected void bindTarget() {
    }

    protected void bindModel() {
    }

    protected void bindModelToTarget() {
    }

    protected void bindTargetToModel() {
    }

    protected void addBinding(BindingCategory category, Binding binding) {
        List<Binding> bindings = this.bindingsByCategory.get(category);
        if (bindings == null) {
            bindings = new ArrayList<Binding>();
            this.bindingsByCategory.put(category, bindings);
        }
        bindings.add(binding);
    }

    protected void addBindings(BindingCategory category, List<Binding> bindings) {
        for (Binding binding : bindings) {
            this.addBinding(category, binding);
        }
    }

    protected List<Binding> getBindings(BindingCategory category) {
        return this.bindingsByCategory.get(category);
    }
}

