/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.binding;

import com.datastax.devcenter.cql.ui.databinding.binding.BindingBuilder;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.RadioOption;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;

public class NullableResettableRadioGroupBinding
extends NullableResettableBinding {
    public NullableResettableRadioGroupBinding(DataBindingContext ctx, NullableRadioGroup target, ResettableGroup model) {
        super(ctx, target, model);
    }

    @Override
    public void bind() {
        super.bind();
        this.setRadioGroupValueIfNull();
    }

    @Override
    protected void bindTarget() {
        super.bindTarget();
        this.bindRadioGroup();
    }

    protected void bindRadioGroup() {
        NullableRadioGroup target = (NullableRadioGroup)this.target;
        for (RadioOption option : target.getOptions()) {
            this.bindRadioButton(option);
        }
    }

    protected void bindRadioButton(RadioOption option) {
        NullableRadioGroup target = (NullableRadioGroup)this.target;
        target.getRadioGroupValue().addOption(option.getValue(), option.getSelected());
        this.addBinding(TARGET, new BindingBuilder(this.ctx, target.getEnabled(), option.getEnabled()).withTargetToModelUpdatePolicy(BindingBuilder.UpdatePolicy.UPDATE).withModelToTargetUpdatePolicy(BindingBuilder.UpdatePolicy.NEVER).build());
    }

    protected void setRadioGroupValueIfNull() {
        NullableRadioGroup target = (NullableRadioGroup)this.target;
        SelectObservableValue groupValue = target.getRadioGroupValue();
        if (groupValue.getValue() == null) {
            groupValue.setValue(target.getOptions().get(0).getValue());
        }
    }
}

