/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.binding;

import com.datastax.devcenter.cql.ui.databinding.observable.IfThenElse;
import com.datastax.devcenter.cql.ui.databinding.observable.IsNull;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class ResettableGroup {
    protected final IObservableValue currentValue;
    protected final IObservableValue initialValue;
    protected final IObservableValue defaultValue;
    protected final IObservableValue currentOrDefaultValue;
    protected final IObservableValue initialOrDefaultValue;

    public ResettableGroup(IObservableValue currentValue, IObservableValue initialValue, IObservableValue defaultValue) {
        this.currentValue = currentValue;
        this.initialValue = initialValue;
        this.defaultValue = defaultValue;
        this.currentOrDefaultValue = new IfThenElse((IObservableValue)new IsNull(currentValue), defaultValue, currentValue);
        this.initialOrDefaultValue = new IfThenElse((IObservableValue)new IsNull(initialValue), defaultValue, initialValue);
    }

    public void addChangeListener(IChangeListener listener) {
        this.currentValue.addChangeListener(listener);
    }

    public IObservableValue getDefaultValue() {
        return this.defaultValue;
    }

    public IObservableValue getInitialValue() {
        return this.initialValue;
    }

    public IObservableValue getCurrentValue() {
        return this.currentValue;
    }

    public IObservableValue getCurrentOrDefaultValue() {
        return this.currentOrDefaultValue;
    }

    public IObservableValue getInitialOrDefaultValue() {
        return this.initialOrDefaultValue;
    }
}

