/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.conversion;

import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StringToCqlDataTypeConverter
extends Converter {
    private final ISelectionProvider keyspaceProvider;
    private final TypeParser typeParser;

    public StringToCqlDataTypeConverter(ISelectionProvider keyspaceProvider, TypeParser typeParser) {
        super(String.class, CqlDataType.class);
        this.keyspaceProvider = keyspaceProvider;
        this.typeParser = typeParser;
    }

    public CqlDataType convert(Object expression) {
        IStructuredSelection selection = (IStructuredSelection)this.keyspaceProvider.getSelection();
        Keyspace keyspace = (Keyspace)selection.getFirstElement();
        Type type = this.typeParser.parse((String)expression);
        CqlDataType dataType = CqlDataTypeFactory.fromGrammarType((Type)type, (Keyspace)keyspace);
        if (dataType.isUnknown()) {
            return null;
        }
        return dataType;
    }
}

