/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.observable;

import com.datastax.devcenter.schema.options.QuantifiableRowsCaching;
import com.datastax.devcenter.schema.options.RowsCaching;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;

public class RowsCachingObservable
extends ComputedValue {
    private final SelectObservableValue allNoneOrOther;
    private final IObservableValue numberOfRows;

    public RowsCachingObservable(IObservableValue numberOfRows) {
        this(new SelectObservableValue(RowsCaching.class), numberOfRows);
    }

    public RowsCachingObservable(SelectObservableValue allNoneOrOther, IObservableValue numberOfRows) {
        super(RowsCaching.class);
        this.allNoneOrOther = allNoneOrOther;
        this.numberOfRows = numberOfRows;
    }

    protected RowsCaching calculate() {
        RowsCaching value = (RowsCaching)this.allNoneOrOther.getValue();
        if (value == RowsCaching.ALL || value == RowsCaching.NONE) {
            return value;
        }
        int rowsPerPartition = (Integer)this.numberOfRows.getValue();
        return new QuantifiableRowsCaching(rowsPerPartition);
    }

    public SelectObservableValue getAllNoneOrOther() {
        return this.allNoneOrOther;
    }

    public IObservableValue getNumberOfRows() {
        return this.numberOfRows;
    }
}

