/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.observable;

import com.datastax.devcenter.schema.options.MillisecondsSpeculativeRetry;
import com.datastax.devcenter.schema.options.PercentileSpeculativeRetry;
import com.datastax.devcenter.schema.options.SpeculativeRetry;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;

public class SpeculativeRetryObservable
extends ComputedValue {
    private final SelectObservableValue speculativeRetryOptions = new SelectObservableValue(SpeculativeRetry.class);
    private final IObservableValue percentileValue;
    private final IObservableValue millisecondsValue;
    private Class<?> speculativeRetryType;

    public SpeculativeRetryObservable(IObservableValue percentileValue, IObservableValue millisecondsValue) {
        super(SpeculativeRetry.class);
        this.percentileValue = percentileValue;
        this.millisecondsValue = millisecondsValue;
    }

    protected SpeculativeRetry calculate() {
        SpeculativeRetry value = (SpeculativeRetry)this.speculativeRetryOptions.getValue();
        if (value == SpeculativeRetry.ALWAYS || value == SpeculativeRetry.NONE) {
            return value;
        }
        if (value == SpeculativeRetry.PERCENTILE) {
            return new PercentileSpeculativeRetry((double)((Integer)this.percentileValue.getValue()).intValue());
        }
        if (value == SpeculativeRetry.MILLISECONDS) {
            return new MillisecondsSpeculativeRetry(((Integer)this.millisecondsValue.getValue()).intValue());
        }
        if (this.speculativeRetryType == PercentileSpeculativeRetry.class) {
            return new PercentileSpeculativeRetry((double)((Integer)this.percentileValue.getValue()).intValue());
        }
        if (this.speculativeRetryType == MillisecondsSpeculativeRetry.class) {
            return new MillisecondsSpeculativeRetry(((Integer)this.millisecondsValue.getValue()).intValue());
        }
        return null;
    }

    public SelectObservableValue getSpeculativeRetryOptions() {
        return this.speculativeRetryOptions;
    }

    public IObservableValue getPercentileValue() {
        return this.percentileValue;
    }

    public IObservableValue getMillisecondsValue() {
        return this.millisecondsValue;
    }

    public void setBindClassHint(Class<?> speculativeRetryType) {
        this.speculativeRetryType = speculativeRetryType;
    }
}

