/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.validation;

import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.ListCqlDataType;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.TupleCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CqlDataTypeValidator
implements IValidator {
    private final ISelectionProvider keyspaceProvider;
    private final TypeParser typeParser;

    public CqlDataTypeValidator(ISelectionProvider keyspaceProvider, TypeParser typeParser) {
        this.keyspaceProvider = keyspaceProvider;
        this.typeParser = typeParser;
    }

    public IStatus validate(Object value) {
        IStructuredSelection selection = (IStructuredSelection)this.keyspaceProvider.getSelection();
        Keyspace keyspace = (Keyspace)selection.getFirstElement();
        Type type = this.typeParser.parse((String)value);
        CqlDataType dataType = CqlDataTypeFactory.fromGrammarType((Type)type, (Keyspace)keyspace);
        return this.validateType(dataType);
    }

    protected IStatus validateType(CqlDataType dataType) {
        IStatus status = ValidationStatus.ok();
        if (dataType == UnknownCqlDataType.INSTANCE) {
            status = ValidationStatus.error((String)"Invalid CQL data type");
        } else if (dataType.isList()) {
            status = this.validateType(((ListCqlDataType)dataType).getElementType());
        } else if (dataType.isSet()) {
            status = this.validateType(((CollectionCqlDataType)dataType).getElementType());
        } else if (dataType.isMap()) {
            status = this.validateType(((MapCqlDataType)dataType).getKeyType());
            if (status.isOK()) {
                status = this.validateType(((MapCqlDataType)dataType).getElementType());
            }
        } else if (dataType.isTuple()) {
            for (CqlDataType tupleType : ((TupleCqlDataType)dataType).getInnerTypes()) {
                status = this.validateType(tupleType);
                if (status.isOK()) {
                    continue;
                }
                break;
            }
        } else if (dataType.isUserDefinedType() && ((UserDefinedTypeCqlDataType)dataType).getUserType() == null) {
            status = ValidationStatus.error((String)String.format("Type doesn't exist", new Object[0]));
        }
        return status;
    }
}

