/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.validation;

import com.datastax.devcenter.common.utils.ConversionHelper;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class EnumValidator<T extends Enum<T>>
implements IValidator {
    private final Class<T> enumClass;
    private final String message;

    public EnumValidator(Class<T> enumClass, String message) {
        this.enumClass = enumClass;
        this.message = message;
    }

    public IStatus validate(Object value) {
        if (value == null) {
            return ValidationStatus.ok();
        }
        try {
            ConversionHelper.convert((Object)value, this.enumClass);
        }
        catch (Exception exception) {
            return ValidationStatus.error((String)this.message);
        }
        return ValidationStatus.ok();
    }
}

