/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.databinding.validation;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class IdentifierValidator
implements IValidator {
    private final String identifierType;
    private final Pattern pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*");
    private boolean ignoreEmpty;

    public IdentifierValidator(String identifierType) {
        this.identifierType = identifierType;
    }

    protected IdentifierValidator(String identifierType, boolean ignoreEmpty) {
        this.identifierType = identifierType;
        this.ignoreEmpty = ignoreEmpty;
    }

    public IStatus validate(Object value) {
        if (value == null || !(value instanceof String)) {
            return ValidationStatus.error((String)(String.valueOf(this.identifierType) + " is not valid"));
        }
        String identifier = (String)value;
        if (this.ignoreEmpty && identifier.isEmpty()) {
            return ValidationStatus.ok();
        }
        if (identifier.isEmpty()) {
            return ValidationStatus.error((String)(String.valueOf(this.identifierType) + " cannot be empty"));
        }
        return this.validateIdentifier(identifier);
    }

    protected IStatus validateIdentifier(String identifier) {
        char firstChar = identifier.charAt(0);
        if (!(firstChar >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z')) {
            return ValidationStatus.error((String)String.format("%s must start with a letter", this.identifierType));
        }
        if (!this.pattern.matcher(identifier).matches()) {
            return ValidationStatus.error((String)String.format("%s must contain only letters, digits and underscores", this.identifierType));
        }
        return ValidationStatus.ok();
    }
}

