/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.common.status.StatusCompositeProgressMonitor;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionProvider;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TypoStatement;
import com.datastax.devcenter.cql.managers.CqlFilesScriptsManager;
import com.datastax.devcenter.cql.ui.CqlActivator;
import com.datastax.devcenter.cql.ui.editor.toolbar.CqlEditorToolbar;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import com.datastax.devcenter.schema.StatementIndexMap;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CqlEditorPart
extends XtextEditor
implements ConnectionProvider,
KeyspaceProvider {
    public static final String ID = "com.datastax.devcenter.cql.Cql";
    @Inject
    private CqlContextProvider contextProvider;
    @Inject
    private ISerializer serializer;
    private IEditorInput iEditorInput;
    private SashForm scriptAndResultsSashForm;
    private SashForm resultsAndDetailsSashForm;
    private CTabFolder resultsCTabFolder;
    private CTabItem resultsCTabItem;
    private CTabItem traceCTabItem;
    private StatusCompositeProgressMonitor cqlStatusCompositeProgressMonitor;
    private CqlEditorToolbar toolBar;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.iEditorInput = input;
    }

    public void createPartControl(Composite parentComposite) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        parentComposite.setLayout((Layout)gridLayout);
        this.toolBar = new CqlEditorToolbar(parentComposite, this);
        this.toolBar.setLayoutData(new GridData(4, 2, true, false));
        this.scriptAndResultsSashForm = this.prepareSashForm(parentComposite);
        super.createPartControl((Composite)this.scriptAndResultsSashForm);
        this.resultsCTabFolder = this.prepareCTabFolder(this.scriptAndResultsSashForm);
        this.scriptAndResultsSashForm.setWeights(new int[]{65, 35});
        this.cqlStatusCompositeProgressMonitor = this.prepareStatusComposite(parentComposite);
        this.displayPartNameInEditorTab();
        this.toolBar.init();
        this.addExecuteButtonTooltipSelectionListener();
    }

    private void addExecuteButtonTooltipSelectionListener() {
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITextSelection textSelection = (ITextSelection)event.getSelection();
                if (textSelection.getLength() > 0) {
                    CqlEditorPart.this.toolBar.setExecuteSelectedStatementTooltip();
                } else {
                    CqlEditorPart.this.toolBar.setExecuteCqlScriptTooltip();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.toolBar.dispose();
    }

    private SashForm prepareSashForm(Composite parentComposite) {
        SashForm sashForm = new SashForm(parentComposite, 512);
        sashForm.SASH_WIDTH = 6;
        GridData sashFormGridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)sashFormGridData);
        return sashForm;
    }

    private CTabFolder prepareCTabFolder(final SashForm sashForm) {
        final CTabFolder cTabFolder = new CTabFolder((Composite)sashForm, 0x800000);
        cTabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        cTabFolder.setBorderVisible(true);
        cTabFolder.setMinimizeVisible(true);
        cTabFolder.setMaximizeVisible(true);
        cTabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void showList(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
                cTabFolder.setMinimized(false);
                cTabFolder.setMaximized(false);
                sashForm.setMaximizedControl(null);
                sashForm.setWeights(new int[]{65, 35});
            }

            public void minimize(CTabFolderEvent event) {
                cTabFolder.setMinimized(true);
                sashForm.setMaximizedControl(null);
                sashForm.setWeights(new int[]{95, 5});
            }

            public void maximize(CTabFolderEvent event) {
                cTabFolder.setMaximized(true);
                sashForm.setMaximizedControl((Control)cTabFolder);
            }

            public void close(CTabFolderEvent event) {
            }
        });
        this.resultsCTabItem = new CTabItem(cTabFolder, 0);
        this.resultsCTabItem.setText("Results");
        this.resultsCTabItem.setToolTipText("Results of the last executed statement");
        this.traceCTabItem = new CTabItem(cTabFolder, 0);
        this.traceCTabItem.setText("Query Trace");
        this.traceCTabItem.setToolTipText("Trace of the last executed statement");
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (cTabFolder.getSelection() == CqlEditorPart.this.traceCTabItem) {
                    Metrics.incrementCounter((String)"query_trace_tab_selected_count");
                }
            }
        });
        return cTabFolder;
    }

    private StatusCompositeProgressMonitor prepareStatusComposite(Composite parentComposite) {
        StatusCompositeProgressMonitor compositeProgressMonitor = new StatusCompositeProgressMonitor(parentComposite, 0);
        GridData statusCompositeGridData = new GridData(768);
        compositeProgressMonitor.setLayoutData((Object)statusCompositeGridData);
        return compositeProgressMonitor;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        String partName = this.getPartName();
        boolean defaultFlag = StringUtils.startsWith((String)partName, (String)"default");
        if (defaultFlag) {
            this.performSaveAs(iProgressMonitor);
        } else {
            super.doSave(iProgressMonitor);
        }
    }

    public void displayPartNameInEditorTab() {
        if (this.iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.setPartName(iFile.getFullPath().lastSegment());
        } else if (this.iEditorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)this.iEditorInput;
            this.setPartName(fileStoreEditorInput.getName());
        } else {
            this.setPartName("default.cql");
            Metrics.incrementCounter((String)"open_file_menu_count");
        }
    }

    public StatusCompositeProgressMonitor getCqlStatusCompositeProgressMonitor() {
        return this.cqlStatusCompositeProgressMonitor;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        IEditorInput input = this.getEditorInput();
        IDocumentProvider provider = this.getDocumentProvider();
        String currentURI = this.getDocumentURI();
        CqlFilesScriptsManager manager = CqlActivator.getCqlFilesScriptsManager();
        InputDialog dialog = new InputDialog(shell, "Save CQL script as", "File name of the CQL script to save:", null, (IInputValidator)manager);
        if (dialog.open() != 0) {
            progressMonitor.setCanceled(true);
            return;
        }
        try {
            try {
                boolean success;
                block19: {
                    IFile cqlScriptIFile = manager.saveDocumentToFile(dialog.getValue(), (IDocument)this.getDocument());
                    success = false;
                    try {
                        try {
                            provider.aboutToChange((Object)cqlScriptIFile);
                            provider.saveDocument(progressMonitor, (Object)cqlScriptIFile, provider.getDocument((Object)input), true);
                            success = true;
                        }
                        catch (CoreException x) {
                            IStatus status = x.getStatus();
                            if (status == null || status.getSeverity() != 8) {
                                MessageDialog.openError((Shell)shell, (String)"CoreException during Save", (String)x.toString());
                            }
                            provider.changed((Object)cqlScriptIFile);
                            if (success) {
                                FileEditorInput fileEditorInput = new FileEditorInput(cqlScriptIFile);
                                super.setInput((IEditorInput)fileEditorInput);
                                String newURI = this.getDocumentURI();
                                if (!currentURI.equals(newURI)) {
                                    this.contextProvider.renameResource(currentURI, newURI);
                                    this.triggerValidation();
                                }
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        provider.changed((Object)cqlScriptIFile);
                        if (success) {
                            FileEditorInput fileEditorInput = new FileEditorInput(cqlScriptIFile);
                            super.setInput((IEditorInput)fileEditorInput);
                            String newURI = this.getDocumentURI();
                            if (!currentURI.equals(newURI)) {
                                this.contextProvider.renameResource(currentURI, newURI);
                                this.triggerValidation();
                            }
                        }
                        throw throwable;
                    }
                    provider.changed((Object)cqlScriptIFile);
                    if (success) {
                        FileEditorInput fileEditorInput = new FileEditorInput(cqlScriptIFile);
                        super.setInput((IEditorInput)fileEditorInput);
                        String newURI = this.getDocumentURI();
                        if (!currentURI.equals(newURI)) {
                            this.contextProvider.renameResource(currentURI, newURI);
                            this.triggerValidation();
                        }
                    }
                }
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(!success);
                }
            }
            catch (Exception e) {
                DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                CqlActivator.getCqlFilesScriptsManager().notifyScriptsFolderChanged();
            }
        }
        finally {
            CqlActivator.getCqlFilesScriptsManager().notifyScriptsFolderChanged();
        }
    }

    public void updateConnectionAndRevalidate(Connection connection) {
        CqlContext cqlContext = this.getContext();
        try {
            cqlContext.updateDatabaseSchemaAndReset(connection);
            List statements = (List)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<CqlStatement>, XtextResource>(){

                public List<CqlStatement> exec(XtextResource resource) throws Exception {
                    return CqlEditorPart.getAllStatements(resource);
                }
            });
            cqlContext.updateStatementIndexMap(statements);
        }
        catch (Exception exception) {}
        this.triggerValidation();
    }

    private void triggerValidation() {
        ((XtextDocument)this.getDocument()).checkAndUpdateAnnotations();
    }

    public void appendText(final String contents) {
        final IXtextDocument document = this.getDocument();
        final String current = document.get();
        final boolean appendNewline = !current.isEmpty() && !current.endsWith("\n");
        int eof = appendNewline ? document.getLength() + 1 : document.getLength();
        document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
                document.set(String.valueOf(current) + (appendNewline ? "\n" + contents : contents));
            }
        });
        StyledText widget = this.getInternalSourceViewer().getTextWidget();
        widget.setCaretOffset(eof);
        widget.setSelectionRange(eof, document.getLength());
        this.selectAndReveal(eof, document.getLength());
    }

    public List<INode> getSyntaxErrors(final List<CqlStatement> statements) {
        return (List)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<INode>, XtextResource>(){

            public List<INode> exec(XtextResource resource) {
                ArrayList<INode> errors = new ArrayList<INode>();
                if (resource.getParseResult() != null) {
                    for (INode error : resource.getParseResult().getSyntaxErrors()) {
                        if (!CqlEditorPart.this.anyStatementContainsNode(statements, error)) continue;
                        errors.add(error);
                    }
                }
                Collection typos = EcoreUtil.getObjectsByType((Collection)statements, (EClassifier)CqlPackage.Literals.TYPO_STATEMENT);
                errors.addAll(Collections2.transform((Collection)typos, (Function)new Function<TypoStatement, INode>(){

                    public INode apply(TypoStatement input) {
                        return NodeModelUtils.getNode((EObject)input);
                    }
                }));
                Collections.sort(errors, new Comparator<INode>(){

                    @Override
                    public int compare(INode n1, INode n2) {
                        int o2;
                        int o1 = n1.getOffset();
                        return o1 < (o2 = n2.getOffset()) ? -1 : (o1 == o2 ? 0 : 1);
                    }
                });
                return errors;
            }
        });
    }

    protected boolean anyStatementContainsNode(List<CqlStatement> statements, INode node) {
        for (CqlStatement stmt : statements) {
            ICompositeNode stmtNode = NodeModelUtils.getNode((EObject)stmt);
            if (!ModelUtil.nodeContainsOtherNode((INode)stmtNode, (INode)node)) continue;
            return true;
        }
        return false;
    }

    private String getDocumentURI() {
        return ((URI)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<URI, XtextResource>(){

            public URI exec(XtextResource resource) {
                return resource.getURI();
            }
        })).toString();
    }

    public List<CqlStatement> getStatementList() {
        return (List)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<CqlStatement>, XtextResource>(){

            public List<CqlStatement> exec(XtextResource resource) {
                ITextSelection textSelection = (ITextSelection)CqlEditorPart.this.getSelectionProvider().getSelection();
                List cqlStatements = textSelection.getLength() > 0 ? CqlEditorPart.this.getSelectedStatements(textSelection) : CqlEditorPart.getAllStatements(resource);
                return cqlStatements;
            }
        });
    }

    private static List<CqlStatement> getAllStatements(XtextResource resource) {
        EList cqlStatements = new ArrayList();
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof Statements)) continue;
            cqlStatements = ((Statements)obj).getStatements();
        }
        return cqlStatements;
    }

    private List<CqlStatement> getSelectedStatements(ITextSelection textSelection) {
        int startOffset = textSelection.getOffset();
        int endOffset = startOffset + textSelection.getLength();
        StatementIndexMap statementIndexMap = this.getContext().getStatementIndexMap();
        List selectedStatements = statementIndexMap.getStatementsIntersectingRange(startOffset, endOffset);
        this.setSelectionToStatements(textSelection, selectedStatements);
        return selectedStatements;
    }

    private void setSelectionToStatements(ITextSelection textSelection, List<CqlStatement> cqlStatements) {
        int lastStmtIndex = cqlStatements.size() - 1;
        if (lastStmtIndex >= 0) {
            int firstStatementStartOffset = NodeModelUtils.getNode((EObject)((EObject)cqlStatements.get(0))).getOffset();
            int lastStatementStartOffset = NodeModelUtils.getNode((EObject)((EObject)cqlStatements.get(lastStmtIndex))).getOffset();
            int lastStatementLength = NodeModelUtils.getNode((EObject)((EObject)cqlStatements.get(lastStmtIndex))).getLength();
            TextSelection selection = new TextSelection(firstStatementStartOffset, lastStatementStartOffset - firstStatementStartOffset + lastStatementLength);
            this.getSelectionProvider().setSelection((ISelection)selection);
        }
    }

    public List<String> getStringValue(List<CqlStatement> cqlStatements) {
        ArrayList<String> statementStrings = new ArrayList<String>();
        for (CqlStatement cqlStatement : cqlStatements) {
            statementStrings.add(this.getStringValue(cqlStatement));
        }
        return statementStrings;
    }

    public String getStringValue(CqlStatement cqlStatement) {
        if (!(cqlStatement instanceof SelectStatement)) {
            return this.serializer.serialize((EObject)cqlStatement).trim();
        }
        SelectStatement select = (SelectStatement)cqlStatement;
        if (select.getLimit() == null || select.getLimit().isEmpty()) {
            select.setLimit(Integer.toString(this.toolBar.getRowLimit()));
            String statementString = this.serializer.serialize((EObject)cqlStatement).trim();
            select.setLimit(null);
            return statementString;
        }
        return this.serializer.serialize((EObject)cqlStatement).trim();
    }

    public CqlContext getContext() {
        String uri = this.getDocumentURI();
        return this.contextProvider.get(uri);
    }

    public Connection getConnection() {
        return this.toolBar.getSelectedConnection();
    }

    public void setConnection(Connection connection) {
        this.toolBar.setSelectedConnection(connection);
    }

    public Keyspace getKeyspace() {
        return this.getContext().getLastSchema().getDefaultKeyspace();
    }

    public String getSelectedKeyspace() {
        return this.toolBar.getSelectedKeyspace();
    }

    public boolean canExecuteCqlScript() {
        return this.toolBar.getValidationStatus().isOK();
    }

    public void setEnableExecuteCqlScript(boolean enabled) {
        this.toolBar.setEnableExecuteCqlScript(enabled);
    }

    public void updateDefaultKeyspace(String keyspaceName) {
        this.getContext().setDefaultKeyspaceName(keyspaceName);
    }

    public SashForm getResultsAndDetailsSashForm() {
        return this.resultsAndDetailsSashForm;
    }

    public boolean isTracingEnabled() {
        return true;
    }

    public CTabFolder getResultsTabFolder() {
        return this.resultsCTabFolder;
    }

    public CTabItem getResultsTabItem() {
        return this.resultsCTabItem;
    }

    public CTabItem getTraceTabItem() {
        return this.traceCTabItem;
    }

    public boolean editorContainsSelection() {
        return ((ITextSelection)this.getSelectionProvider().getSelection()).getLength() > 0;
    }
}

