/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.editor.embedded;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorResourceProvider;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorValidationIssueProcessor;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorValidationStatusProvider;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.hover.ProblemAnnotationHover;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.IResourceValidator;

public class EmbeddedCqlEditor {
    @Inject
    private CqlContextProvider contextProvider;
    @Inject
    private EmbeddedEditorFactory factory;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private ITokenTypeToPartitionTypeMapper partitionTypesMapper;
    @Inject
    private ProblemAnnotationHover problemAnnotationHover;
    @Inject
    private EmbeddedCqlEditorResourceProvider resourceProvider;
    private EmbeddedCqlEditorValidationIssueProcessor issueProcessor;
    private EmbeddedEditor editor;
    private EmbeddedEditorModelAccess partialEditor;
    private XtextSourceViewer viewer;

    public EmbeddedCqlEditorValidationIssueProcessor getValidationIssueProcessor() {
        return this.issueProcessor;
    }

    public EmbeddedCqlEditorValidationStatusProvider createValidationStatusProvider() {
        return new EmbeddedCqlEditorValidationStatusProvider(this.getValidationIssueProcessor());
    }

    public XtextSourceViewer getViewer() {
        return this.viewer;
    }

    public CqlContext getCqlContext() {
        URI uri = (URI)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<URI, XtextResource>(){

            public URI exec(XtextResource state) throws Exception {
                return state.getURI();
            }
        });
        return this.contextProvider.get(uri);
    }

    public void createControl(Composite container) {
        String[] types;
        this.issueProcessor = new EmbeddedCqlEditorValidationIssueProcessor(Realm.getDefault());
        this.editor = this.factory.newEditor((IEditedResourceProvider)this.resourceProvider).readOnly().withResourceValidator(this.resourceValidator).processIssuesBy((IValidationIssueProcessor)this.issueProcessor).withParent(container);
        this.partialEditor = this.editor.createPartialEditor();
        this.viewer = this.editor.getViewer();
        this.problemAnnotationHover.setSourceViewer((ISourceViewer)this.viewer);
        String[] stringArray = types = this.partitionTypesMapper.getSupportedPartitionTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.viewer.setTextHover((ITextHover)this.problemAnnotationHover, type);
            ++n2;
        }
        this.viewer.getTextWidget().setFont(JFaceResources.getTextFont());
    }

    public void updateContents(String text) {
        if (this.partialEditor != null) {
            this.partialEditor.updateModel("", text, "");
            this.viewer.setSelectedRange(0, 0);
        }
    }

    public void revalidate() {
        if (this.editor != null) {
            this.editor.getDocument().checkAndUpdateAnnotations();
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.getDocument().disposeInput();
        }
        this.editor = null;
        this.factory = null;
        this.resourceValidator = null;
    }

    public void addModelListener(IXtextModelListener listener) {
        this.editor.getDocument().addModelListener(listener);
    }
}

